/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.references.PyFromImportNameReference;
import com.jetbrains.python.psi.impl.references.PyFromImportSourceReference;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportReference
extends PyReferenceImpl {
    protected final PyReferenceExpressionImpl myElement;

    public PyImportReference(PyReferenceExpressionImpl element, PyResolveContext context) {
        super(element, context);
        this.myElement = element;
    }

    public static PyImportReference forElement(PyReferenceExpressionImpl expression, PsiElement importParent, PyResolveContext context) {
        if (importParent instanceof PyImportElement) {
            PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)importParent, PyImportStatementBase.class);
            if (importStatement instanceof PyFromImportStatement) {
                return new PyFromImportNameReference(expression, context);
            }
            return new PyImportReference(expression, context);
        }
        return new PyFromImportSourceReference(expression, context);
    }

    @Override
    public String getUnresolvedDescription() {
        PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportStatement.class);
        if (importStatement != null) {
            return "No module named " + this.myElement.getReferencedName();
        }
        return super.getUnresolvedDescription();
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        PyImportElement parent = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportElement.class);
        QualifiedName qname = this.myElement.asQualifiedName();
        List<RatedResolveResult> list2 = qname == null ? Collections.emptyList() : ResolveImportUtil.resolveNameInImportStatement(parent, qname);
        if (list2 == null) {
            PyImportReference.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        PsiErrorElement prevError;
        PyImportElement importElement = (PyImportElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportElement.class);
        if (importElement != null && (prevError = (PsiErrorElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)importElement, PsiErrorElement.class)) != null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PyImportReference.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        TypeEvalContext context = TypeEvalContext.codeCompletion(this.myElement.getProject(), CompletionUtil.getOriginalOrSelf(this.myElement).getContainingFile());
        if (qualifier != null) {
            PyType type = context.getType(qualifier);
            if (type != null) {
                Object[] variants = PyImportReference.getTypeCompletionVariants(this.myElement, type);
                if (!this.alreadyHasImportKeyword()) {
                    PyImportReference.replaceInsertHandler(variants, ImportKeywordHandler.INSTANCE);
                }
                if (variants == null) {
                    PyImportReference.$$$reportNull$$$0(2);
                }
                return variants;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                PyImportReference.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = new ImportVariantCollector(context).execute();
        if (objectArray == null) {
            PyImportReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static void replaceInsertHandler(Object[] variants, InsertHandler<LookupElement> insertHandler) {
        for (int i = 0; i < variants.length; ++i) {
            Object item = variants[i];
            if (PyImportReference.hasChildPackages(item)) continue;
            if (item instanceof LookupElementBuilder) {
                variants[i] = ((LookupElementBuilder)item).withInsertHandler(insertHandler);
                continue;
            }
            if (!(item instanceof PsiNamedElement)) continue;
            PsiNamedElement element = (PsiNamedElement)item;
            String name = element.getName();
            assert (name != null);
            variants[i] = LookupElementBuilder.create((String)name).withIcon(element.getIcon(0)).withInsertHandler(insertHandler);
        }
    }

    private static boolean hasChildPackages(Object item) {
        LookupElement lookupElement;
        PsiElement element;
        PsiElement itemElement = null;
        if (item instanceof PsiElement) {
            itemElement = (PsiElement)item;
        } else if (item instanceof LookupElement && (element = (lookupElement = (LookupElement)item).getPsiElement()) != null) {
            itemElement = element;
        }
        return !(itemElement instanceof PsiFile);
    }

    private boolean alreadyHasImportKeyword() {
        if (PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyImportStatement.class) != null) {
            return true;
        }
        for (ASTNode node = this.myElement.getNode(); node != null; node = node.getTreeNext()) {
            IElementType nodeType = node.getElementType();
            if (nodeType != PyTokenTypes.IMPORT_KEYWORD) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/psi/impl/references/PyImportReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ImportKeywordHandler
    implements InsertHandler<LookupElement> {
        public static final InsertHandler<LookupElement> INSTANCE = new ImportKeywordHandler();
        private static final String IMPORT_KWD = " import ";

        private ImportKeywordHandler() {
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            int tailOffset = context.getTailOffset();
            document.insertString(tailOffset, (CharSequence)IMPORT_KWD);
            editor.getCaretModel().moveToOffset(tailOffset + IMPORT_KWD.length());
        }
    }

    class ImportVariantCollector {
        private final PsiFile myCurrentFile;
        private final Set<String> myNamesAlready;
        private final List<Object> myObjects;
        @NotNull
        private final TypeEvalContext myContext;

        public ImportVariantCollector(TypeEvalContext context) {
            if (context == null) {
                ImportVariantCollector.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            PsiFile currentFile = PyImportReference.this.myElement.getContainingFile();
            this.myCurrentFile = currentFile = currentFile.getOriginalFile();
            this.myNamesAlready = new HashSet<String>();
            this.myObjects = new ArrayList<Object>();
        }

        public Object[] execute() {
            int relativeLevel = -1;
            InsertHandler<LookupElement> insertHandler = null;
            PyFromImportStatement fromImport = (PyFromImportStatement)PsiTreeUtil.getParentOfType((PsiElement)PyImportReference.this.myElement, PyFromImportStatement.class);
            if (fromImport != null && PyImportReference.this.myElement.getParent() != fromImport) {
                PyReferenceExpression src = fromImport.getImportSource();
                if (src != null) {
                    PsiElement modCandidate = src.getReference().resolve();
                    if (modCandidate instanceof PyExpression) {
                        this.addImportedNames(fromImport.getImportElements());
                        PyExpression module2 = (PyExpression)modCandidate;
                        PyType qualifierType = this.myContext.getType(module2);
                        if (qualifierType != null) {
                            ProcessingContext ctx = new ProcessingContext();
                            ctx.put(PyType.CTX_NAMES, this.myNamesAlready);
                            Collections.addAll(this.myObjects, qualifierType.getCompletionVariants(PyImportReference.this.myElement.getName(), (PsiElement)PyImportReference.this.myElement, ctx));
                        }
                        return this.myObjects.toArray();
                    }
                    if (modCandidate instanceof PsiDirectory) {
                        this.fillFromDir((PsiDirectory)modCandidate, ImportKeywordHandler.INSTANCE);
                        return this.myObjects.toArray();
                    }
                } else {
                    PsiDirectory relativeDir;
                    relativeLevel = fromImport.getRelativeLevel();
                    if (relativeLevel > 0 && (relativeDir = ResolveImportUtil.stepBackFrom(this.myCurrentFile, relativeLevel)) != null) {
                        this.addImportedNames(fromImport.getImportElements());
                        this.fillFromDir(relativeDir, null);
                    }
                }
            } else {
                PsiDirectory containingDirectory;
                PsiElement prevElem = PyPsiUtils.getPrevNonWhitespaceSibling((PsiElement)PyImportReference.this.myElement);
                while (prevElem != null && prevElem.getNode().getElementType() == PyTokenTypes.DOT) {
                    ++relativeLevel;
                    prevElem = PyPsiUtils.getPrevNonWhitespaceSibling(prevElem);
                }
                if (fromImport != null) {
                    this.addImportedNames(fromImport.getImportElements());
                    if (!PyImportReference.this.alreadyHasImportKeyword()) {
                        insertHandler = ImportKeywordHandler.INSTANCE;
                    }
                } else {
                    this.myNamesAlready.add("__future__");
                    PyImportStatement importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)PyImportReference.this.myElement, PyImportStatement.class);
                    if (importStatement != null) {
                        this.addImportedNames(importStatement.getImportElements());
                    }
                }
                if (!(relativeLevel < 0 && ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)this.myCurrentFile) || (containingDirectory = this.myCurrentFile.getContainingDirectory()) == null)) {
                    QualifiedName thisQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)containingDirectory);
                    if (thisQName == null || thisQName.getComponentCount() == relativeLevel) {
                        this.fillFromDir(ResolveImportUtil.stepBackFrom(this.myCurrentFile, relativeLevel), insertHandler);
                    } else if (thisQName.getComponentCount() > relativeLevel) {
                        thisQName = thisQName.removeTail(relativeLevel);
                        this.fillFromQName(thisQName, insertHandler);
                    }
                }
            }
            if (relativeLevel == -1) {
                this.fillFromQName(QualifiedName.fromComponents((String[])new String[0]), insertHandler);
            }
            return ArrayUtil.toObjectArray(this.myObjects);
        }

        private void fillFromQName(QualifiedName thisQName, InsertHandler<LookupElement> insertHandler) {
            StreamEx.of(PyResolveImportUtil.resolveQualifiedName(thisQName, PyResolveImportUtil.fromFoothold((PsiElement)this.myCurrentFile))).select(PsiDirectory.class).forEach(directory2 -> this.fillFromDir((PsiDirectory)directory2, insertHandler));
        }

        private void addImportedNames(@NotNull PyImportElement[] importElements) {
            if (importElements == null) {
                ImportVariantCollector.$$$reportNull$$$0(1);
            }
            for (PyImportElement element : importElements) {
                String s;
                PyReferenceExpression ref = element.getImportReferenceExpression();
                if (ref == null || (s = ref.getReferencedName()) == null) continue;
                this.myNamesAlready.add(s);
            }
        }

        private void fillFromDir(PsiDirectory targetDir, @Nullable InsertHandler<LookupElement> insertHandler) {
            if (targetDir != null) {
                PsiFile initPy = targetDir.findFile("__init__.py");
                if (initPy instanceof PyFile) {
                    PyModuleType moduleType = new PyModuleType((PyFile)initPy);
                    ProcessingContext context = new ProcessingContext();
                    context.put(PyType.CTX_NAMES, this.myNamesAlready);
                    Object[] completionVariants = moduleType.getCompletionVariants("", PyImportReference.this.getElement(), context);
                    if (insertHandler != null) {
                        PyImportReference.replaceInsertHandler(completionVariants, (InsertHandler<LookupElement>)insertHandler);
                    }
                    this.myObjects.addAll(Arrays.asList(completionVariants));
                } else {
                    this.myObjects.addAll(PyModuleType.getSubModuleVariants(targetDir, (PsiElement)PyImportReference.this.myElement, this.myNamesAlready));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importElements";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyImportReference$ImportVariantCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addImportedNames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

