/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.PySymbolFieldWithBrowseButton;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class PythonRunConfigurationForm
implements PythonRunConfigurationParams,
PanelWithAnchor {
    public static final String SCRIPT_PATH = "Script path";
    public static final String MODULE_NAME = "Module name";
    private JPanel myRootPanel;
    private TextFieldWithBrowseButton myScriptTextField;
    private RawCommandLineEditor myScriptParametersTextField;
    private JPanel myCommonOptionsPlaceholder;
    private JBLabel myScriptParametersLabel;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent anchor;
    private final Project myProject;
    private JBCheckBox myShowCommandLineCheckbox;
    private JBCheckBox myEmulateTerminalCheckbox;
    private PySymbolFieldWithBrowseButton myModuleField;
    private JBComboBoxLabel myTargetComboBox;
    private JPanel myModuleFieldPanel;
    private boolean myModuleMode;

    public PythonRunConfigurationForm(PythonRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsForm.addInterpreterModeListener(isRemoteInterpreter -> this.emulateTerminalEnabled(isRemoteInterpreter == false));
        this.myCommonOptionsPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        this.myProject = configuration.getProject();
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return file2.isDirectory() || file2.getExtension() == null || Comparing.equal((String)file2.getExtension(), (String)"py");
            }
        };
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener2 = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>("Select Script", "", (ComponentWithBrowseButton)this.myScriptTextField, this.myProject, chooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                PythonRunConfigurationForm.this.myCommonOptionsForm.setWorkingDirectory(chosenFile.getParent().getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/python/run/PythonRunConfigurationForm$2", "onFileChosen"));
            }
        };
        this.myScriptTextField.addActionListener((ActionListener)listener2);
        if (SystemInfo.isWindows) {
            this.emulateTerminalEnabled(false);
        }
        this.myEmulateTerminalCheckbox.setSelected(false);
        this.myEmulateTerminalCheckbox.addChangeListener(e -> this.updateShowCommandLineEnabled());
        this.setAnchor(this.myCommonOptionsForm.getAnchor());
        this.myModuleField = new PySymbolFieldWithBrowseButton(ModuleManager.getInstance((Project)this.myProject).getModules()[0], (Function1<? super PsiElement, Boolean>)((Function1)element -> element instanceof PyFile), (Function0<? extends VirtualFile>)((Function0)() -> {
            String workingDirectory = this.myCommonOptionsForm.getWorkingDirectory();
            if (StringUtil.isEmpty((String)workingDirectory)) {
                return null;
            }
            return LocalFileSystem.getInstance().findFileByPath(workingDirectory);
        }));
        this.myModuleFieldPanel.add((Component)((Object)this.myModuleField), "Center");
    }

    private void updateRunModuleMode() {
        boolean mode = "Module name:".equals(this.myTargetComboBox.getText());
        this.checkTargetComboConsistency(mode);
        this.setModuleModeInternal(mode);
    }

    private void checkTargetComboConsistency(boolean mode) {
        String item = this.myTargetComboBox.getText();
        assert (item != null);
        if (mode && !item.toLowerCase().contains("module")) {
            throw new IllegalArgumentException("This option should refer to a module");
        }
    }

    private void updateShowCommandLineEnabled() {
        this.myShowCommandLineCheckbox.setEnabled(!this.myEmulateTerminalCheckbox.isVisible() || !this.myEmulateTerminalCheckbox.isSelected());
    }

    private void emulateTerminalEnabled(boolean flag) {
        this.myEmulateTerminalCheckbox.setVisible(flag);
        this.updateShowCommandLineEnabled();
    }

    public JComponent getPanel() {
        return this.myRootPanel;
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this.myCommonOptionsForm;
    }

    @Override
    public String getScriptName() {
        if (this.isModuleMode()) {
            return this.myModuleField.getText().trim();
        }
        return FileUtil.toSystemIndependentName((String)this.myScriptTextField.getText().trim());
    }

    @Override
    public void setScriptName(String scriptName) {
        if (this.isModuleMode()) {
            this.myModuleField.setText(StringUtil.notNullize((String)scriptName));
        } else {
            this.myScriptTextField.setText(scriptName == null ? "" : FileUtil.toSystemDependentName((String)scriptName));
        }
    }

    @Override
    public String getScriptParameters() {
        return this.myScriptParametersTextField.getText().trim();
    }

    @Override
    public void setScriptParameters(String scriptParameters) {
        this.myScriptParametersTextField.setText(scriptParameters);
    }

    @Override
    public boolean showCommandLineAfterwards() {
        return this.myShowCommandLineCheckbox.isSelected();
    }

    @Override
    public void setShowCommandLineAfterwards(boolean showCommandLineAfterwards) {
        this.myShowCommandLineCheckbox.setSelected(showCommandLineAfterwards);
    }

    @Override
    public boolean emulateTerminal() {
        return this.myEmulateTerminalCheckbox.isSelected();
    }

    @Override
    public void setEmulateTerminal(boolean emulateTerminal) {
        this.myEmulateTerminalCheckbox.setSelected(emulateTerminal);
    }

    @Override
    public boolean isModuleMode() {
        return this.myModuleMode;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public boolean isMultiprocessMode() {
        return PyDebuggerOptionsProvider.getInstance(this.myProject).isAttachToSubprocess();
    }

    public void setMultiprocessMode(boolean multiprocess) {
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myScriptParametersLabel.setAnchor(anchor);
        this.myCommonOptionsForm.setAnchor(anchor);
    }

    @Override
    public void setModuleMode(boolean moduleMode) {
        this.setTargetComboBoxValue(moduleMode ? MODULE_NAME : SCRIPT_PATH);
        this.updateRunModuleMode();
        this.checkTargetComboConsistency(moduleMode);
    }

    private void setModuleModeInternal(boolean moduleMode) {
        this.myModuleMode = moduleMode;
        this.myScriptTextField.setVisible(!moduleMode);
        this.myModuleFieldPanel.setVisible(moduleMode);
    }

    private void createUIComponents() {
        this.myTargetComboBox = new MyComboBox();
    }

    private void setTargetComboBoxValue(String text) {
        this.myTargetComboBox.setText(text + ":");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel2;
        JBLabel jBLabel;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptParametersLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.labels.script_parameters"));
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonOptionsPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myEmulateTerminalCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        jBCheckBox2.setText("Emulate terminal in output console");
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myShowCommandLineCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Show command line afterwards");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBComboBoxLabel jBComboBoxLabel = this.myTargetComboBox;
        jPanel3.add((Component)jBComboBoxLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 2, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScriptTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        this.myModuleFieldPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScriptParametersTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.captions.script_parameters_dialog"));
        rawCommandLineEditor.setText("");
        jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyComboBox
    extends JBComboBoxLabel
    implements UserActivityProviderComponent {
        private final List<ChangeListener> myListeners = Lists.newArrayList();

        public MyComboBox() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Choose target to run", (List)Lists.newArrayList((Object[])new String[]{PythonRunConfigurationForm.SCRIPT_PATH, PythonRunConfigurationForm.MODULE_NAME})){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            PythonRunConfigurationForm.this.setTargetComboBoxValue(selectedValue);
                            PythonRunConfigurationForm.this.updateRunModuleMode();
                            return FINAL_CHOICE;
                        }
                    }).showUnderneathOf((Component)((Object)MyComboBox.this));
                }
            });
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.myListeners.remove(changeListener);
        }

        void fireChangeEvent() {
            for (ChangeListener l : this.myListeners) {
                l.stateChanged(new ChangeEvent((Object)this));
            }
        }

        public void setText(String text) {
            super.setText(text);
            this.fireChangeEvent();
        }
    }
}

