/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.add.PyAddExistingCondaEnvPanel;
import com.jetbrains.python.sdk.add.PyAddExistingVirtualEnvPanel;
import com.jetbrains.python.sdk.add.PyAddNewCondaEnvPanel;
import com.jetbrains.python.sdk.add.PyAddNewVirtualEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSystemWideInterpreterPanel;
import icons.PythonIcons;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014J*\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0014J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSdkDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "panels", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "selectedPanel", "createAnacondaPanel", "createCardSplitter", "Lcom/intellij/openapi/ui/Splitter;", "createCenterPanel", "Ljavax/swing/JComponent;", "createVirtualEnvPanel", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getOrCreateSdk", "postponeValidation", "", "Companion", "python-community"})
public final class PyAddSdkDialog
extends DialogWrapper {
    private PyAddSdkPanel selectedPanel;
    private List<? extends PyAddSdkPanel> panels;
    private final Project project;
    private final List<Sdk> existingSdks;
    private final String newProjectPath;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.existingSdks;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            if (!(it.getSdkType() instanceof PythonSdkType && !PythonSdkType.isInvalid(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sdks = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new PreferredSdkComparator());
        return (JComponent)this.createCardSplitter(CollectionsKt.listOf((Object[])new PyAddSdkPanel[]{this.createVirtualEnvPanel(this.project, sdks, this.newProjectPath), this.createAnacondaPanel(this.project), new PyAddSystemWideInterpreterPanel(this.existingSdks)}));
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        Object object = this.selectedPanel;
        if (object == null || (object = ((PyAddSdkPanel)object).validateAll()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final Sdk getOrCreateSdk() {
        PyAddSdkPanel pyAddSdkPanel = this.selectedPanel;
        return pyAddSdkPanel != null ? pyAddSdkPanel.getOrCreateSdk() : null;
    }

    private final Splitter createCardSplitter(List<? extends PyAddSdkPanel> panels) {
        JBList jBList;
        JPanel jPanel;
        Splitter splitter;
        this.panels = panels;
        Splitter $receiver = splitter = new Splitter(false, 0.25f);
        CardLayout cardLayout = new CardLayout();
        JPanel $receiver2 = jPanel = new JPanel(cardLayout);
        $receiver2.setPreferredSize((Dimension)JBUI.size((int)640, (int)480));
        for (PyAddSdkPanel pyAddSdkPanel : panels) {
            $receiver2.add((Component)pyAddSdkPanel, pyAddSdkPanel.getPanelName());
        }
        JPanel cardPanel = jPanel;
        JBList $receiver3 = jBList = new JBList((Collection)panels);
        ListItemDescriptorAdapter<PyAddSdkPanel> listItemDescriptorAdapter = new ListItemDescriptorAdapter<PyAddSdkPanel>(){

            @NotNull
            public String getTextFor(@NotNull PyAddSdkPanel value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return StringUtil.toTitleCase((String)value.getPanelName());
            }

            @NotNull
            public Icon getIconFor(@NotNull PyAddSdkPanel value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return value.getIcon();
            }
        };
        $receiver3.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer<PyAddSdkPanel>(listItemDescriptorAdapter, (ListItemDescriptor)listItemDescriptorAdapter){
            final /* synthetic */ createCardSplitter.1.cardsList.1.descriptor.1 $descriptor;

            protected JComponent createItemComponent() {
                JComponent jComponent;
                JComponent $receiver = jComponent = super.createItemComponent();
                $receiver.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)10));
                return jComponent;
            }
            {
                this.$descriptor = $captured_local_variable$0;
                super($super_call_param$1);
            }
        });
        $receiver3.addListSelectionListener(new ListSelectionListener($receiver3, cardLayout, cardPanel, this, panels){
            final /* synthetic */ JBList receiver$0;
            final /* synthetic */ CardLayout $cardLayout$inlined;
            final /* synthetic */ JPanel $cardPanel$inlined;
            final /* synthetic */ PyAddSdkDialog this$0;
            final /* synthetic */ List $panels$inlined;
            {
                this.receiver$0 = jBList;
                this.$cardLayout$inlined = cardLayout;
                this.$cardPanel$inlined = jPanel;
                this.this$0 = pyAddSdkDialog;
                this.$panels$inlined = list2;
            }

            public final void valueChanged(ListSelectionEvent it) {
                PyAddSdkDialog.access$setSelectedPanel$p(this.this$0, (PyAddSdkPanel)this.receiver$0.getSelectedValue());
                this.$cardLayout$inlined.show(this.$cardPanel$inlined, ((PyAddSdkPanel)this.receiver$0.getSelectedValue()).getPanelName());
            }
        });
        this.selectedPanel = (PyAddSdkPanel)CollectionsKt.getOrNull(panels, (int)0);
        $receiver3.setSelectedIndex(0);
        JBList cardsList2 = jBList;
        $receiver.setFirstComponent((JComponent)cardsList2);
        $receiver.setSecondComponent((JComponent)cardPanel);
        return splitter;
    }

    private final PyAddSdkPanel createVirtualEnvPanel(Project project, List<? extends Sdk> existingSdks, String newProjectPath) {
        boolean bl;
        List panels;
        PyAddExistingVirtualEnvPanel existingVirtualEnvPanel;
        PyAddNewVirtualEnvPanel newVirtualEnvPanel;
        block3: {
            newVirtualEnvPanel = PyAddSdkDialog.Companion.allowCreatingNewEnvironments(project) ? new PyAddNewVirtualEnvPanel(project, existingSdks, newProjectPath) : null;
            existingVirtualEnvPanel = new PyAddExistingVirtualEnvPanel(project, existingSdks, newProjectPath);
            panels = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new PyAddSdkPanel[]{newVirtualEnvPanel, existingVirtualEnvPanel}));
            Iterable $receiver$iv = PySdkExtKt.detectVirtualEnvs(project, existingSdks);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PyDetectedSdk it = (PyDetectedSdk)((Object)element$iv);
                    if (!PySdkExtKt.isAssociatedWithProject(it, project)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        PyAddSdkPanel defaultPanel = bl ? (PyAddSdkPanel)existingVirtualEnvPanel : (newVirtualEnvPanel != null ? (PyAddSdkPanel)newVirtualEnvPanel : (PyAddSdkPanel)existingVirtualEnvPanel);
        Icon icon = PythonIcons.Python.Virtualenv;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Virtualenv");
        return new PyAddSdkGroupPanel("Virtualenv environment", icon, panels, defaultPanel);
    }

    private final PyAddSdkPanel createAnacondaPanel(Project project) {
        PyAddNewCondaEnvPanel newCondaEnvPanel = PyAddSdkDialog.Companion.allowCreatingNewEnvironments(project) ? new PyAddNewCondaEnvPanel(project, this.existingSdks, this.newProjectPath) : null;
        List panels = CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])new PyAddSdkPanel[]{newCondaEnvPanel, new PyAddExistingCondaEnvPanel(project, this.existingSdks, this.newProjectPath)}));
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Anaconda");
        return new PyAddSdkGroupPanel("Conda environment", icon, panels, (PyAddSdkPanel)panels.get(0));
    }

    public PyAddSdkDialog(@Nullable Project project, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        super(project);
        this.project = project;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        this.panels = CollectionsKt.emptyList();
        this.init();
        this.setTitle("Add Local Python Interpreter");
    }

    @Nullable
    public static final /* synthetic */ PyAddSdkPanel access$getSelectedPanel$p(PyAddSdkDialog $this) {
        return $this.selectedPanel;
    }

    public static final /* synthetic */ void access$setSelectedPanel$p(PyAddSdkDialog $this, @Nullable PyAddSdkPanel pyAddSdkPanel) {
        $this.selectedPanel = pyAddSdkPanel;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddSdkDialog$Companion;", "", "()V", "allowCreatingNewEnvironments", "", "project", "Lcom/intellij/openapi/project/Project;", "python-community"})
    public static final class Companion {
        private final boolean allowCreatingNewEnvironments(Project project) {
            return project != null || !PlatformUtils.isPyCharm() || PlatformUtils.isPyCharmEducational();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

