/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private StringLiteralTokenizer myStringLiteralTokenizer = new StringLiteralTokenizer();
    private FormatStringTokenizer myFormatStringTokenizer = new FormatStringTokenizer();

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            PyBinaryExpression binaryExpression;
            PsiElement parent = element.getParent();
            if (parent instanceof PyBinaryExpression && element == (binaryExpression = (PyBinaryExpression)parent).getLeftExpression() && binaryExpression.getOperator() == PyTokenTypes.PERC) {
                FormatStringTokenizer formatStringTokenizer = this.myFormatStringTokenizer;
                if (formatStringTokenizer == null) {
                    PythonSpellcheckerStrategy.$$$reportNull$$$0(0);
                }
                return formatStringTokenizer;
            }
            StringLiteralTokenizer stringLiteralTokenizer = this.myStringLiteralTokenizer;
            if (stringLiteralTokenizer == null) {
                PythonSpellcheckerStrategy.$$$reportNull$$$0(1);
            }
            return stringLiteralTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            PythonSpellcheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy", "getTokenizer"));
    }

    private static class FormatStringTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private FormatStringTokenizer() {
        }

        @Override
        public void tokenize(@NotNull PyStringLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                FormatStringTokenizer.$$$reportNull$$$0(0);
            }
            String stringValue = element.getStringValue();
            List<PyStringFormatParser.FormatStringChunk> chunks = PyStringFormatParser.parsePercentFormat(stringValue);
            PlainTextSplitter splitter = PlainTextSplitter.getInstance();
            for (PyStringFormatParser.FormatStringChunk chunk : chunks) {
                if (!(chunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                int startIndex = element.valueOffsetToTextOffset(chunk.getStartIndex());
                int endIndex = element.valueOffsetToTextOffset(chunk.getEndIndex());
                String text = element.getText().substring(startIndex, endIndex);
                consumer.consumeToken(element, text, false, startIndex, TextRange.allOf((String)text), splitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$FormatStringTokenizer", "tokenize"));
        }
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private StringLiteralTokenizer() {
        }

        @Override
        public void tokenize(@NotNull PyStringLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(0);
            }
            PlainTextSplitter splitter = PlainTextSplitter.getInstance();
            List<ASTNode> strNodes = element.getStringNodes();
            List prefixes = ContainerUtil.mapNotNull(strNodes, n -> StringUtil.nullize((String)new PyUtil.StringNodeInfo((ASTNode)n).getPrefix()));
            if (element.textContains('\\') && !prefixes.stream().anyMatch(PyStringLiteralUtil::isRawPrefix)) {
                for (Pair<TextRange, String> fragment : element.getDecodedFragments()) {
                    String value = (String)fragment.getSecond();
                    int startOffset = ((TextRange)fragment.getFirst()).getStartOffset();
                    consumer.consumeToken(element, value, false, startOffset, TextRange.allOf((String)value), splitter);
                }
            } else if (!prefixes.isEmpty()) {
                for (TextRange valueTextRange : element.getStringValueTextRanges()) {
                    String value = valueTextRange.substring(element.getText());
                    int startOffset = valueTextRange.getStartOffset();
                    consumer.consumeToken(element, value, false, startOffset, TextRange.allOf((String)value), splitter);
                }
            } else {
                consumer.consumeToken(element, splitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$StringLiteralTokenizer", "tokenize"));
        }
    }
}

