/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TaskPaneAddon;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class JXTaskPane
extends JPanel
implements JXCollapsiblePane.CollapsiblePaneContainer {
    public static final String uiClassID = "swingx/TaskPaneUI";
    public static final String SCROLL_ON_EXPAND_CHANGED_KEY = "scrollOnExpand";
    public static final String TITLE_CHANGED_KEY = "title";
    public static final String ICON_CHANGED_KEY = "icon";
    public static final String SPECIAL_CHANGED_KEY = "special";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    private String title;
    private Icon icon;
    private boolean special;
    private boolean collapsed;
    private boolean scrollOnExpand;
    private int mnemonic;
    private int mnemonicIndex = -1;
    private JXCollapsiblePane collapsePane = new JXCollapsiblePane();

    public JXTaskPane() {
        this((String)null);
    }

    public JXTaskPane(String title) {
        this(title, null);
    }

    public JXTaskPane(Icon icon) {
        this(null, icon);
    }

    public JXTaskPane(String title, Icon icon) {
        super.setLayout(new BorderLayout(0, 0));
        super.addImpl(this.collapsePane, "Center", -1);
        this.setTitle(title);
        this.setIcon(icon);
        this.updateUI();
        this.setFocusable(true);
        this.setAnimated(!Boolean.FALSE.equals(UIManager.get("TaskPane.animate")));
        this.collapsePane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JXTaskPane.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public Container getContentPane() {
        return this.collapsePane.getContentPane();
    }

    @Override
    public void updateUI() {
        if (this.collapsePane == null) {
            return;
        }
        this.setUI((TaskPaneUI)LookAndFeelAddons.getUI(this, TaskPaneUI.class));
    }

    public void setUI(TaskPaneUI ui) {
        super.setUI(ui);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_CHANGED_KEY, old, title);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChange(ICON_CHANGED_KEY, old, icon);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean special) {
        boolean oldValue = this.isSpecial();
        this.special = special;
        this.firePropertyChange(SPECIAL_CHANGED_KEY, oldValue, this.isSpecial());
    }

    public void setScrollOnExpand(boolean scrollOnExpand) {
        boolean oldValue = this.isScrollOnExpand();
        this.scrollOnExpand = scrollOnExpand;
        this.firePropertyChange(SCROLL_ON_EXPAND_CHANGED_KEY, oldValue, this.isScrollOnExpand());
    }

    public boolean isScrollOnExpand() {
        return this.scrollOnExpand;
    }

    public void setCollapsed(boolean collapsed) {
        boolean oldValue = this.isCollapsed();
        this.collapsed = collapsed;
        this.collapsePane.setCollapsed(collapsed);
        this.firePropertyChange("collapsed", oldValue, this.isCollapsed());
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setAnimated(boolean animated) {
        boolean oldValue = this.isAnimated();
        this.collapsePane.setAnimated(animated);
        this.firePropertyChange(ANIMATED_CHANGED_KEY, oldValue, this.isAnimated());
    }

    public boolean isAnimated() {
        return this.collapsePane.isAnimated();
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int mnemonic) {
        int oldValue = this.getMnemonic();
        this.mnemonic = mnemonic;
        this.firePropertyChange("mnemonic", oldValue, this.getMnemonic());
        this.updateDisplayedMnemonicIndex(this.getTitle(), mnemonic);
        this.revalidate();
        this.repaint();
    }

    private void updateDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            this.mnemonicIndex = -1;
            return;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        this.mnemonicIndex = uci == -1 ? lci : (lci == -1 ? uci : (lci < uci ? lci : uci));
    }

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setDisplayedMnemonicIndex(int index) throws IllegalArgumentException {
        int oldValue = this.mnemonicIndex;
        if (index == -1) {
            this.mnemonicIndex = -1;
        } else {
            int textLength;
            String text = this.getTitle();
            int n = textLength = text == null ? 0 : text.length();
            if (index < -1 || index >= textLength) {
                throw new IllegalArgumentException("index == " + index);
            }
        }
        this.mnemonicIndex = index;
        this.firePropertyChange("displayedMnemonicIndex", oldValue, index);
        if (index != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public Component add(Action action) {
        Component c = ((TaskPaneUI)this.ui).createAction(action);
        this.add(c);
        return c;
    }

    @Override
    public Container getValidatingContainer() {
        return this.getParent();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
        this.revalidate();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.collapsePane != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    @Override
    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    @Override
    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",title=" + this.getTitle() + ",icon=" + this.getIcon() + ",collapsed=" + String.valueOf(this.isCollapsed()) + ",special=" + String.valueOf(this.isSpecial()) + ",scrollOnExpand=" + String.valueOf(this.isScrollOnExpand()) + ",ui=" + this.getUI();
    }

    static {
        LookAndFeelAddons.contribute(new TaskPaneAddon());
    }
}

