# Stubs for decimal (Python 3.4)

from typing import (
    Any, Union, SupportsInt, SupportsFloat, SupportsAbs, SupportsRound, Sequence,
    Tuple, NamedTuple, Dict
)

_Decimal = Union[Decimal, int]
_ComparableNum = Union[Decimal, int, float]

BasicContext = ...  # type: Context
DefaultContext = ...  # type: Context
ExtendedContext = ...  # type: Context
HAVE_THREADS = ...  # type: bool
MAX_EMAX = ...  # type: int
MAX_PREC = ...  # type: int
MIN_EMIN = ...  # type: int
MIN_ETINY = ...  # type: int
ROUND_05UP = ...  # type: str
ROUND_CEILING = ...  # type: str
ROUND_DOWN = ...  # type: str
ROUND_FLOOR = ...  # type: str
ROUND_HALF_DOWN = ...  # type: str
ROUND_HALF_EVEN = ...  # type: str
ROUND_HALF_UP = ...  # type: str
ROUND_UP = ...  # type: str

def getcontext() -> Context: ...
def localcontext(ctx: Context = ...) -> _ContextManager: ...
def setcontext(c: Context) -> None: ...

DecimalTuple = NamedTuple('DecimalTuple',
                          [('sign', int),
                           ('digits', Sequence[int]),  # TODO: Use Tuple[int, ...]
                           ('exponent', int)])

class _ContextManager:
    def __enter__(self) -> Context: ...
    def __exit__(self, t, v, tb) -> None: ...

class Context:
    Emax = ...  # type: int
    Emin = ...  # type: int
    capitals = ...  # type: int
    clamp = ...  # type: int
    prec = ...  # type: int
    rounding = ...  # type: str
    traps = ...  # type: Dict[type, bool]
    def __init__(self, prec: int = ..., rounding: str = ..., Emin: int = ..., Emax: int = ...,
                 capitals: int = ..., clamp: int = ..., flags=..., traps=...,
                 _ignored_flags=...) -> None: ...
    def Etiny(self): ...
    def Etop(self): ...
    def abs(self, x: _Decimal) -> Decimal: ...
    def add(self, x: _Decimal, y: _Decimal) -> Decimal: ...
    def canonical(self, x): ...
    def clear_flags(self): ...
    def clear_traps(self): ...
    def compare(self, x, y): ...
    def compare_signal(self, x, y): ...
    def compare_total(self, x, y): ...
    def compare_total_mag(self, x, y): ...
    def copy(self): ...
    def copy_abs(self, x): ...
    def copy_decimal(self, x): ...
    def copy_negate(self, x): ...
    def copy_sign(self, x, y): ...
    def create_decimal(self, x): ...
    def create_decimal_from_float(self, f): ...
    def divide(self, x, y): ...
    def divide_int(self, x, y): ...
    def divmod(self, x, y): ...
    def exp(self, x): ...
    def fma(self, x, y, z): ...
    def is_canonical(self, x): ...
    def is_finite(self, x): ...
    def is_infinite(self, x): ...
    def is_nan(self, x): ...
    def is_normal(self, x): ...
    def is_qnan(self, x): ...
    def is_signed(self, x): ...
    def is_snan(self): ...
    def is_subnormal(self, x): ...
    def is_zero(self, x): ...
    def ln(self, x): ...
    def log10(self, x): ...
    def logb(self, x): ...
    def logical_and(self, x, y): ...
    def logical_invert(self, x): ...
    def logical_or(self, x, y): ...
    def logical_xor(self, x, y): ...
    def max(self, x, y): ...
    def max_mag(self, x, y): ...
    def min(self, x, y): ...
    def min_mag(self, x, y): ...
    def minus(self, x): ...
    def multiply(self, x, y): ...
    def next_minus(self, x): ...
    def next_plus(self, x): ...
    def next_toward(self, x): ...
    def normalize(self, x): ...
    def number_class(self, x): ...
    def plus(self, x): ...
    def power(self, x, y): ...
    def quantize(self, x, y): ...
    def radix(self): ...
    def remainder(self, x, y): ...
    def remainder_near(self, x, y): ...
    def rotate(self, x, y): ...
    def same_quantum(self, x, y): ...
    def scaleb(self, x, y): ...
    def shift(self, x, y): ...
    def sqrt(self, x): ...
    def subtract(self, x, y): ...
    def to_eng_string(self, x): ...
    def to_integral(self, x): ...
    def to_integral_exact(self, x): ...
    def to_integral_value(self, x): ...
    def to_sci_string(self, x): ...
    def __copy__(self) -> Context: ...
    def __delattr__(self, name): ...
    def __reduce__(self): ...

class ConversionSyntax(InvalidOperation): ...

class Decimal(SupportsInt, SupportsFloat, SupportsAbs[Decimal], SupportsRound[int]):
    # TODO: SupportsCeil, SupportsFloor, SupportsTrunc?

    def __init__(cls, value: Union[_Decimal, float, str,
                                   Tuple[int, Sequence[int], int]] = ...,
                 context: Context = ...) -> None: ...

    @property
    def imag(self) -> Decimal: ...
    @property
    def real(self) -> Decimal: ...

    def adjusted(self) -> int: ...
    def as_tuple(self) -> DecimalTuple: ...
    def canonical(self) -> Decimal: ...
    def compare(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def compare_signal(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def compare_total(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def compare_total_mag(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def conjugate(self) -> Decimal: ...
    def copy_abs(self) -> Decimal: ...
    def copy_negate(self) -> Decimal: ...
    def copy_sign(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def exp(self, context: Context = ...) -> Decimal: ...
    def fma(self, other: _Decimal, third: _Decimal, context: Context = ...) -> Decimal: ...
    @classmethod
    def from_float(cls, f: float) -> Decimal: ...
    def is_canonical(self) -> bool: ...
    def is_finite(self) -> bool: ...
    def is_infinite(self) -> bool: ...
    def is_nan(self) -> bool: ...
    def is_normal(self, context: Context = ...) -> bool: ...
    def is_qnan(self) -> bool: ...
    def is_signed(self) -> bool: ...
    def is_snan(self) -> bool: ...
    def is_subnormal(self, context: Context = ...) -> bool: ...
    def is_zero(self) -> bool: ...
    def ln(self, context: Context = ...) -> Decimal: ...
    def log10(self, context: Context = ...) -> Decimal: ...
    def logb(self, context: Context = ...) -> Decimal: ...
    def logical_and(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def logical_invert(self, context: Context = ...) -> Decimal: ...
    def logical_or(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def logical_xor(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def max(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def max_mag(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def min(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def min_mag(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def next_minus(self, context: Context = ...) -> Decimal: ...
    def next_plus(self, context: Context = ...) -> Decimal: ...
    def next_toward(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def normalize(self, context: Context = ...) -> Decimal: ...
    def number_class(self, context: Context = ...) -> str: ...
    def quantize(self, exp: _Decimal, rounding: str = ...,
                 context: Context = ...) -> Decimal: ...
    def radix(self) -> Decimal: ...
    def remainder_near(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def rotate(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def same_quantum(self, other: _Decimal, context: Context = ...) -> bool: ...
    def scaleb(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def shift(self, other: _Decimal, context: Context = ...) -> Decimal: ...
    def sqrt(self, context: Context = ...) -> Decimal: ...
    def to_eng_string(self, context: Context = ...) -> str: ...
    def to_integral(self, rounding: str = ..., context: Context = ...) -> Decimal: ...
    def to_integral_exact(self, rounding: str = ..., context: Context = ...) -> Decimal: ...
    def to_integral_value(self, rounding: str = ..., context: Context = ...) -> Decimal: ...
    def __abs__(self) -> Decimal: ...
    def __add__(self, other: _Decimal) -> Decimal: ...
    def __bool__(self) -> bool: ...
    def __ceil__(self) -> int: ...
    def __complex__(self) -> complex: ...
    def __copy__(self) -> Decimal: ...
    def __deepcopy__(self) -> Decimal: ...
    def __divmod__(self, other: _Decimal) -> Tuple[Decimal, Decimal]: ...
    def __eq__(self, other: object) -> bool: ...
    def __float__(self) -> float: ...
    def __floor__(self) -> int: ...
    def __floordiv__(self, other: _Decimal) -> Decimal: ...
    def __format__(self, specifier, context=..., _localeconv=...) -> str: ...
    def __ge__(self, other: _ComparableNum) -> bool: ...
    def __gt__(self, other: _ComparableNum) -> bool: ...
    def __hash__(self) -> int: ...
    def __int__(self) -> int: ...
    def __le__(self, other: _ComparableNum) -> bool: ...
    def __lt__(self, other: _ComparableNum) -> bool: ...
    def __mod__(self, other: _Decimal) -> Decimal: ...
    def __mul__(self, other: _Decimal) -> Decimal: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> Decimal: ...
    def __pos__(self) -> Decimal: ...
    def __pow__(self, other: _Decimal) -> Decimal: ...
    def __radd__(self, other: int) -> Decimal: ...
    def __rdivmod__(self, other: int) -> Tuple[Decimal, Decimal]: ...
    def __reduce__(self): ...
    def __rfloordiv__(self, other: int) -> Decimal: ...
    def __rmod__(self, other: int) -> Decimal: ...
    def __rmul__(self, other: int) -> Decimal: ...
    def __round__(self, n=...) -> int: ...
    def __rpow__(self, other: int) -> Decimal: ...
    def __rsub__(self, other: int) -> Decimal: ...
    def __rtruediv__(self, other: int) -> Decimal: ...
    def __sub__(self, other: _Decimal) -> Decimal: ...
    def __truediv__(self, other: _Decimal) -> Decimal: ...
    def __trunc__(self) -> int: ...

class DecimalException(ArithmeticError): ...

class Clamped(DecimalException): ...

class DivisionByZero(DecimalException, ZeroDivisionError): ...

class DivisionImpossible(InvalidOperation): ...

class DivisionUndefined(InvalidOperation, ZeroDivisionError): ...

class FloatOperation(DecimalException, TypeError): ...

class Inexact(DecimalException): ...

class InvalidContext(InvalidOperation): ...

class InvalidOperation(DecimalException): ...

class Overflow(Inexact, Rounded): ...

class Rounded(DecimalException): ...

class Subnormal(DecimalException): ...

class Underflow(Inexact, Rounded, Subnormal): ...
