# Copyright 2014 IBM Corp.
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.


class SimpleCertManager(object):
    """Manager for the OS-SIMPLE-CERT extension."""

    def __init__(self, client):
        self._client = client

    def get_ca_certificates(self):
        """Get CA certificates.

        :returns: PEM-formatted string.
        :rtype: str

        """
        resp, body = self._client.get('/OS-SIMPLE-CERT/ca',
                                      authenticated=False)
        return resp.text

    def get_certificates(self):
        """Get signing certificates.

        :returns: PEM-formatted string.
        :rtype: str

        """
        resp, body = self._client.get('/OS-SIMPLE-CERT/certificates',
                                      authenticated=False)
        return resp.text
