/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.updatesite.xml.Archive;
import org.apache.ivy.osgi.updatesite.xml.CategoryDef;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.UpdateSite;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseUpdateSiteParser {
    public static UpdateSite parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        SiteHandler siteHandler = new SiteHandler();
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)siteHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        return siteHandler.updatesite;
    }

    static class CategoryDefHandler
    extends DelegetingHandler {
        private static final String CATEGORY_DEF = "category-def";
        private static final String NAME = "name";
        private static final String LABEL = "label";
        private CategoryDef categoryDef;

        public CategoryDefHandler() {
            super(CATEGORY_DEF);
            this.addChild(new DescriptionHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    CategoryDefHandler.this.categoryDef.setDescription(delegetingHandler.getBufferedChars().trim());
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.categoryDef = new CategoryDef();
            String string = attributes.getValue(NAME);
            this.categoryDef.setName(string);
            String string2 = attributes.getValue(LABEL);
            this.categoryDef.setLabel(string2);
        }
    }

    static class ArchiveHandler
    extends DelegetingHandler {
        private static final String ARCHIVE = "archive";
        private static final String URL = "url";
        private static final String PATH = "path";
        private Archive archive;

        public ArchiveHandler() {
            super(ARCHIVE);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.archive = new Archive();
            String string = attributes.getValue(PATH);
            this.archive.setPath(string);
            String string2 = attributes.getValue(URL);
            this.archive.setURL(string2);
        }
    }

    static class CategoryHandler
    extends DelegetingHandler {
        private static final String CATEGORY = "category";
        private static final String NAME = "name";
        String name;

        public CategoryHandler() {
            super(CATEGORY);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.name = attributes.getValue(NAME);
        }
    }

    static class FeatureHandler
    extends DelegetingHandler {
        private static final String FEATURE = "feature";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String URL = "url";
        private static final String PATCH = "patch";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String LABEL = "label";
        private static final String TYPE = "type";
        private EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new CategoryHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    FeatureHandler.this.feature.addCategory(((CategoryHandler)delegetingHandler).name);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            try {
                this.feature = new EclipseFeature(string, new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on the feature '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
            String string3 = attributes.getValue(URL);
            if (string3 != null) {
                this.feature.setURL(string3);
            }
            this.feature.setType(attributes.getValue(TYPE));
            this.feature.setLabel(attributes.getValue(LABEL));
            this.feature.setOS(attributes.getValue(OS));
            this.feature.setWS(attributes.getValue(WS));
            this.feature.setNL(attributes.getValue(NL));
            this.feature.setArch(attributes.getValue(ARCH));
            this.feature.setPatch(attributes.getValue(PATCH));
        }
    }

    static class DescriptionHandler
    extends DelegetingHandler {
        private static final String DESCRIPTION = "description";
        private static final String URL = "url";

        public DescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            String string = attributes.getValue(URL);
        }
    }

    static class SiteHandler
    extends DelegetingHandler {
        private static final String SITE = "site";
        private static final String URL = "url";
        private static final String PACK200 = "pack200";
        private static final String MIRRORS_URL = "mirrorsURL";
        private static final String ASSOCIATE_SITES_URL = "associateSitesURL";
        private static final String DIGEST_URL = "digestURL";
        UpdateSite updatesite;

        public SiteHandler() {
            super(SITE);
            this.addChild(new FeatureHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    SiteHandler.this.updatesite.addFeature(((FeatureHandler)delegetingHandler).feature);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            String string;
            String string2;
            String string3;
            String string4;
            this.updatesite = new UpdateSite();
            String string5 = attributes.getValue(URL);
            if (string5 != null && !"".equals(string5.trim())) {
                if (!string5.endsWith("/") && !string5.endsWith(File.separator)) {
                    string5 = string5 + "/";
                }
                try {
                    this.updatesite.setUri(new URI(string5));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException("illegal url", uRISyntaxException);
                }
            }
            if ((string4 = attributes.getValue(MIRRORS_URL)) != null && string4.trim().length() > 0) {
                this.updatesite.setMirrorsURL(string4);
            }
            if ((string3 = attributes.getValue(PACK200)) != null && new Boolean(string3).booleanValue()) {
                this.updatesite.setPack200(true);
            }
            if ((string2 = attributes.getValue(DIGEST_URL)) != null) {
                try {
                    this.updatesite.setDigestUri(new URI(string2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException("illegal url", uRISyntaxException);
                }
            }
            if ((string = attributes.getValue(ASSOCIATE_SITES_URL)) != null) {
                this.updatesite.setAssociateSitesURL(string);
            }
        }
    }
}

