/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.util.Hashtable;

public class ChangeAttributeCommand
extends AbstractCommand {
    private String fAttribute;
    private Object fValue;

    public ChangeAttributeCommand(String name, String attributeName, Object value, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
        this.fAttribute = attributeName;
        this.fValue = value;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionElements());
        FigureEnumeration fe = this.getUndoActivity().getAffectedFigures();
        while (fe.hasMoreElements()) {
            fe.nextFigure().setAttribute(this.fAttribute, this.fValue);
        }
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.fAttribute, this.fValue);
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Hashtable myOriginalValues = new Hashtable();
        private String myUndoAttribute;
        private Object myUndoValue;

        public UndoActivity(DrawingView newDrawingView, String newUndoAttribute, Object newUndoValue) {
            super(newDrawingView);
            this.setAttributeName(newUndoAttribute);
            this.setBackupValue(newUndoValue);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            FigureEnumeration k = this.getAffectedFigures();
            while (k.hasMoreElements()) {
                Figure f = k.nextFigure();
                if (this.getOriginalValue(f) == null) continue;
                f.setAttribute(this.getAttributeName(), this.getOriginalValue(f));
            }
            return true;
        }

        public boolean redo() {
            if (!this.isRedoable()) {
                return false;
            }
            FigureEnumeration k = this.getAffectedFigures();
            while (k.hasMoreElements()) {
                Figure f = k.nextFigure();
                if (this.getBackupValue() == null) continue;
                f.setAttribute(this.getAttributeName(), this.getBackupValue());
            }
            return true;
        }

        protected void addOriginalValue(Figure affectedFigure, Object newOriginalValue) {
            this.myOriginalValues.put(affectedFigure, newOriginalValue);
        }

        protected Object getOriginalValue(Figure lookupAffectedFigure) {
            return this.myOriginalValues.get(lookupAffectedFigure);
        }

        protected void setAttributeName(String newUndoAttribute) {
            this.myUndoAttribute = newUndoAttribute;
        }

        public String getAttributeName() {
            return this.myUndoAttribute;
        }

        protected void setBackupValue(Object newUndoValue) {
            this.myUndoValue = newUndoValue;
        }

        public Object getBackupValue() {
            return this.myUndoValue;
        }

        public void release() {
            super.release();
            this.myOriginalValues = null;
        }

        public void setAffectedFigures(FigureEnumeration fe) {
            super.setAffectedFigures(fe);
            FigureEnumeration copyFe = this.getAffectedFigures();
            while (copyFe.hasMoreElements()) {
                Figure f = copyFe.nextFigure();
                Object attributeValue = f.getAttribute(this.getAttributeName());
                if (attributeValue == null) continue;
                this.addOriginalValue(f, attributeValue);
            }
        }
    }
}

