/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.tools.DefaultFindCondition;
import ch.ehi.uml1_4.tools.NamespaceUtility;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umlpresentation.Diagram;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FindDialog
extends BaseDialog {
    private static ResourceBundle resources = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/FindDialog");
    private Set results = null;
    private JPanel ivjBaseDialogContentPane = null;
    private JButton ivjBtnCancel = null;
    private JButton ivjBtnSearch = null;
    private JCheckBox ivjChxIgnoreCase = null;
    private JCheckBox ivjChxUseDocument = null;
    private JCheckBox ivjChxUseName = null;
    private JLabel ivjLblName = null;
    private JLabel ivjLblSearchList = null;
    private JList ivjLstSearchList = null;
    private JScrollPane ivjScpSearchList = null;
    private JTextField ivjTxtName = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public FindDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
        Point parentOrigin = owner.getLocation();
        this.setLocation((int)parentOrigin.getX() + 250, (int)parentOrigin.getY() + 40);
        this.show();
    }

    public FindDialog(Frame owner, boolean modal, Set results, String title) {
        super(owner, modal);
        this.initialize();
        Point parentOrigin = owner.getLocation();
        this.setLocation((int)parentOrigin.getX() + 250, (int)parentOrigin.getY() + 40);
        this.setTitle(title);
        this.getLblName().setVisible(false);
        this.getTxtName().setVisible(false);
        this.getChxIgnoreCase().setVisible(false);
        this.getChxUseDocument().setVisible(false);
        this.getChxUseName().setVisible(false);
        this.getBtnSearch().setVisible(false);
        this.showResults(results);
        this.show();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.search();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ListSelectionEvent arg1) {
        try {
            this.selectElement(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblName = new GridBagConstraints();
                constraintsLblName.gridx = 1;
                constraintsLblName.gridy = 1;
                constraintsLblName.anchor = 18;
                constraintsLblName.ipadx = 104;
                constraintsLblName.insets = new Insets(15, 16, 11, 1);
                this.getBaseDialogContentPane().add((Component)this.getLblName(), constraintsLblName);
                GridBagConstraints constraintsTxtName = new GridBagConstraints();
                constraintsTxtName.gridx = 2;
                constraintsTxtName.gridy = 1;
                constraintsTxtName.gridwidth = 2;
                constraintsTxtName.fill = 2;
                constraintsTxtName.anchor = 18;
                constraintsTxtName.weightx = 1.0;
                constraintsTxtName.ipadx = 246;
                constraintsTxtName.insets = new Insets(12, 2, 8, 17);
                this.getBaseDialogContentPane().add((Component)this.getTxtName(), constraintsTxtName);
                GridBagConstraints constraintsChxIgnoreCase = new GridBagConstraints();
                constraintsChxIgnoreCase.gridx = 1;
                constraintsChxIgnoreCase.gridy = 4;
                constraintsChxIgnoreCase.gridwidth = 2;
                constraintsChxIgnoreCase.anchor = 18;
                constraintsChxIgnoreCase.ipadx = 36;
                constraintsChxIgnoreCase.insets = new Insets(2, 16, 7, 12);
                this.getBaseDialogContentPane().add((Component)this.getChxIgnoreCase(), constraintsChxIgnoreCase);
                GridBagConstraints constraintsChxUseDocument = new GridBagConstraints();
                constraintsChxUseDocument.gridx = 1;
                constraintsChxUseDocument.gridy = 3;
                constraintsChxUseDocument.gridwidth = 2;
                constraintsChxUseDocument.anchor = 18;
                constraintsChxUseDocument.ipadx = 21;
                constraintsChxUseDocument.insets = new Insets(3, 16, 2, 12);
                this.getBaseDialogContentPane().add((Component)this.getChxUseDocument(), constraintsChxUseDocument);
                GridBagConstraints constraintsChxUseName = new GridBagConstraints();
                constraintsChxUseName.gridx = 1;
                constraintsChxUseName.gridy = 2;
                constraintsChxUseName.gridwidth = 2;
                constraintsChxUseName.anchor = 18;
                constraintsChxUseName.ipadx = 67;
                constraintsChxUseName.insets = new Insets(8, 16, 2, 12);
                this.getBaseDialogContentPane().add((Component)this.getChxUseName(), constraintsChxUseName);
                GridBagConstraints constraintsBtnSearch = new GridBagConstraints();
                constraintsBtnSearch.gridx = 1;
                constraintsBtnSearch.gridy = 7;
                constraintsBtnSearch.gridwidth = 2;
                constraintsBtnSearch.fill = 2;
                constraintsBtnSearch.ipadx = 30;
                constraintsBtnSearch.insets = new Insets(5, 112, 11, 5);
                this.getBaseDialogContentPane().add((Component)this.getBtnSearch(), constraintsBtnSearch);
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 3;
                constraintsBtnCancel.gridy = 7;
                constraintsBtnCancel.fill = 2;
                constraintsBtnCancel.ipadx = 10;
                constraintsBtnCancel.insets = new Insets(5, 5, 11, 90);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsScpSearchList = new GridBagConstraints();
                constraintsScpSearchList.gridx = 1;
                constraintsScpSearchList.gridy = 6;
                constraintsScpSearchList.gridwidth = 3;
                constraintsScpSearchList.fill = 1;
                constraintsScpSearchList.anchor = 18;
                constraintsScpSearchList.weightx = 1.0;
                constraintsScpSearchList.weighty = 1.0;
                constraintsScpSearchList.ipadx = 376;
                constraintsScpSearchList.ipady = 74;
                constraintsScpSearchList.insets = new Insets(5, 16, 5, 12);
                this.getBaseDialogContentPane().add((Component)this.getScpSearchList(), constraintsScpSearchList);
                GridBagConstraints constraintsLblSearchList = new GridBagConstraints();
                constraintsLblSearchList.gridx = 1;
                constraintsLblSearchList.gridy = 5;
                constraintsLblSearchList.anchor = 18;
                constraintsLblSearchList.ipadx = 44;
                constraintsLblSearchList.insets = new Insets(7, 16, 4, 1);
                this.getBaseDialogContentPane().add((Component)this.getLblSearchList(), constraintsLblSearchList);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText("Abbrechen");
                this.ivjBtnCancel.setText(FindDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnSearch() {
        if (this.ivjBtnSearch == null) {
            try {
                this.ivjBtnSearch = new JButton();
                this.ivjBtnSearch.setName("BtnSearch");
                this.ivjBtnSearch.setText("Suchen");
                this.ivjBtnSearch.setText(resources.getString("BtnSearch_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnSearch;
    }

    private JCheckBox getChxIgnoreCase() {
        if (this.ivjChxIgnoreCase == null) {
            try {
                this.ivjChxIgnoreCase = new JCheckBox();
                this.ivjChxIgnoreCase.setName("ChxIgnoreCase");
                this.ivjChxIgnoreCase.setText("GROSS/klein  ignorieren");
                this.ivjChxIgnoreCase.setText(resources.getString("ChxIngoreCase_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjChxIgnoreCase;
    }

    private JCheckBox getChxUseDocument() {
        if (this.ivjChxUseDocument == null) {
            try {
                this.ivjChxUseDocument = new JCheckBox();
                this.ivjChxUseDocument.setName("ChxUseDocument");
                this.ivjChxUseDocument.setToolTipText("Element-Bescheibung");
                this.ivjChxUseDocument.setText("Beschreibung einbeziehen");
                this.ivjChxUseDocument.setText(resources.getString("ChxUseDescription_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjChxUseDocument;
    }

    private JCheckBox getChxUseName() {
        if (this.ivjChxUseName == null) {
            try {
                this.ivjChxUseName = new JCheckBox();
                this.ivjChxUseName.setName("ChxUseName");
                this.ivjChxUseName.setText("Name einbeziehen");
                this.ivjChxUseName.setText(resources.getString("ChxUseName_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjChxUseName;
    }

    private JLabel getLblName() {
        if (this.ivjLblName == null) {
            try {
                this.ivjLblName = new JLabel();
                this.ivjLblName.setName("LblName");
                this.ivjLblName.setText("Name:");
                this.ivjLblName.setText(resources.getString("LblName_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblName;
    }

    private JLabel getLblSearchList() {
        if (this.ivjLblSearchList == null) {
            try {
                this.ivjLblSearchList = new JLabel();
                this.ivjLblSearchList.setName("LblSearchList");
                this.ivjLblSearchList.setText("Suchergebnisse:");
                this.ivjLblSearchList.setText(resources.getString("LblSearchList_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblSearchList;
    }

    private JList getLstSearchList() {
        if (this.ivjLstSearchList == null) {
            try {
                this.ivjLstSearchList = new JList();
                this.ivjLstSearchList.setName("LstSearchList");
                this.ivjLstSearchList.setBounds(0, 0, 160, 120);
                this.ivjLstSearchList.setEnabled(true);
                this.ivjLstSearchList.setSelectionMode(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLstSearchList;
    }

    private JScrollPane getScpSearchList() {
        if (this.ivjScpSearchList == null) {
            try {
                this.ivjScpSearchList = new JScrollPane();
                this.ivjScpSearchList.setName("ScpSearchList");
                this.getScpSearchList().setViewportView(this.getLstSearchList());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScpSearchList;
    }

    private JTextField getTxtName() {
        if (this.ivjTxtName == null) {
            try {
                this.ivjTxtName = new JTextField();
                this.ivjTxtName.setName("TxtName");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtName;
    }

    private void initConnections() throws Exception {
        this.getBtnSearch().addActionListener(this.ivjEventHandler);
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getLstSearchList().addListSelectionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("FindDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 302);
            this.setTitle("Suchen");
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setTitle(resources.getString("CTTitle"));
        this.getChxUseName().setSelected(true);
        this.getChxIgnoreCase().setSelected(true);
    }

    private void search() {
        try {
            DefaultFindCondition condition = new DefaultFindCondition();
            condition.setText(this.getTxtName().getText());
            condition.setSearchInName(this.getChxUseName().isSelected());
            condition.setSearchInDocumentation(this.getChxUseDocument().isSelected());
            condition.setIgnoreCase(this.getChxIgnoreCase().isSelected());
            this.results = NamespaceUtility.deepFindOwnedElements(LauncherView.getInstance().getModel(), condition);
            this.showResults(this.results);
        }
        catch (Throwable e) {
            super.handleException(e);
        }
    }

    private void showResults(Set results) {
        this.getLstSearchList().removeAll();
        this.results = results;
        Iterator iterator = results.iterator();
        Vector<String> names = new Vector<String>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof ModelElement) {
                names.add(ElementUtils.formatWithPackageName((ModelElement)object));
                continue;
            }
            if (!(object instanceof Diagram)) continue;
            names.add(((Diagram)object).getName().getValue());
        }
        this.getLstSearchList().setListData(names);
    }

    private void selectElement(ListSelectionEvent listSelectionEvent) {
        int index = this.getLstSearchList().getSelectedIndex();
        if (index >= 0) {
            Iterator iterator = this.results.iterator();
            for (int i = 0; i < index; ++i) {
                iterator.next();
            }
            Element element = (Element)iterator.next();
            LauncherView.getInstance().getPnlNavigation().selectElement(element);
        }
    }

    class IvjEventHandler
    implements ActionListener,
    ListSelectionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FindDialog.this.getBtnSearch()) {
                FindDialog.this.connEtoC1(e);
            }
            if (e.getSource() == FindDialog.this.getBtnCancel()) {
                FindDialog.this.connEtoC2(e);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == FindDialog.this.getLstSearchList()) {
                FindDialog.this.connEtoC3(e);
            }
        }
    }
}

