/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.TextFigure;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.datatypes.Multiplicity;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.application.MultiplicityConverter;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.LinkFigure;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.PresentationRoleFigure;
import ch.ehi.umleditor.umlpresentation.PresentationRole;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.CommonUserAccess;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

class RoleDefFigure
extends NodeFigure {
    private PresentationRoleFigure edgeFigure = null;
    private LinkFigure linkFigure = null;
    protected static final int ROLE_DEF = 0;
    protected static final int CARDINALITY = 1;
    protected static final int ASSOCIATION_NAME = 2;
    private int type = 2;
    private TextFigure textFigure = null;

    public RoleDefFigure(LinkFigure linkFigure) {
        super(new RectangleFigure());
        this.linkFigure = linkFigure;
        this.type = 2;
        this.initializeView();
        this.updateView();
    }

    public RoleDefFigure(PresentationRoleFigure edgeFigure, int type) {
        super(new RectangleFigure());
        this.edgeFigure = edgeFigure;
        this.type = type;
        this.initializeView();
        this.updateView();
    }

    @Override
    protected JPopupMenu adaptPopupMenu(JPopupMenu popupMenu) {
        this.addSpecificationMenu(popupMenu);
        this.addSelectionMenu(popupMenu);
        popupMenu.add(new AbstractAction(RoleDefFigure.getResourceString(RoleDefFigure.class, "MniSelectTargetInBrowser_text")){

            @Override
            public void actionPerformed(ActionEvent event) {
                ModelElement ele = RoleDefFigure.this.getModelElement();
                Classifier target = null;
                if (ele instanceof Participant) {
                    Participant participant = (Participant)ele;
                    if (participant.containsParticipant()) {
                        target = participant.getParticipant();
                    }
                } else {
                    RoleDef role = (RoleDef)ele;
                    if (role.containsParticipant()) {
                        target = role.getParticipant();
                    }
                }
                if (target != null) {
                    LauncherView.getInstance().getPnlNavigation().selectElement(target);
                }
            }
        });
        popupMenu.add(new AbstractAction(RoleDefFigure.getResourceString(RoleDefFigure.class, "MniSelectOwnerInBrowser_text")){

            @Override
            public void actionPerformed(ActionEvent event) {
                RoleDef role;
                ModelElement ele = RoleDefFigure.this.getModelElement();
                if (ele instanceof Participant) {
                    ele = ((Participant)ele).getAssociation();
                }
                if ((role = (RoleDef)ele).getAssociation() != null) {
                    LauncherView.getInstance().getPnlNavigation().selectElement(role.getAssociation());
                }
            }
        });
        return popupMenu;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        if (this.type == 0) {
            Rectangle r = this.displayBox();
            g.setColor(this.edgeFigure.getLineColor());
            g.drawString("+", r.x - 8, r.y + 11);
        }
    }

    @Override
    protected ClassDiagramView getClassDiagram() {
        if (this.type == 2) {
            return this.linkFigure.getClassDiagram();
        }
        return this.edgeFigure.getClassDiagram();
    }

    private PresentationRole getEdge() {
        return (PresentationRole)this.edgeFigure.getEdge();
    }

    @Override
    public ModelElement getModelElement() {
        if (this.type == 2) {
            return this.linkFigure.getModelElement();
        }
        return this.edgeFigure.getModelElement();
    }

    protected void initializeView() {
        Color transparent = this.getClassDiagram().getBackground();
        this.getPresentationFigure().setAttribute("FrameColor", transparent);
        this.removeAll();
        this.textFigure = new TextFigure(){

            @Override
            public void setText(String newText) {
                if (newText != null) {
                    String name = newText;
                    if (RoleDefFigure.this.type == 1) {
                        try {
                            Multiplicity multiplicity = MultiplicityConverter.createMultiplicity(newText);
                            if (!MultiplicityConverter.isSame(multiplicity, RoleDefFigure.this.edgeFigure.getEndAssociationEnd().getMultiplicity())) {
                                RoleDefFigure.this.edgeFigure.getEndAssociationEnd().setMultiplicity(multiplicity);
                                name = MultiplicityConverter.getRange(multiplicity);
                            }
                        }
                        catch (Throwable e) {
                            String errorMsg = null;
                            errorMsg = e instanceof DeveloperException ? ((DeveloperException)e).getMessage() : "[" + e.toString() + "]";
                            BaseDialog.showWarning(LauncherView.getInstance(), NodeFigure.getResourceString(RoleDefFigure.class, "CTInvalidInput"), NodeFigure.getResourceString(RoleDefFigure.class, "CWInputReset") + "\n" + errorMsg);
                        }
                        name = MultiplicityConverter.getRange(RoleDefFigure.this.edgeFigure.getEndAssociationEnd().getMultiplicity());
                    } else if (!RoleDefFigure.this.updateName(newText)) {
                        name = RoleDefFigure.this.getModelElement().getDefLangName();
                    }
                    super.setText(name);
                    RoleDefFigure.this.update();
                }
            }
        };
        this.textFigure.setFont(this.getFont());
        this.add(this.textFigure);
    }

    @Override
    public void removeVisually() {
        try {
            switch (this.type) {
                case 0: {
                    this.getEdge().setNameVisible(false);
                    break;
                }
                case 1: {
                    this.getEdge().setMultiplicityVisible(false);
                    break;
                }
                case 2: {
                    this.linkFigure.removeLabels();
                }
            }
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, CommonUserAccess.getMniEditRemoveText(), null, this);
        }
    }

    @Override
    public void updateCoordinates() {
        Rectangle rectangle = this.getPresentationFigure().displayBox();
        double x1 = rectangle.getX();
        double y1 = rectangle.getY();
        if (this.type == 0) {
            this.getEdge().setNameAngle(x1);
            this.getEdge().setNameRadius(y1);
        } else if (this.type == 1) {
            this.getEdge().setMultiplicityAngle(x1);
            this.getEdge().setMultiplicityRadius(y1);
        } else if (this.type == 2) {
            // empty if block
        }
    }

    @Override
    public void updateView() {
        if (this.type == 0) {
            if (this.getModelElement() != null) {
                if (this.getModelElement() instanceof Participant) {
                    this.textFigure.setText(((Participant)this.getModelElement()).getAssociation().getDefLangName());
                } else {
                    this.textFigure.setText(this.getModelElement().getDefLangName());
                }
            }
        } else if (this.type == 1) {
            if (this.getEdge() != null && this.edgeFigure.getEndAssociationEnd() != null) {
                this.textFigure.setText(MultiplicityConverter.getRange(this.edgeFigure.getEndAssociationEnd().getMultiplicity()));
            }
        } else if (this.type == 2) {
            this.textFigure.setText(this.linkFigure.getModelElement().getDefLangName());
        }
    }
}

