/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.math.MathUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class AmountFormat
extends DecimalFormat {
    private static int FRACTION_DIGITS = 2;

    public static NumberFormat getAmountInstance() {
        return AmountFormat.getAmountInstance(Locale.getDefault());
    }

    public static NumberFormat getAmountInstance(Locale locale) {
        NumberFormat formatter = NumberFormat.getNumberInstance(locale);
        formatter.setMinimumFractionDigits(FRACTION_DIGITS);
        formatter.setMaximumFractionDigits(FRACTION_DIGITS);
        formatter.setGroupingUsed(true);
        return formatter;
    }

    public static String toString(double amount) {
        return AmountFormat.toString(new Double(amount));
    }

    public static String toString(Number amount) {
        if (amount == null) {
            return "";
        }
        return AmountFormat.getAmountInstance().format(amount);
    }

    public static double round(double amount) {
        return MathUtils.round(amount, FRACTION_DIGITS);
    }
}

