/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.Gradient;
import org.freehep.graphicsio.emf.GradientRectangle;
import org.freehep.graphicsio.emf.GradientTriangle;
import org.freehep.graphicsio.emf.TriVertex;

public class GradientFill
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private TriVertex[] vertices;
    private Gradient[] gradients;

    GradientFill() {
        super(118, 1);
    }

    public GradientFill(Rectangle bounds, int mode, TriVertex[] vertices, Gradient[] gradients) {
        this();
        this.bounds = bounds;
        this.mode = mode;
        this.vertices = vertices;
        this.gradients = gradients;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int i;
        Rectangle bounds = emf.readRECTL();
        TriVertex[] vertices = new TriVertex[emf.readDWORD()];
        Gradient[] gradients = new Gradient[emf.readDWORD()];
        int mode = emf.readULONG();
        for (i = 0; i < vertices.length; ++i) {
            vertices[i] = new TriVertex(emf);
        }
        for (i = 0; i < gradients.length; ++i) {
            gradients[i] = mode == 2 ? new GradientTriangle(emf) : new GradientRectangle(emf);
        }
        GradientFill tag = new GradientFill(bounds, mode, vertices, gradients);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        int i;
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.vertices.length);
        emf.writeDWORD(this.gradients.length);
        emf.writeULONG(this.mode);
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i].write(emf);
        }
        for (i = 0; i < this.gradients.length; ++i) {
            this.gradients[i].write(emf);
        }
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  bounds: " + this.bounds + "\n");
        s.append("  mode: " + this.mode + "\n");
        for (i = 0; i < this.vertices.length; ++i) {
            s.append("  vertex[" + i + "]: " + this.vertices[i] + "\n");
        }
        for (i = 0; i < this.gradients.length; ++i) {
            s.append("  gradient[" + i + "]: " + this.gradients[i] + "\n");
        }
        return s.toString();
    }
}

