/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.freehep.swing.graphics.GraphicalSelectionEvent;
import org.freehep.swing.graphics.GraphicalSelectionListener;

public class GraphicalSelectionPanel
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener,
Serializable {
    private ActionEvent actionEvent;
    protected LinkedList selectionActions = new LinkedList();
    protected ActionMap actionMap = new ActionMap();
    protected SelectionAction defaultModeAction = new SelectionAction("Default Mode", 13, KeyStroke.getKeyStroke(27, 0));
    protected SelectionAction nextAction = new SelectionAction("Next Mode", 10, KeyStroke.getKeyStroke(78, 0));
    protected SelectionAction previousAction = new SelectionAction("Previous Mode", 11, KeyStroke.getKeyStroke(80, 0));
    protected static final Stroke thinStroke = new BasicStroke(1.0f, 0, 0, 3.0f);
    protected static final Stroke thickStroke = new BasicStroke(3.0f, 0, 0, 5.0f);
    private JPopupMenu popup;
    private boolean processingPopup;
    private EventListenerList listenerList;
    private static final String NON_NULL_BORDER_ERROR = "GraphicalSelectionPanel does not support borders.";

    public GraphicalSelectionPanel() {
        JMenuItem item;
        TreeSet<KeyStroke> keys = new TreeSet<KeyStroke>();
        keys.add(KeyStroke.getKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, keys);
        this.setFocusTraversalKeys(1, keys);
        this.setOpaque(false);
        this.listenerList = new EventListenerList();
        this.actionEvent = new ActionEvent(this, 0, "KeyAction");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setRequestFocusEnabled(true);
        this.makeSelectionActions();
        this.popup = new JPopupMenu();
        this.processingPopup = false;
        JPopupMenu popup = this.getPopupMenu();
        Iterator i = this.selectionActions.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            item = new JMenuItem(action);
            KeyStroke accelerator = (KeyStroke)action.getValue("AcceleratorKey");
            this.addActionEntry(accelerator, action);
            item.setAccelerator(accelerator);
            popup.add(item);
        }
        popup.addSeparator();
        item = new JMenuItem(this.nextAction);
        KeyStroke accelerator = (KeyStroke)this.nextAction.getValue("AcceleratorKey");
        this.addActionEntry(accelerator, (Action)this.nextAction);
        item.setAccelerator(accelerator);
        popup.add(item);
        item = new JMenuItem(this.previousAction);
        accelerator = (KeyStroke)this.previousAction.getValue("AcceleratorKey");
        this.addActionEntry(accelerator, (Action)this.previousAction);
        item.setAccelerator(accelerator);
        popup.add(item);
        item = new JMenuItem(this.defaultModeAction);
        accelerator = (KeyStroke)this.defaultModeAction.getValue("AcceleratorKey");
        this.addActionEntry(accelerator, (Action)this.defaultModeAction);
        item.setAccelerator(accelerator);
        popup.add(item);
    }

    private void makeSelectionActions() {
        AbstractAction action = new SelectionAction("Zoom", 0, KeyStroke.getKeyStroke(10, 0));
        this.selectionActions.add(action);
        this.addActionEntry(10, (Action)action);
        action = new SelectionAction("Zoom (new view)", 1, KeyStroke.getKeyStroke(86, 0));
        this.selectionActions.add(action);
        this.addActionEntry(78, (Action)action);
        action = new SelectionAction("Pick", 2, KeyStroke.getKeyStroke(32, 0));
        this.selectionActions.add(action);
        this.addActionEntry(32, (Action)action);
        action = new SelectionAction("Pick (add)", 3, KeyStroke.getKeyStroke(521, 0));
        this.selectionActions.add(action);
        this.addActionEntry(61, (Action)action);
        this.addActionEntry(521, (Action)action);
        action = new SelectionAction("Un-Pick", 4, KeyStroke.getKeyStroke(45, 0));
        this.selectionActions.add(action);
        this.addActionEntry(523, (Action)action);
        this.addActionEntry(45, (Action)action);
        action = new ClearAction(KeyStroke.getKeyStroke(127, 0));
        this.selectionActions.add(action);
        this.addActionEntry(27, (Action)action);
        this.addActionEntry(8, (Action)action);
        this.addActionEntry(127, (Action)action);
    }

    protected void setSelectionActionsEnabled(boolean enable) {
        Iterator i = this.selectionActions.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            action.setEnabled(enable);
        }
    }

    public void resetSelection() {
    }

    protected JPopupMenu getPopupMenu() {
        return this.popup;
    }

    protected void cancelPopupProcessing() {
        this.processingPopup = false;
    }

    public boolean isProcessingPopup(MouseEvent e) {
        int id = e.getID();
        boolean flag = this.processingPopup;
        if (id == 501) {
            if (!this.processingPopup && this.testPopupTrigger(e)) {
                this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                this.processingPopup = true;
                flag = true;
            }
        } else if (id == 502) {
            if (!this.processingPopup && this.testPopupTrigger(e)) {
                this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                this.processingPopup = true;
                flag = true;
            } else if (this.processingPopup && !this.getPopupMenu().isVisible()) {
                this.processingPopup = false;
                flag = true;
            }
        }
        return flag;
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException(NON_NULL_BORDER_ERROR);
        }
    }

    public final Border getBorder() {
        return null;
    }

    public void reshape(int x, int y, int width, int height) {
        this.resetSelection();
        super.reshape(x, y, width, height);
    }

    public void addGraphicalSelectionListener(GraphicalSelectionListener listener) {
        this.listenerList.add(GraphicalSelectionListener.class, listener);
    }

    public void removeGraphicalSelectionListener(GraphicalSelectionListener listener) {
        this.listenerList.remove(GraphicalSelectionListener.class, listener);
    }

    protected void fireGraphicalSelectionMade(GraphicalSelectionEvent gsEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$freehep$swing$graphics$GraphicalSelectionListener == null ? GraphicalSelectionPanel.class$("org.freehep.swing.graphics.GraphicalSelectionListener") : class$org$freehep$swing$graphics$GraphicalSelectionListener)) continue;
            ((GraphicalSelectionListener)listeners[i + 1]).graphicalSelectionMade(gsEvent);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        Action action;
        int keyCode = e.getKeyCode();
        int modifiers = 0;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        InputMap inputMap = this.getInputMap();
        Object actionKey = inputMap.get(keyStroke);
        if (actionKey != null && (action = this.actionMap.get(actionKey)) != null) {
            action.actionPerformed(this.actionEvent);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void makeSelectionEvent(int type) {
    }

    protected boolean testPopupTrigger(MouseEvent e) {
        int modifiers = e.getModifiers();
        return (modifiers & 4) != 0;
    }

    protected void addActionEntry(int keyCode, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, 0);
        this.addActionEntry(keyStroke, action);
    }

    protected void addActionEntry(KeyStroke keyStroke, Action action) {
        Object actionMapKey = action.getValue("Name");
        this.actionMap.put(actionMapKey, action);
        InputMap inputMap = this.getInputMap();
        inputMap.put(keyStroke, actionMapKey);
    }

    class ClearAction
    extends AbstractAction {
        public ClearAction(KeyStroke keyStroke) {
            super("Clear");
            this.putValue("AcceleratorKey", keyStroke);
        }

        public void actionPerformed(ActionEvent e) {
            GraphicalSelectionPanel.this.cancelPopupProcessing();
            GraphicalSelectionPanel.this.resetSelection();
        }
    }

    class SelectionAction
    extends AbstractAction {
        private int actionCode;

        public SelectionAction(String name, int actionCode) {
            super(name);
            this.actionCode = actionCode;
        }

        public SelectionAction(String name, int actionCode, KeyStroke keyStroke) {
            this(name, actionCode);
            this.putValue("AcceleratorKey", keyStroke);
        }

        public void actionPerformed(ActionEvent e) {
            GraphicalSelectionPanel.this.cancelPopupProcessing();
            if (this.isEnabled()) {
                GraphicalSelectionPanel.this.makeSelectionEvent(this.actionCode);
            }
        }
    }
}

