/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.menus;

import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.util.NestedRuntimeException;
import org.freehep.util.images.ImageHandler;
import org.freehep.xml.util.BadXMLException;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.freehep.xml.util.SAXErrorHandler;
import org.freehep.xml.util.SAXTraverser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLMenuBuilder {
    public static final String LOCATION_PROPERTY = "Location";
    private Class defaultMenuBarClass = JMenuBar.class;
    private Class defaultToolBarClass = JToolBar.class;
    private Class defaultMenuItemClass = JMenuItem.class;
    private Class defaultRadioButtonMenuItemClass = JRadioButtonMenuItem.class;
    private Class defaultCheckBoxMenuItemClass = JCheckBoxMenuItem.class;
    private Class defaultPopupMenuClass = JPopupMenu.class;
    private Class defaultToolBarButtonClass = JButton.class;
    private Class defaultMenuClass = JMenu.class;
    private URL baseURL;
    private Hashtable menuBarHash = new Hashtable();
    private Hashtable toolBarHash = new Hashtable();
    private Hashtable popupMenuHash = new Hashtable();
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public XMLMenuBuilder() {
        UIManager.addPropertyChangeListener(new UIListener(this));
    }

    /*
     * WARNING - void declaration
     */
    public void build(URL xml) throws SAXException, IOException {
        void var2_2;
        XMLReader reader;
        try {
            reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (SecurityException x) {
            try {
                String parser = System.getProperty("org.xml.sax.driver");
                if (parser == null) {
                    System.getProperties().setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
                }
            }
            catch (SecurityException xx) {
                // empty catch block
            }
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (Exception x) {
            throw new NestedRuntimeException("Error creating XML Parser", x);
        }
        this.build(xml, (XMLReader)var2_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(URL xml, XMLReader reader) throws SAXException, IOException {
        reader.setFeature("http://xml.org/sax/features/validation", true);
        reader.setEntityResolver(new ClassPathEntityResolver("menus.dtd", XMLMenuBuilder.class));
        MenuSystemTraverser t = new MenuSystemTraverser();
        t.setReader(reader);
        reader.setErrorHandler(new SAXErrorHandler());
        this.baseURL = xml;
        BufferedInputStream in = new BufferedInputStream(xml.openStream());
        try {
            InputSource input = new InputSource(in);
            input.setSystemId(xml.toString());
            input.setPublicId(xml.getFile());
            reader.parse(input);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public void setDefaultMenuBarClass(Class klass) throws IllegalDefaultClassException {
        this.defaultMenuBarClass = this.setDefaultClass(JMenuBar.class, klass);
    }

    public void setDefaultMenuClass(Class klass) throws IllegalDefaultClassException {
        this.defaultMenuClass = this.setDefaultClass(JMenu.class, klass);
    }

    public void setDefaultMenuItemClass(Class klass) throws IllegalDefaultClassException {
        this.defaultMenuItemClass = this.setDefaultClass(JMenuItem.class, klass);
    }

    public void setDefaultRadioMenuItemClass(Class klass) throws IllegalDefaultClassException {
        this.defaultRadioButtonMenuItemClass = this.setDefaultClass(JMenuItem.class, klass);
    }

    public void setDefaultCheckBoxMenuItemClass(Class klass) throws IllegalDefaultClassException {
        this.defaultCheckBoxMenuItemClass = this.setDefaultClass(JMenuItem.class, klass);
    }

    public void setDefaultPopupMenuClass(Class klass) throws IllegalDefaultClassException {
        this.defaultPopupMenuClass = this.setDefaultClass(JPopupMenu.class, klass);
    }

    public void setDefaultToolBarClass(Class klass) throws IllegalDefaultClassException {
        this.defaultToolBarClass = this.setDefaultClass(JToolBar.class, klass);
    }

    public void setDefaultToolBarItemClass(Class klass) throws IllegalDefaultClassException {
        this.defaultToolBarButtonClass = this.setDefaultClass(JButton.class, klass);
    }

    protected JMenuBar createMenuBar(String className) throws SAXException {
        Class klass = className == null ? this.defaultMenuBarClass : this.findClass(className);
        return (JMenuBar)this.createObject(klass, JMenuBar.class);
    }

    protected JMenu createMenu(String className) throws SAXException {
        Class klass = className == null ? this.defaultMenuClass : this.findClass(className);
        return (JMenu)this.createObject(klass, JMenu.class);
    }

    protected JMenuItem createMenuItem(String className, String name, String type, String command) throws SAXException {
        Class klass = className == null ? (type.equals("checkbox") ? this.defaultCheckBoxMenuItemClass : (type.equals("radio") ? this.defaultRadioButtonMenuItemClass : this.defaultMenuItemClass)) : this.findClass(className);
        JMenuItem result = (JMenuItem)this.createObject(klass, JMenuItem.class);
        result.setText(name);
        if (command != null) {
            result.setActionCommand(command);
        }
        return result;
    }

    protected JPopupMenu createPopupMenu(String className) throws SAXException {
        Class klass = className == null ? this.defaultPopupMenuClass : this.findClass(className);
        return (JPopupMenu)this.createObject(klass, JPopupMenu.class);
    }

    protected JToolBar createToolBar(String className) throws SAXException {
        Class klass = className == null ? this.defaultToolBarClass : this.findClass(className);
        return (JToolBar)this.createObject(klass, JToolBar.class);
    }

    protected AbstractButton createToolBarItem(String className, String name, String type, String command) throws SAXException {
        Class klass = className == null ? this.defaultToolBarButtonClass : this.findClass(className);
        klass = type.equals("checkbox") ? JToggleButton.class : JButton.class;
        AbstractButton result = (AbstractButton)this.createObject(klass, AbstractButton.class);
        result.setMargin(new Insets(0, 0, 0, 0));
        if (command != null) {
            result.setActionCommand(command);
        }
        return result;
    }

    protected Icon createIcon(String name) throws SAXException {
        try {
            URL url = null;
            if (name.startsWith("/")) {
                url = this.getClass().getResource(name);
            }
            if (url == null) {
                url = new URL(this.baseURL, name);
            }
            return ImageHandler.getIcon(url);
        }
        catch (MalformedURLException x) {
            throw new BadXMLException("Could not load image: " + name, (Throwable)x);
        }
    }

    private void merge(JComponent oldMenu, JComponent newMenu) {
        if (newMenu instanceof JMenu) {
            newMenu = ((JMenu)newMenu).getPopupMenu();
        }
        if (oldMenu instanceof JMenu) {
            oldMenu = ((JMenu)oldMenu).getPopupMenu();
        }
        block0: for (int i = 0; i < newMenu.getComponentCount(); ++i) {
            JComponent comp;
            Integer location;
            Component c = newMenu.getComponent(i);
            if (c instanceof JComponent && (location = (Integer)(comp = (JComponent)c).getClientProperty(LOCATION_PROPERTY)) != null) {
                int oldCount = oldMenu.getComponentCount();
                for (int j = 0; j < oldCount; ++j) {
                    JComponent oldComp;
                    Integer oldLocation;
                    Component old = oldMenu.getComponent(j);
                    if (!(old instanceof JComponent) || (oldLocation = (Integer)(oldComp = (JComponent)old).getClientProperty(LOCATION_PROPERTY)) == null) continue;
                    if (oldLocation.equals(location)) {
                        this.merge(oldComp, comp);
                        continue block0;
                    }
                    if (oldLocation.compareTo(location) <= 0) continue;
                    oldMenu.add((Component)comp, j);
                    --i;
                    continue block0;
                }
            }
            oldMenu.add(c);
            --i;
        }
    }

    public JMenuBar getMenuBar(String id) {
        return (JMenuBar)this.menuBarHash.get(id);
    }

    public JToolBar getToolBar(String id) {
        return (JToolBar)this.toolBarHash.get(id);
    }

    public JPopupMenu getPopupMenu(String id) {
        return (JPopupMenu)this.popupMenuHash.get(id);
    }

    public JPopupMenu mergePopupMenu(String id, JPopupMenu menu) {
        try {
            JPopupMenu merge = this.getPopupMenu(id);
            if (menu == null) {
                return merge;
            }
            Component[] c = merge.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (c[i] instanceof JSeparator) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(this.deepCopy(c[i]));
            }
            return menu;
        }
        catch (SAXException x) {
            throw new NestedRuntimeException(x);
        }
    }

    private Component deepCopy(Component c) throws SAXException {
        if (c instanceof JMenu) {
            JMenu old = (JMenu)c;
            JMenu menu = this.createMenu(old.getClass().getName());
            Component[] cc = old.getPopupMenu().getComponents();
            for (int i = 0; i < cc.length; ++i) {
                if (cc[i] instanceof JSeparator) {
                    menu.addSeparator();
                    continue;
                }
                menu.add(this.deepCopy(cc[i]));
            }
            menu.setText(old.getText());
            menu.setMnemonic(old.getMnemonic());
            return menu;
        }
        if (c instanceof JMenuItem) {
            JMenuItem old = (JMenuItem)c;
            JMenuItem item = this.createMenuItem(old.getClass().getName(), old.getText(), null, old.getActionCommand());
            item.setToolTipText(old.getToolTipText());
            item.setIcon(old.getIcon());
            item.setMnemonic(old.getMnemonic());
            item.setAccelerator(old.getAccelerator());
            return item;
        }
        return c;
    }

    private Object createObject(Class klass, Class superKlass) throws SAXException {
        try {
            if (!superKlass.isAssignableFrom(klass)) {
                throw new SAXException("Illegal class " + klass);
            }
            return klass.newInstance();
        }
        catch (SAXException x) {
            throw x;
        }
        catch (Exception x) {
            throw new BadXMLException("Could not create " + klass, (Throwable)x);
        }
    }

    private Class findClass(String className) throws SAXException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException x) {
            throw new BadXMLException("Can not find class " + className, (Throwable)x);
        }
    }

    private Class setDefaultClass(Class baseClass, Class klass) throws IllegalDefaultClassException {
        if (baseClass.isAssignableFrom(klass)) {
            return klass;
        }
        throw new IllegalDefaultClassException("Cannot assign into " + baseClass + " from " + klass);
    }

    public static class IllegalDefaultClassException
    extends RuntimeException {
        IllegalDefaultClassException(String s) {
            super(s);
        }
    }

    private class ToolBarItemTraverser
    extends ComponentTraverser {
        private AbstractButton item;

        private ToolBarItemTraverser() {
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            String desc;
            String location;
            String klass = attrs.getValue("class");
            String name = attrs.getValue("name");
            String type = attrs.getValue("type");
            String command = attrs.getValue("command");
            this.item = XMLMenuBuilder.this.createToolBarItem(klass, name, type, command);
            String mnemonic = attrs.getValue("mnemonic");
            if (mnemonic != null) {
                this.item.setMnemonic(mnemonic.charAt(0));
            }
            if ((location = attrs.getValue("location")) != null) {
                this.item.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, location);
            }
            if ((desc = attrs.getValue("description")) == null) {
                desc = name;
            }
            this.item.setToolTipText(desc);
            String icon = attrs.getValue("icon");
            if (icon != null) {
                this.item.setIcon(XMLMenuBuilder.this.createIcon(icon));
            }
        }

        protected void setAccelerator(KeyStroke key) {
        }

        AbstractButton getToolBarItem() {
            return this.item;
        }
    }

    private static class UIListener
    implements PropertyChangeListener {
        WeakReference link;

        UIListener(XMLMenuBuilder builder) {
            this.link = new WeakReference<XMLMenuBuilder>(builder);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            XMLMenuBuilder builder = (XMLMenuBuilder)this.link.get();
            if (builder == null) {
                UIManager.removePropertyChangeListener(this);
            } else if (evt.getPropertyName().equals("lookAndFeel")) {
                Enumeration e = builder.popupMenuHash.elements();
                while (e.hasMoreElements()) {
                    JComponent c = (JComponent)e.nextElement();
                    SwingUtilities.updateComponentTreeUI(c);
                }
            }
        }
    }

    private class SeparatorTraverser
    extends MenuSystemTraverser {
        private String location;

        private SeparatorTraverser() {
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            this.location = attrs.getValue("location");
        }

        String getLocation() {
            return this.location;
        }
    }

    private class MenuItemTraverser
    extends ComponentTraverser {
        private JMenuItem item;

        private MenuItemTraverser() {
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            String desc;
            String location;
            String klass = attrs.getValue("class");
            String name = attrs.getValue("name");
            String type = attrs.getValue("type");
            String command = attrs.getValue("command");
            this.item = XMLMenuBuilder.this.createMenuItem(klass, name, type, command);
            String mnemonic = attrs.getValue("mnemonic");
            if (mnemonic != null) {
                this.item.setMnemonic(mnemonic.charAt(0));
            }
            if ((location = attrs.getValue("location")) != null) {
                this.item.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(location));
            }
            if ((desc = attrs.getValue("description")) == null) {
                desc = name;
            }
            this.item.setToolTipText(desc);
            String icon = attrs.getValue("icon");
            if (icon != null) {
                this.item.setIcon(XMLMenuBuilder.this.createIcon(icon));
            }
        }

        protected void setAccelerator(KeyStroke key) {
            this.item.setAccelerator(key);
        }

        JMenuItem getMenuItem() {
            return this.item;
        }
    }

    private class AcceleratorTraverser
    extends SAXTraverser {
        protected KeyStroke key;

        private AcceleratorTraverser() {
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            String theKey = attrs.getValue("key");
            boolean theCtrlMod = this.toBoolean(attrs.getValue("ctrl"));
            boolean theAltMod = this.toBoolean(attrs.getValue("alt"));
            boolean theShiftMod = this.toBoolean(attrs.getValue("shift"));
            boolean theMetaMod = this.toBoolean(attrs.getValue("meta"));
            try {
                this.key = KeyStroke.getKeyStroke((class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = XMLMenuBuilder.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField(theKey).getInt(null), (theCtrlMod ? 2 : 0) + (theAltMod ? 8 : 0) + (theShiftMod ? 1 : 0) + (theMetaMod ? 4 : 0));
            }
            catch (Exception eh) {
                throw new BadXMLException("Illegal accelerator key: " + theKey);
            }
        }

        KeyStroke getAccelerator() {
            return this.key;
        }
    }

    private abstract class ComponentTraverser
    extends MenuSystemTraverser {
        private ComponentTraverser() {
        }

        protected void handleSubElement(SAXTraverser sub) {
            if (sub instanceof AcceleratorTraverser) {
                this.setAccelerator(((AcceleratorTraverser)sub).getAccelerator());
            }
        }

        abstract void setAccelerator(KeyStroke var1);
    }

    private class ToolBarTraverser
    extends MenuSystemTraverser {
        private String id;
        private JToolBar toolBar;

        private ToolBarTraverser() {
        }

        protected SAXTraverser handleElement(String name, Attributes attrs) throws SAXException {
            if (name == "Component") {
                return new ToolBarItemTraverser();
            }
            return super.handleElement(name, attrs);
        }

        protected void handleSubElement(SAXTraverser sub) {
            if (sub instanceof ToolBarItemTraverser) {
                this.toolBar.add(((ToolBarItemTraverser)sub).getToolBarItem());
            } else if (sub instanceof SeparatorTraverser) {
                JToolBar.Separator sep = new JToolBar.Separator();
                String location = ((SeparatorTraverser)sub).getLocation();
                if (location != null) {
                    sep.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(location));
                }
                this.toolBar.add(sep);
            }
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            this.id = attrs.getValue("id");
            String klass = attrs.getValue("class");
            this.toolBar = XMLMenuBuilder.this.createToolBar(klass);
            this.toolBar.setName(attrs.getValue("name"));
            this.toolBar.setRollover(this.toBoolean(attrs.getValue("rollover")));
        }

        protected void handleEndElement(String name) {
            XMLMenuBuilder.this.toolBarHash.put(this.id, this.toolBar);
        }
    }

    private class MenuTraverser
    extends MenuSystemTraverser {
        private JMenu menu;

        private MenuTraverser() {
        }

        protected void handleSubElement(SAXTraverser sub) {
            if (sub instanceof MenuItemTraverser) {
                this.menu.add(((MenuItemTraverser)sub).getMenuItem());
            } else if (sub instanceof MenuTraverser) {
                this.menu.add(((MenuTraverser)sub).getMenu());
            } else if (sub instanceof SeparatorTraverser) {
                JPopupMenu.Separator sep = new JPopupMenu.Separator();
                String location = ((SeparatorTraverser)sub).getLocation();
                if (location != null) {
                    sep.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(location));
                }
                this.menu.add(sep);
            }
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            String location;
            String klass = attrs.getValue("class");
            this.menu = XMLMenuBuilder.this.createMenu(klass);
            this.menu.setText(attrs.getValue("name"));
            String mnemonic = attrs.getValue("mnemonic");
            if (mnemonic != null) {
                this.menu.setMnemonic(mnemonic.charAt(0));
            }
            if ((location = attrs.getValue("location")) != null) {
                this.menu.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(location));
            }
        }

        JMenu getMenu() {
            return this.menu;
        }
    }

    private class PopupMenuTraverser
    extends MenuSystemTraverser {
        private JPopupMenu menu;
        private String id;

        private PopupMenuTraverser() {
        }

        protected void handleSubElement(SAXTraverser sub) throws SAXException {
            if (sub instanceof MenuItemTraverser) {
                this.menu.add(((MenuItemTraverser)sub).getMenuItem());
            } else if (sub instanceof MenuTraverser) {
                this.menu.add(((MenuTraverser)sub).getMenu());
            } else if (sub instanceof SeparatorTraverser) {
                JPopupMenu.Separator sep = new JPopupMenu.Separator();
                String location = ((SeparatorTraverser)sub).getLocation();
                if (location != null) {
                    sep.putClientProperty(XMLMenuBuilder.LOCATION_PROPERTY, Integer.valueOf(location));
                }
                this.menu.add(sep);
            }
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            String klass = attrs.getValue("class");
            this.menu = XMLMenuBuilder.this.createPopupMenu(klass);
            this.menu.setName(attrs.getValue("name"));
            this.id = attrs.getValue("id");
        }

        protected void handleEndElement(String name) {
            XMLMenuBuilder.this.popupMenuHash.put(this.id, this.menu);
        }
    }

    private class MenuBarTraverser
    extends MenuSystemTraverser {
        private JMenuBar menuBar;
        private String id;

        private MenuBarTraverser() {
        }

        protected void handleSubElement(SAXTraverser sub) throws SAXException {
            if (sub instanceof MenuTraverser) {
                this.menuBar.add(((MenuTraverser)sub).getMenu());
            }
        }

        protected void handleElementAttributes(Attributes attrs) throws SAXException {
            String klass = attrs.getValue("class");
            this.menuBar = XMLMenuBuilder.this.createMenuBar(klass);
            this.id = attrs.getValue("id");
        }

        protected void handleEndElement(String name) {
            JMenuBar oldMenu = (JMenuBar)XMLMenuBuilder.this.menuBarHash.get(this.id);
            if (oldMenu == null) {
                XMLMenuBuilder.this.menuBarHash.put(this.id, this.menuBar);
            } else {
                XMLMenuBuilder.this.merge(oldMenu, this.menuBar);
            }
        }
    }

    private class MenuSystemTraverser
    extends SAXTraverser {
        private MenuSystemTraverser() {
        }

        protected SAXTraverser handleElement(String name, Attributes attrs) throws SAXException {
            if (name == "MenuSystem") {
                return this;
            }
            if (name == "MenuBar") {
                return new MenuBarTraverser();
            }
            if (name == "ToolBar") {
                return new ToolBarTraverser();
            }
            if (name == "PopupMenu") {
                return new PopupMenuTraverser();
            }
            if (name == "Menu") {
                return new MenuTraverser();
            }
            if (name == "Component") {
                return new MenuItemTraverser();
            }
            if (name == "Accelerator") {
                return new AcceleratorTraverser();
            }
            if (name == "Separator") {
                return new SeparatorTraverser();
            }
            return super.handleElement(name, attrs);
        }
    }
}

