/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.custom;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.Main;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.Program;
import com.baselet.custom.CustomCodeSyntaxPane;
import com.baselet.custom.CustomElementPanel;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.CustomPreviewHandler;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElement;
import com.baselet.element.old.custom.CustomElementCompileTask;
import com.baselet.element.old.custom.CustomElementCompiler;
import com.baselet.element.old.custom.ErrorHandler;
import com.baselet.gui.CurrentGui;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class CustomElementHandler {
    private final Timer timer;
    private final CustomCodeSyntaxPane codepane = new CustomCodeSyntaxPane();
    private final CustomPreviewHandler preview;
    private GridElement editedEntity;
    private GridElement originalElement;
    private TimerTask compiletask;
    private boolean changed;
    private final ErrorHandler errorhandler = new ErrorHandler(this.codepane);
    private boolean compilation_running;
    private final CustomElementPanel panel;
    boolean keypressed;
    private String old_text;

    public CustomElementHandler() {
        this.codepane.getTextComponent().addMouseMotionListener(this.errorhandler);
        this.preview = new CustomPreviewHandler();
        this.timer = new Timer("customElementTimer", true);
        this.changed = false;
        this.compilation_running = false;
        this.old_text = null;
        this.panel = new CustomElementPanel(this);
    }

    public CustomElementPanel getPanel() {
        return this.panel;
    }

    public void newEntity() {
        this.newEntity("Default");
    }

    public void newEntity(String template) {
        this.preview.closePreview();
        this.originalElement = null;
        this.editedEntity = CustomElementCompiler.getInstance().genEntityFromTemplate(template, this.errorhandler);
        if (this.editedEntity instanceof CustomElement) {
            this.codepane.setCode(((CustomElement)this.editedEntity).getCode());
        } else {
            this.codepane.setCode("");
        }
        this.editedEntity.setPanelAttributes("// Modify the text below and\n// observe the element preview.\n\nHello, World! \nEnjoy " + Program.getInstance().getProgramName() + "!");
        this.editedEntity.setRectangle(new Rectangle(20, 20, 200, 200));
        this.updatePreview(this.editedEntity);
        this.getPreviewHandler().getDrawPanel().getSelector().select(this.editedEntity);
        this.setChanged(false);
        this.start();
    }

    public void editEntity(CustomElement e) {
        this.preview.closePreview();
        this.originalElement = e;
        this.editedEntity = e.cloneFromMe();
        this.editedEntity.setLocation(20, 20);
        this.codepane.setCode(e.getCode());
        this.updatePreview(this.editedEntity);
        this.getPreviewHandler().getDrawPanel().getSelector().select(this.editedEntity);
        this.setChanged(false);
        this.start();
    }

    public void saveEntity() {
        GridElement e;
        this.editedEntity = e = CustomElementCompiler.getInstance().genEntity(this.codepane.getText(), this.errorhandler);
        this.updatePreview(e);
        this.updateElement(e);
        this.setChanged(false);
    }

    public boolean closeEntity() {
        if (this.changed) {
            this.setChanged(false);
        }
        this.stop();
        this.preview.closePreview();
        this.preview.getDrawPanel().getSelector().deselectAll();
        CurrentDiagram.getInstance().getDiagramHandler().getController().clear();
        DrawPanel dia = CurrentGui.getInstance().getGui().getCurrentDiagram();
        if (dia != null) {
            dia.getSelector().updateSelectorInformation();
        } else {
            Main.getInstance().setPropertyPanelToGridElement(null);
        }
        return true;
    }

    public CustomPreviewHandler getPreviewHandler() {
        return this.preview;
    }

    public CustomCodeSyntaxPane getCodePane() {
        return this.codepane;
    }

    private void updatePreview(GridElement e) {
        if (e != null) {
            Iterator<GridElement> iter = this.preview.getDrawPanel().getGridElements().iterator();
            if (iter.hasNext()) {
                GridElement element = iter.next();
                e.setRectangle(element.getRectangle());
                e.setPanelAttributes(element.getPanelAttributes());
                this.preview.getDrawPanel().removeElement(element);
            }
            this.preview.setHandlerAndInitListeners(e);
            this.preview.getDrawPanel().addElement(e);
            e.repaint();
        }
    }

    private void start() {
        this.compiletask = new CustomElementCompileTask(this);
        this.timer.schedule(this.compiletask, 500L, 500L);
    }

    private void stop() {
        if (this.compiletask != null) {
            this.compiletask.cancel();
        }
    }

    protected void runCompilation() {
        if (!this.compilation_running && !this.keypressed) {
            this.compilation_running = true;
            String txt = this.codepane.getText();
            if (!txt.equals(this.old_text)) {
                this.setChanged(true);
                this.errorhandler.clearErrors();
                this.old_text = txt;
                this.editedEntity = CustomElementCompiler.getInstance().genEntity(txt, this.errorhandler);
                this.panel.setCustomElementSaveable(true);
                this.updatePreview(this.editedEntity);
            }
            this.compilation_running = false;
        }
        this.keypressed = false;
    }

    private void setChanged(boolean changed) {
        this.changed = changed;
        CurrentGui.getInstance().getGui().setCustomElementChanged(this, changed);
    }

    private void updateElement(GridElement element) {
        if (this.originalElement == null) {
            DiagramHandler current = null;
            DrawPanel c = CurrentGui.getInstance().getGui().getCurrentDiagram();
            if (c == null) {
                Main.getInstance().doNew();
                current = CurrentGui.getInstance().getGui().getCurrentDiagram().getHandler();
            } else {
                current = c.getHandler();
            }
            int x = 10;
            int y = 10;
            for (GridElement e : current.getDrawPanel().getGridElements()) {
                if (e.getRectangle().y + e.getRectangle().height + 10 <= y) continue;
                y = e.getRectangle().y + e.getRectangle().height + 10;
            }
            Rectangle bounds = new Rectangle(x, y, element.getRectangle().width, element.getRectangle().height);
            this.addElementToDiagram(element, current, true, bounds, element.getPanelAttributes());
        } else {
            HandlerElementMap.getHandlerForElement(this.originalElement).getDrawPanel().removeElement(this.originalElement);
            this.addElementToDiagram(element, HandlerElementMap.getHandlerForElement(this.originalElement), true, this.originalElement.getRectangle(), this.originalElement.getPanelAttributes());
        }
    }

    private void addElementToDiagram(GridElement e, DiagramHandler d, boolean setchanged, Rectangle bounds, String state) {
        GridElement e2 = ElementFactorySwing.createCopy(e, d);
        e2.setPanelAttributes(state);
        e2.setRectangle(bounds);
        d.getDrawPanel().addElement(e2);
        if (setchanged) {
            d.setChanged(true);
        }
    }
}

