/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceDiscovery;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.LocatorRegistryPrx;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Plugin;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import com.zeroc.IceDiscovery.LocatorI;
import com.zeroc.IceDiscovery.LocatorRegistryI;
import com.zeroc.IceDiscovery.LookupI;
import com.zeroc.IceDiscovery.LookupPrx;
import com.zeroc.IceDiscovery.LookupReplyI;
import com.zeroc.IceDiscovery.LookupReplyPrx;
import com.zeroc.IceInternal.Network;
import java.util.List;
import java.util.UUID;

public class PluginI
implements Plugin {
    private Communicator _communicator;
    private ObjectAdapter _multicastAdapter;
    private ObjectAdapter _replyAdapter;
    private ObjectAdapter _locatorAdapter;
    private LocatorPrx _locator;
    private LocatorPrx _defaultLocator;

    public PluginI(Communicator communicator) {
        this._communicator = communicator;
    }

    @Override
    public void initialize() {
        String lookupEndpoints;
        Properties properties = this._communicator.getProperties();
        boolean ipv4 = properties.getPropertyAsIntWithDefault("Ice.IPv4", 1) > 0;
        boolean preferIPv6 = properties.getPropertyAsInt("Ice.PreferIPv6Address") > 0;
        String address = ipv4 && !preferIPv6 ? properties.getPropertyWithDefault("IceDiscovery.Address", "239.255.0.1") : properties.getPropertyWithDefault("IceDiscovery.Address", "ff15::1");
        int port = properties.getPropertyAsIntWithDefault("IceDiscovery.Port", 4061);
        String intf = properties.getProperty("IceDiscovery.Interface");
        if (properties.getProperty("IceDiscovery.Multicast.Endpoints").isEmpty()) {
            StringBuilder s = new StringBuilder();
            s.append("udp -h \"").append(address).append("\" -p ").append(port);
            if (!intf.isEmpty()) {
                s.append(" --interface \"").append(intf).append("\"");
            }
            properties.setProperty("IceDiscovery.Multicast.Endpoints", s.toString());
        }
        if ((lookupEndpoints = properties.getProperty("IceDiscovery.Lookup")).isEmpty()) {
            int protocol = ipv4 && !preferIPv6 ? 0 : 1;
            List<String> interfaces = Network.getInterfacesForMulticast(intf, protocol);
            for (String p : interfaces) {
                if (p != interfaces.get(0)) {
                    lookupEndpoints = lookupEndpoints + ":";
                }
                lookupEndpoints = lookupEndpoints + "udp -h \"" + address + "\" -p " + port + " --interface \"" + p + "\"";
            }
        }
        if (properties.getProperty("IceDiscovery.Reply.Endpoints").isEmpty()) {
            properties.setProperty("IceDiscovery.Reply.Endpoints", "udp -h " + (intf.isEmpty() ? "*" : "\"" + intf + "\""));
        }
        if (properties.getProperty("IceDiscovery.Locator.Endpoints").isEmpty()) {
            properties.setProperty("IceDiscovery.Locator.AdapterId", UUID.randomUUID().toString());
        }
        this._multicastAdapter = this._communicator.createObjectAdapter("IceDiscovery.Multicast");
        this._replyAdapter = this._communicator.createObjectAdapter("IceDiscovery.Reply");
        this._locatorAdapter = this._communicator.createObjectAdapter("IceDiscovery.Locator");
        LocatorRegistryI locatorRegistry = new LocatorRegistryI(this._communicator);
        LocatorRegistryPrx locatorRegistryPrx = LocatorRegistryPrx.uncheckedCast(this._locatorAdapter.addWithUUID(locatorRegistry));
        ObjectPrx lookupPrx = this._communicator.stringToProxy("IceDiscovery/Lookup -d:" + lookupEndpoints);
        lookupPrx = lookupPrx.ice_collocationOptimized(false).ice_router(null);
        LookupI lookup = new LookupI(locatorRegistry, LookupPrx.uncheckedCast(lookupPrx), properties);
        this._multicastAdapter.add(lookup, Util.stringToIdentity("IceDiscovery/Lookup"));
        this._replyAdapter.addDefaultServant(new LookupReplyI(lookup), "");
        Identity id = new Identity("dummy", "");
        lookup.setLookupReply(LookupReplyPrx.uncheckedCast(this._replyAdapter.createProxy(id).ice_datagram()));
        ObjectPrx locator = this._locatorAdapter.addWithUUID(new LocatorI(lookup, locatorRegistryPrx));
        this._defaultLocator = this._communicator.getDefaultLocator();
        this._locator = LocatorPrx.uncheckedCast(locator);
        this._communicator.setDefaultLocator(this._locator);
        this._multicastAdapter.activate();
        this._replyAdapter.activate();
        this._locatorAdapter.activate();
    }

    @Override
    public void destroy() {
        if (this._multicastAdapter != null) {
            this._multicastAdapter.destroy();
        }
        if (this._replyAdapter != null) {
            this._replyAdapter.destroy();
        }
        if (this._locatorAdapter != null) {
            this._locatorAdapter.destroy();
        }
        if (this._communicator.getDefaultLocator().equals(this._locator)) {
            this._communicator.setDefaultLocator(this._defaultLocator);
        }
    }
}

