/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.IceInternal.WebSocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

final class HttpParser {
    private Type _type;
    private StringBuffer _method = new StringBuffer();
    private StringBuffer _uri = new StringBuffer();
    private Map<String, String> _headers = new HashMap<String, String>();
    private Map<String, String> _headerNames = new HashMap<String, String>();
    private String _headerName = "";
    private int _versionMajor = 0;
    private int _versionMinor = 0;
    private int _status = 0;
    private String _reason;
    private State _state;

    HttpParser() {
        this._type = Type.Unknown;
        this._state = State.Init;
    }

    int isCompleteMessage(ByteBuffer buf, int begin, int end) {
        byte ch;
        int p;
        for (p = begin; p < end && ((ch = buf.get(p)) == 13 || ch == 10); ++p) {
        }
        boolean seenFirst = false;
        while (p < end) {
            byte ch2;
            if ((ch2 = buf.get(p++)) == 10) {
                if (seenFirst) {
                    return p;
                }
                seenFirst = true;
                continue;
            }
            if (ch2 == 13) continue;
            seenFirst = false;
        }
        return -1;
    }

    boolean parse(ByteBuffer buf, int begin, int end) {
        int p = begin;
        int start = 0;
        int CR = 13;
        int LF = 10;
        if (this._state == State.Complete) {
            this._state = State.Init;
        }
        block36: while (p != end && this._state != State.Complete) {
            char c = (char)buf.get(p);
            switch (this._state) {
                case Init: {
                    this._method.setLength(0);
                    this._uri.setLength(0);
                    this._versionMajor = -1;
                    this._versionMinor = -1;
                    this._status = -1;
                    this._reason = "";
                    this._headers.clear();
                    this._state = State.Type;
                    continue block36;
                }
                case Type: {
                    if (c == '\r' || c == '\n') break;
                    if (c == 'H') {
                        this._state = State.TypeCheck;
                        break;
                    }
                    this._state = State.Request;
                    continue block36;
                }
                case TypeCheck: {
                    if (c == 'T') {
                        this._state = State.Response;
                        break;
                    }
                    if (c == 'E') {
                        this._state = State.Request;
                        this._method.append('H');
                        this._method.append('E');
                        break;
                    }
                    throw new WebSocketException("malformed request or response");
                }
                case Request: {
                    this._type = Type.Request;
                    this._state = State.RequestMethod;
                    continue block36;
                }
                case RequestMethod: {
                    if (c == ' ' || c == '\r' || c == '\n') {
                        this._state = State.RequestMethodSP;
                        continue block36;
                    }
                    this._method.append(c);
                    break;
                }
                case RequestMethodSP: {
                    if (c == ' ') break;
                    if (c == '\r' || c == '\n') {
                        throw new WebSocketException("malformed request");
                    }
                    this._state = State.RequestURI;
                    continue block36;
                }
                case RequestURI: {
                    if (c == ' ' || c == '\r' || c == '\n') {
                        this._state = State.RequestURISP;
                        continue block36;
                    }
                    this._uri.append(c);
                    break;
                }
                case RequestURISP: {
                    if (c == ' ') break;
                    if (c == '\r' || c == '\n') {
                        throw new WebSocketException("malformed request");
                    }
                    this._state = State.Version;
                    continue block36;
                }
                case RequestLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed request");
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case HeaderFieldStart: {
                    if (c == '\r') {
                        this._state = State.HeaderFieldEndLF;
                        break;
                    }
                    if (c == '\n') {
                        this._state = State.Complete;
                        break;
                    }
                    if (c == ' ') {
                        this._state = State.HeaderFieldContStart;
                        break;
                    }
                    this._state = State.HeaderFieldNameStart;
                    continue block36;
                }
                case HeaderFieldContStart: {
                    if (c == ' ') break;
                    this._state = State.HeaderFieldCont;
                    start = p;
                    continue block36;
                }
                case HeaderFieldCont: {
                    if (c != '\r' && c != '\n') break;
                    if (p > start) {
                        if (this._headerName.isEmpty()) {
                            throw new WebSocketException("malformed header");
                        }
                        String s = this._headers.get(this._headerName);
                        assert (s != null);
                        StringBuffer newValue = new StringBuffer(s);
                        newValue.append(' ');
                        for (int i = start; i < p; ++i) {
                            newValue.append((char)buf.get(i));
                        }
                        this._headers.put(this._headerName, newValue.toString());
                        this._state = c == '\r' ? State.HeaderFieldLF : State.HeaderFieldStart;
                        break;
                    }
                    this._state = c == '\r' ? State.HeaderFieldEndLF : State.Complete;
                    break;
                }
                case HeaderFieldNameStart: {
                    assert (c != ' ');
                    start = p;
                    this._headerName = "";
                    this._state = State.HeaderFieldName;
                    continue block36;
                }
                case HeaderFieldName: {
                    if (c == ' ' || c == ':') {
                        this._state = State.HeaderFieldNameEnd;
                        continue block36;
                    }
                    if (c != '\r' && c != '\n') break;
                    throw new WebSocketException("malformed header");
                }
                case HeaderFieldNameEnd: {
                    StringBuffer str;
                    if (this._headerName.isEmpty()) {
                        str = new StringBuffer();
                        for (int i = start; i < p; ++i) {
                            str.append((char)buf.get(i));
                        }
                        this._headerName = str.toString().toLowerCase();
                        if (!this._headers.containsKey(this._headerName)) {
                            this._headers.put(this._headerName, "");
                            this._headerNames.put(this._headerName, str.toString());
                        }
                    }
                    if (c == ' ') break;
                    if (c != ':' || p == start) {
                        throw new WebSocketException("malformed header");
                    }
                    this._state = State.HeaderFieldValueStart;
                    break;
                }
                case HeaderFieldValueStart: {
                    if (c == ' ') break;
                    if (c == '\r') {
                        this._state = State.HeaderFieldLF;
                        break;
                    }
                    if (c == '\n') {
                        this._state = State.HeaderFieldStart;
                        break;
                    }
                    start = p;
                    this._state = State.HeaderFieldValue;
                    continue block36;
                }
                case HeaderFieldValue: {
                    if (c != '\r' && c != '\n') break;
                    this._state = State.HeaderFieldValueEnd;
                    continue block36;
                }
                case HeaderFieldValueEnd: {
                    StringBuffer str;
                    assert (c == '\r' || c == '\n');
                    if (p > start) {
                        str = new StringBuffer();
                        for (int i = start; i < p; ++i) {
                            str.append((char)buf.get(i));
                        }
                        String s = this._headers.get(this._headerName);
                        if (s == null || s.length() == 0) {
                            this._headers.put(this._headerName, str.toString());
                        } else {
                            this._headers.put(this._headerName, s + ", " + str.toString());
                        }
                    }
                    if (c == '\r') {
                        this._state = State.HeaderFieldLF;
                        break;
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case HeaderFieldLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed header");
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case HeaderFieldEndLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed header");
                    }
                    this._state = State.Complete;
                    break;
                }
                case Version: {
                    if (c != 'H') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionH;
                    break;
                }
                case VersionH: {
                    if (c != 'T') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionHT;
                    break;
                }
                case VersionHT: {
                    if (c != 'T') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionHTT;
                    break;
                }
                case VersionHTT: {
                    if (c != 'P') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionHTTP;
                    break;
                }
                case VersionHTTP: {
                    if (c != '/') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionMajor;
                    break;
                }
                case VersionMajor: {
                    if (c == '.') {
                        if (this._versionMajor == -1) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.VersionMinor;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        throw new WebSocketException("malformed version");
                    }
                    if (this._versionMajor == -1) {
                        this._versionMajor = 0;
                    }
                    this._versionMajor *= 10;
                    this._versionMajor += c - 48;
                    break;
                }
                case VersionMinor: {
                    if (c == '\r') {
                        if (this._versionMinor == -1 || this._type != Type.Request) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.RequestLF;
                        break;
                    }
                    if (c == '\n') {
                        if (this._versionMinor == -1 || this._type != Type.Request) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.HeaderFieldStart;
                        break;
                    }
                    if (c == ' ') {
                        if (this._versionMinor == -1 || this._type != Type.Response) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.ResponseVersionSP;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        throw new WebSocketException("malformed version");
                    }
                    if (this._versionMinor == -1) {
                        this._versionMinor = 0;
                    }
                    this._versionMinor *= 10;
                    this._versionMinor += c - 48;
                    break;
                }
                case Response: {
                    this._type = Type.Response;
                    this._state = State.VersionHT;
                    continue block36;
                }
                case ResponseVersionSP: {
                    if (c == ' ') break;
                    this._state = State.ResponseStatus;
                    continue block36;
                }
                case ResponseStatus: {
                    if (c == '\r') {
                        if (this._status == -1) {
                            throw new WebSocketException("malformed response status");
                        }
                        this._state = State.ResponseLF;
                        break;
                    }
                    if (c == '\n') {
                        if (this._status == -1) {
                            throw new WebSocketException("malformed response status");
                        }
                        this._state = State.HeaderFieldStart;
                        break;
                    }
                    if (c == ' ') {
                        if (this._status == -1) {
                            throw new WebSocketException("malformed response status");
                        }
                        this._state = State.ResponseReasonStart;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        throw new WebSocketException("malformed response status");
                    }
                    if (this._status == -1) {
                        this._status = 0;
                    }
                    this._status *= 10;
                    this._status += c - 48;
                    break;
                }
                case ResponseReasonStart: {
                    if (c == ' ') break;
                    this._state = State.ResponseReason;
                    start = p;
                    continue block36;
                }
                case ResponseReason: {
                    StringBuffer str;
                    if (c != '\r' && c != '\n') break;
                    if (p > start) {
                        str = new StringBuffer();
                        for (int i = start; i < p; ++i) {
                            str.append((char)buf.get(i));
                        }
                        this._reason = str.toString();
                    }
                    this._state = c == '\r' ? State.ResponseLF : State.HeaderFieldStart;
                    break;
                }
                case ResponseLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed status line");
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case Complete: {
                    assert (false);
                    break;
                }
            }
            ++p;
        }
        return this._state == State.Complete;
    }

    String uri() {
        assert (this._type == Type.Request);
        return this._uri.toString();
    }

    int versionMajor() {
        return this._versionMajor;
    }

    int versionMinor() {
        return this._versionMinor;
    }

    int status() {
        return this._status;
    }

    String reason() {
        return this._reason;
    }

    String getHeader(String name, boolean toLower) {
        String s = this._headers.get(name.toLowerCase());
        if (s != null) {
            return toLower ? s.trim().toLowerCase() : s.trim();
        }
        return null;
    }

    Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this._headers.entrySet()) {
            headers.put(this._headerNames.get(entry.getKey()), entry.getValue().trim());
        }
        return headers;
    }

    private static enum State {
        Init,
        Type,
        TypeCheck,
        Request,
        RequestMethod,
        RequestMethodSP,
        RequestURI,
        RequestURISP,
        RequestLF,
        HeaderFieldStart,
        HeaderFieldContStart,
        HeaderFieldCont,
        HeaderFieldNameStart,
        HeaderFieldName,
        HeaderFieldNameEnd,
        HeaderFieldValueStart,
        HeaderFieldValue,
        HeaderFieldValueEnd,
        HeaderFieldLF,
        HeaderFieldEndLF,
        Version,
        VersionH,
        VersionHT,
        VersionHTT,
        VersionHTTP,
        VersionMajor,
        VersionMinor,
        Response,
        ResponseVersionSP,
        ResponseStatus,
        ResponseReasonStart,
        ResponseReason,
        ResponseLF,
        Complete;

    }

    private static enum Type {
        Unknown,
        Request,
        Response;

    }
}

