/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.NodeDescriptor;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.Node;
import com.zeroc.IceGridGUI.Application.Nodes;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.SimpleMapField;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class NodeEditor
extends Editor {
    private JTextField _name = new JTextField(20);
    private JTextArea _description = new JTextArea(3, 20);
    private SimpleMapField _variables;
    private JTextField _loadFactor = new JTextField(20);

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Node Properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean applyUpdate(boolean refresh) {
        Root root = this._target.getRoot();
        root.disableSelectionListener();
        try {
            if (this._target.isEphemeral()) {
                Nodes nodes = (Nodes)this._target.getParent();
                this.writeDescriptor();
                NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
                this._target.destroy();
                try {
                    nodes.tryAdd(this._name.getText().trim(), descriptor);
                }
                catch (UpdateFailedException e) {
                    block18: {
                        try {
                            nodes.insertChild(this._target, true);
                        }
                        catch (UpdateFailedException die) {
                            if ($assertionsDisabled) break block18;
                            throw new AssertionError();
                        }
                    }
                    root.setSelectedNode(this._target);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                this._target = nodes.findChildWithDescriptor(descriptor);
                root.updated();
                if (refresh) {
                    root.setSelectedNode(this._target);
                }
            } else if (this.isSimpleUpdate()) {
                this.writeDescriptor();
                root.updated();
                ((Node)this._target).getEditable().markModified();
            } else {
                NodeDescriptor savedDescriptor = ((Node)this._target).saveDescriptor();
                this.writeDescriptor();
                LinkedList<Editable> editables = new LinkedList<Editable>();
                try {
                    ((Node)this._target).rebuild(editables);
                }
                catch (UpdateFailedException e) {
                    ((Node)this._target).restoreDescriptor(savedDescriptor);
                    JOptionPane.showMessageDialog(root.getCoordinator().getMainFrame(), e.toString(), "Apply failed", 0);
                    boolean die = false;
                    root.enableSelectionListener();
                    return die;
                }
                for (Editable p : editables) {
                    p.markModified();
                }
                ((Node)this._target).getEditable().markModified();
                root.updated();
            }
            if (refresh) {
                root.getCoordinator().getCurrentTab().showNode(this._target);
            }
            this._applyButton.setEnabled(false);
            this._discardButton.setEnabled(false);
            boolean bl = true;
            return bl;
        }
        finally {
            root.enableSelectionListener();
        }
    }

    @Override
    Utils.Resolver getDetailResolver() {
        if (this._target.getCoordinator().substitute()) {
            return this._target.getResolver();
        }
        return null;
    }

    NodeEditor() {
        this._name.getDocument().addDocumentListener(this._updateListener);
        this._name.setToolTipText("Must match the IceGrid.Node.Name property of the desired icegridnode process");
        this._description.getDocument().addDocumentListener(this._updateListener);
        this._description.setToolTipText("An optional description for this node");
        this._variables = new SimpleMapField(this, false, "Name", "Value");
        this._loadFactor.getDocument().addDocumentListener(this._updateListener);
        this._loadFactor.setToolTipText("<html>A floating point value.<br>When not specified, IceGrid uses 1.0 divided by the<br><i>number of threads</i> on all platforms except Windows;<br>on Windows, IceGrid uses 1.0.<html>");
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Name");
        builder.append((Component)this._name, 3);
        builder.nextLine();
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Variables");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._variables);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Load Factor");
        builder.append((Component)this._loadFactor, 3);
        builder.nextLine();
    }

    boolean isSimpleUpdate() {
        NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
        return this._variables.get().equals(descriptor.variables);
    }

    void writeDescriptor() {
        NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
        descriptor.description = this._description.getText();
        descriptor.variables = this._variables.get();
        descriptor.loadFactor = this._loadFactor.getText().trim();
    }

    @Override
    protected boolean validate() {
        return this.check(new String[]{"Name", this._name.getText().trim()});
    }

    void show(Node node) {
        this.detectUpdates(false);
        this._target = node;
        Utils.Resolver resolver = this.getDetailResolver();
        boolean isEditable = resolver == null;
        this._name.setText(this._target.getId());
        this._name.setEditable(this._target.isEphemeral());
        NodeDescriptor descriptor = (NodeDescriptor)this._target.getDescriptor();
        this._description.setText(Utils.substitute(descriptor.description, resolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
        this._variables.set(descriptor.variables, resolver, isEditable);
        this._loadFactor.setText(Utils.substitute(descriptor.loadFactor, resolver));
        this._loadFactor.setEditable(isEditable);
        this._applyButton.setEnabled(node.isEphemeral());
        this._discardButton.setEnabled(node.isEphemeral());
        this.detectUpdates(true);
        if (node.isEphemeral()) {
            this.updated();
        }
    }
}

