/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.TableField;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.SortedMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class CommunicatorEditor
extends Editor {
    protected Communicator _target;
    private JTextField _buildId = new JTextField(20);
    private JButton _refreshButton;
    private TableField _runtimeProperties = new TableField("Name", "Value");
    private boolean _runtimePropertiesRetrieved = false;
    private JTextArea _description = new JTextArea(3, 20);
    private TableField _descriptorProperties = new TableField("Name", "Value");

    protected CommunicatorEditor() {
        this._description.setEditable(false);
        this._description.setOpaque(false);
        this._buildId.setEditable(false);
        AbstractAction refresh = new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommunicatorEditor.this._buildId.setText("");
                CommunicatorEditor.this._runtimeProperties.clear();
                CommunicatorEditor.this._target.showRuntimeProperties();
            }
        };
        refresh.putValue("ShortDescription", "Retrieve again the properties");
        this._refreshButton = new JButton(refresh);
    }

    protected void show(CommunicatorDescriptor descriptor, SortedMap<String, String> properties, Utils.Resolver resolver) {
        this._description.setText(resolver.substitute(descriptor.description));
        this._descriptorProperties.setSortedMap(properties);
    }

    protected void clearRuntimeProperties(String buildId) {
        this._buildId.setText(buildId);
        this._runtimeProperties.clear();
        this._runtimePropertiesRetrieved = false;
        this._refreshButton.setEnabled(false);
    }

    protected void showRuntimeProperties(Communicator previous) {
        if (this._target != previous || !this._runtimePropertiesRetrieved) {
            this._buildId.setText("Retrieving...");
            this._runtimeProperties.clear();
            this._target.showRuntimeProperties();
            this._runtimePropertiesRetrieved = true;
        }
        this._refreshButton.setEnabled(true);
    }

    void setRuntimeProperties(SortedMap<String, String> map, Communicator communicator) {
        if (communicator == this._target) {
            this._runtimeProperties.setSortedMap(map);
            this._runtimePropertiesRetrieved = true;
            String buildString = (String)map.get("BuildId");
            if (buildString == null) {
                this._buildId.setText("");
            } else {
                this._buildId.setText(buildString);
            }
        }
    }

    protected void appendDescriptorProperties(DefaultFormBuilder builder) {
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._descriptorProperties);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    protected void appendRuntimeProperties(DefaultFormBuilder builder) {
        builder.append("Build Id");
        builder.append((Component)this._buildId, (Component)this._refreshButton);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._runtimeProperties);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }
}

