/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGridGUI.LiveDeployment.DbEnv;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.TableField;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class DbEnvEditor
extends Editor {
    private JTextArea _description = new JTextArea(3, 20);
    private JTextField _dbHome = new JTextField(20);
    private TableField _properties = new TableField("Name", "Value");

    DbEnvEditor() {
        this._description.setEditable(false);
        this._description.setOpaque(false);
        this._dbHome.setEditable(false);
    }

    void show(DbEnv dbEnv) {
        DbEnvDescriptor descriptor = dbEnv.getDescriptor();
        Utils.Resolver resolver = dbEnv.getResolver();
        this._description.setText(resolver.substitute(descriptor.description));
        if (descriptor.dbHome.length() == 0) {
            this._dbHome.setText("Created by the IceGrid Node");
        } else {
            this._dbHome.setText(resolver.substitute(descriptor.dbHome));
        }
        this._properties.setProperties(descriptor.properties, resolver);
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("DB Home");
        builder.append((Component)this._dbHome, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._properties);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Database Environment Properties");
    }
}

