/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.zeroc.Ice.LogMessageType;
import com.zeroc.IceGridGUI.LiveDeployment.ShowIceLogDialog;
import com.zeroc.IceUtilInternal.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class LogFilterDialog
extends JDialog {
    LogFilterDialog(final ShowIceLogDialog dialog) {
        super(dialog, "Ice log filter - IceGrid GUI", true);
        this.setDefaultCloseOperation(2);
        HashSet<LogMessageType> messageTypeFilterSet = null;
        if (dialog.getMessageTypeFilter() != null) {
            messageTypeFilterSet = new HashSet<LogMessageType>(Arrays.asList(dialog.getMessageTypeFilter()));
        }
        final JCheckBox error = new JCheckBox("Error", messageTypeFilterSet == null || messageTypeFilterSet.contains(LogMessageType.ErrorMessage));
        final JCheckBox warning = new JCheckBox("Warning", messageTypeFilterSet == null || messageTypeFilterSet.contains(LogMessageType.WarningMessage));
        final JCheckBox print = new JCheckBox("Print", messageTypeFilterSet == null || messageTypeFilterSet.contains(LogMessageType.PrintMessage));
        final JCheckBox trace = new JCheckBox("Trace", messageTypeFilterSet == null || messageTypeFilterSet.contains(LogMessageType.TraceMessage));
        final JTextArea traceCategories = new JTextArea(3, 40);
        traceCategories.setLineWrap(true);
        String[] traceCategoryFilter = dialog.getTraceCategoryFilter();
        if (traceCategoryFilter != null) {
            traceCategories.setText(StringUtil.joinString(Arrays.asList(traceCategoryFilter), ", "));
        } else {
            traceCategories.setText(null);
        }
        traceCategories.setToolTipText("Trace categories separated by commas; leave blank to get all categories");
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] traceCategoryFilter = null;
                String txt = traceCategories.getText();
                if (txt != null && !txt.isEmpty()) {
                    traceCategoryFilter = StringUtil.splitString(txt, ", \t\r\n");
                    if (traceCategoryFilter == null) {
                        JOptionPane.showMessageDialog(LogFilterDialog.this, "Unmatched quote in Trace categories field", "Invalid entry", 0);
                        return;
                    }
                    if (traceCategoryFilter.length == 0) {
                        traceCategoryFilter = null;
                    }
                }
                HashSet<LogMessageType> messageTypeFilterSet = new HashSet<LogMessageType>();
                if (error.isSelected()) {
                    messageTypeFilterSet.add(LogMessageType.ErrorMessage);
                }
                if (warning.isSelected()) {
                    messageTypeFilterSet.add(LogMessageType.WarningMessage);
                }
                if (print.isSelected()) {
                    messageTypeFilterSet.add(LogMessageType.PrintMessage);
                }
                if (trace.isSelected()) {
                    messageTypeFilterSet.add(LogMessageType.TraceMessage);
                }
                if (messageTypeFilterSet.size() == 0 || messageTypeFilterSet.size() == 4) {
                    messageTypeFilterSet = null;
                }
                LogMessageType[] messageTypeFilter = null;
                if (messageTypeFilterSet != null) {
                    messageTypeFilter = messageTypeFilterSet.toArray(new LogMessageType[0]);
                }
                LogFilterDialog.this.dispose();
                dialog.setFilters(messageTypeFilter, traceCategoryFilter);
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFilterDialog.this.dispose();
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("left:pref, 3dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border(Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.appendSeparator("Retrieve only the following types of log messages (server-side filtering)");
        builder.nextLine();
        builder.append(error);
        builder.nextLine();
        builder.append(warning);
        builder.nextLine();
        builder.append(print);
        builder.nextLine();
        builder.append(trace);
        builder.nextLine();
        builder.append("Trace categories");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(traceCategories);
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 3));
        builder.nextRow(2);
        builder.nextLine();
        JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(okButton, cancelButton).build();
        buttonBar.setBorder(Borders.DIALOG);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }
}

