/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceInternal.LocatorInfo;
import com.zeroc.IceInternal.LocatorTable;
import com.zeroc.IceInternal.Reference;
import java.util.HashMap;

public final class LocatorManager {
    private final boolean _background;
    private HashMap<LocatorPrx, LocatorInfo> _table = new HashMap();
    private HashMap<LocatorKey, LocatorTable> _locatorTables = new HashMap();
    private LocatorKey _lookupKey = new LocatorKey();

    LocatorManager(Properties properties) {
        this._background = properties.getPropertyAsInt("Ice.BackgroundLocatorCacheUpdates") > 0;
    }

    synchronized void destroy() {
        for (LocatorInfo info : this._table.values()) {
            info.destroy();
        }
        this._table.clear();
        this._locatorTables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatorInfo get(LocatorPrx loc) {
        if (loc == null) {
            return null;
        }
        LocatorPrx locator = LocatorPrx.uncheckedCast(loc.ice_locator(null));
        LocatorManager locatorManager = this;
        synchronized (locatorManager) {
            LocatorInfo info = this._table.get(locator);
            if (info == null) {
                LocatorTable table = this._locatorTables.get(this._lookupKey.set(locator));
                if (table == null) {
                    table = new LocatorTable();
                    this._locatorTables.put(this._lookupKey.clone(), table);
                }
                info = new LocatorInfo(locator, table, this._background);
                this._table.put(locator, info);
            }
            return info;
        }
    }

    private static final class LocatorKey
    implements Cloneable {
        private Identity _id;
        private EncodingVersion _encoding;

        private LocatorKey() {
        }

        public boolean equals(Object o) {
            assert (o instanceof LocatorKey);
            LocatorKey k = (LocatorKey)o;
            if (!k._id.equals(this._id)) {
                return false;
            }
            return k._encoding.equals(this._encoding);
        }

        public int hashCode() {
            int h = 5381;
            h = HashUtil.hashAdd(h, this._id);
            h = HashUtil.hashAdd(h, this._encoding);
            return h;
        }

        public LocatorKey clone() {
            LocatorKey c;
            block2: {
                c = null;
                try {
                    c = (LocatorKey)super.clone();
                }
                catch (CloneNotSupportedException ex) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
            return c;
        }

        LocatorKey set(LocatorPrx locator) {
            Reference r = ((_ObjectPrxI)((Object)locator))._getReference();
            this._id = r.getIdentity();
            this._encoding = r.getEncoding();
            return this;
        }
    }
}

