/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.NativePropertiesAdmin;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.PropertiesAdmin;
import com.zeroc.IceInternal.Instance;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

class PropertiesAdminI
implements NativePropertiesAdmin,
PropertiesAdmin {
    private final Properties _properties;
    private final Logger _logger;
    private List<Consumer<Map<String, String>>> _updateCallbacks = new ArrayList<Consumer<Map<String, String>>>();

    public PropertiesAdminI(Instance instance) {
        this._properties = instance.initializationData().properties;
        this._logger = instance.initializationData().logger;
    }

    @Override
    public synchronized String getProperty(String name, Current current) {
        return this._properties.getProperty(name);
    }

    public synchronized TreeMap<String, String> getPropertiesForPrefix(String name, Current current) {
        return new TreeMap<String, String>(this._properties.getPropertiesForPrefix(name));
    }

    @Override
    public synchronized void setProperties(Map<String, String> props, Current current) {
        Map<String, String> old = this._properties.getPropertiesForPrefix("");
        int traceLevel = this._properties.getPropertyAsInt("Ice.Trace.Admin.Properties");
        HashMap<String, String> added = new HashMap<String, String>();
        HashMap<String, String> changed = new HashMap<String, String>();
        HashMap<String, String> removed = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!old.containsKey(key)) {
                if (value.length() <= 0) continue;
                added.put(key, value);
                continue;
            }
            if (!value.equals(old.get(key))) {
                if (value.length() == 0) {
                    removed.put(key, value);
                } else {
                    changed.put(key, value);
                }
            }
            old.remove(key);
        }
        if (!(traceLevel <= 0 || added.isEmpty() && changed.isEmpty() && removed.isEmpty())) {
            Iterator out = new StringBuilder(128);
            ((StringBuilder)((Object)out)).append("Summary of property changes");
            if (!added.isEmpty()) {
                ((StringBuilder)((Object)out)).append("\nNew properties:");
                for (Map.Entry e : added.entrySet()) {
                    ((StringBuilder)((Object)out)).append("\n  ");
                    ((StringBuilder)((Object)out)).append((String)e.getKey());
                    if (traceLevel <= 1) continue;
                    ((StringBuilder)((Object)out)).append(" = ");
                    ((StringBuilder)((Object)out)).append((String)e.getValue());
                }
            }
            if (!changed.isEmpty()) {
                ((StringBuilder)((Object)out)).append("\nChanged properties:");
                for (Map.Entry e : changed.entrySet()) {
                    ((StringBuilder)((Object)out)).append("\n  ");
                    ((StringBuilder)((Object)out)).append((String)e.getKey());
                    if (traceLevel <= 1) continue;
                    ((StringBuilder)((Object)out)).append(" = ");
                    ((StringBuilder)((Object)out)).append((String)e.getValue());
                    ((StringBuilder)((Object)out)).append(" (old value = ");
                    ((StringBuilder)((Object)out)).append(this._properties.getProperty((String)e.getKey()));
                    ((StringBuilder)((Object)out)).append(")");
                }
            }
            if (!removed.isEmpty()) {
                ((StringBuilder)((Object)out)).append("\nRemoved properties:");
                for (Map.Entry e : removed.entrySet()) {
                    ((StringBuilder)((Object)out)).append("\n  ");
                    ((StringBuilder)((Object)out)).append((String)e.getKey());
                }
            }
            this._logger.trace("Admin.Properties", ((StringBuilder)((Object)out)).toString());
        }
        for (Map.Entry entry : added.entrySet()) {
            this._properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : changed.entrySet()) {
            this._properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : removed.entrySet()) {
            this._properties.setProperty((String)entry.getKey(), "");
        }
        if (!this._updateCallbacks.isEmpty()) {
            HashMap<String, String> changes = new HashMap<String, String>(added);
            changes.putAll(changed);
            changes.putAll(removed);
            for (Consumer<Map<String, String>> callback : new ArrayList<Consumer<Map<String, String>>>(this._updateCallbacks)) {
                try {
                    callback.accept(changes);
                }
                catch (RuntimeException ex) {
                    if (this._properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) <= 1) continue;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    pw.flush();
                    this._logger.warning("properties admin update callback raised unexpected exception:\n" + sw.toString());
                }
            }
        }
    }

    @Override
    public synchronized void addUpdateCallback(Consumer<Map<String, String>> cb) {
        this._updateCallbacks.add(cb);
    }

    @Override
    public synchronized void removeUpdateCallback(Consumer<Map<String, String>> cb) {
        this._updateCallbacks.remove(cb);
    }
}

