/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceStorm;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.SliceChecksumDictHelper;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import com.zeroc.IceStorm.NoSuchTopic;
import com.zeroc.IceStorm.TopicDictHelper;
import com.zeroc.IceStorm.TopicExists;
import com.zeroc.IceStorm.TopicPrx;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface TopicManager
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public TopicPrx create(String var1, Current var2) throws TopicExists;

    public TopicPrx retrieve(String var1, Current var2) throws NoSuchTopic;

    public Map<String, TopicPrx> retrieveAll(Current var1);

    public Map<String, String> getSliceChecksums(Current var1);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return TopicManager.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceStorm::TopicManager";
    }

    public static CompletionStage<OutputStream> _iceD_create(TopicManager obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        TopicPrx ret = obj.create(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_retrieve(TopicManager obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_name = istr.readString();
        inS.endReadParams();
        TopicPrx ret = obj.retrieve(iceP_name, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_retrieveAll(TopicManager obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        Map<String, TopicPrx> ret = obj.retrieveAll(current);
        OutputStream ostr = inS.startWriteParams();
        TopicDictHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getSliceChecksums(TopicManager obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        Map<String, String> ret = obj.getSliceChecksums(current);
        OutputStream ostr = inS.startWriteParams();
        SliceChecksumDictHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return TopicManager._iceD_create(this, in, current);
            }
            case 1: {
                return TopicManager._iceD_getSliceChecksums(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 5: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 6: {
                return TopicManager._iceD_retrieve(this, in, current);
            }
            case 7: {
                return TopicManager._iceD_retrieveAll(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceStorm::TopicManager"};
        _iceOps = new String[]{"create", "getSliceChecksums", "ice_id", "ice_ids", "ice_isA", "ice_ping", "retrieve", "retrieveAll"};
    }
}

