/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ObjectAdapter;
import Ice.ObjectPrxHelperBase;
import IceInternal.CollocatedRequestHandler;
import IceInternal.ConnectRequestHandler;
import IceInternal.Instance;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RoutableReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public final class RequestHandlerFactory {
    private final Instance _instance;
    private final Map<Reference, ConnectRequestHandler> _handlers = new HashMap<Reference, ConnectRequestHandler>();

    RequestHandlerFactory(Instance instance) {
        this._instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandler getRequestHandler(final RoutableReference ref, ObjectPrxHelperBase proxy) {
        ObjectAdapter adapter;
        if (ref.getCollocationOptimized() && (adapter = this._instance.objectAdapterFactory().findObjectAdapter(proxy)) != null) {
            return proxy._setRequestHandler(new CollocatedRequestHandler(ref, adapter));
        }
        ConnectRequestHandler handler = null;
        boolean connect = false;
        if (ref.getCacheConnection()) {
            RequestHandlerFactory requestHandlerFactory = this;
            synchronized (requestHandlerFactory) {
                handler = this._handlers.get(ref);
                if (handler == null) {
                    handler = new ConnectRequestHandler(ref, proxy);
                    this._handlers.put(ref, handler);
                    connect = true;
                }
            }
        } else {
            handler = new ConnectRequestHandler(ref, proxy);
            connect = true;
        }
        if (connect) {
            if (this._instance.queueRequests()) {
                final ConnectRequestHandler h = handler;
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                    @Override
                    public Void call() {
                        ref.getConnection(h);
                        return null;
                    }
                });
            } else {
                ref.getConnection(handler);
            }
        }
        return proxy._setRequestHandler(handler.connect(proxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRequestHandler(Reference ref, RequestHandler handler) {
        if (ref.getCacheConnection()) {
            RequestHandlerFactory requestHandlerFactory = this;
            synchronized (requestHandlerFactory) {
                if (this._handlers.get(ref) == handler) {
                    this._handlers.remove(ref);
                }
            }
        }
    }
}

