/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanOptional;
import Ice.Callback_Router_addProxies;
import Ice.Callback_Router_getClientProxy;
import Ice.Identity;
import Ice.LocalException;
import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.EndpointI;
import IceInternal.Reference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RouterInfo {
    private final RouterPrx _router;
    private EndpointI[] _clientEndpoints;
    private EndpointI[] _serverEndpoints;
    private ObjectAdapter _adapter;
    private Set<Identity> _identities = new HashSet<Identity>();
    private List<Identity> _evictedIdentities = new ArrayList<Identity>();
    private boolean _hasRoutingTable;

    RouterInfo(RouterPrx router) {
        this._router = router;
        assert (this._router != null);
    }

    public synchronized void destroy() {
        this._clientEndpoints = new EndpointI[0];
        this._serverEndpoints = new EndpointI[0];
        this._adapter = null;
        this._identities.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)obj)._router);
        }
        return false;
    }

    public int hashCode() {
        return this._router.hashCode();
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getClientEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._clientEndpoints != null) {
                return this._clientEndpoints;
            }
        }
        BooleanOptional hasRoutingTable = new BooleanOptional();
        ObjectPrx proxy = this._router.getClientProxy(hasRoutingTable);
        return this.setClientEndpoints(proxy, hasRoutingTable.isSet() ? hasRoutingTable.get() : true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClientEndpoints(final GetClientEndpointsCallback callback) {
        EndpointI[] clientEndpoints = null;
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            clientEndpoints = this._clientEndpoints;
        }
        if (clientEndpoints != null) {
            callback.setEndpoints(clientEndpoints);
            return;
        }
        this._router.begin_getClientProxy(new Callback_Router_getClientProxy(){

            @Override
            public void response(ObjectPrx clientProxy, BooleanOptional hasRoutingTable) {
                callback.setEndpoints(RouterInfo.this.setClientEndpoints(clientProxy, hasRoutingTable.isSet() ? hasRoutingTable.get() : true));
            }

            @Override
            public void exception(LocalException ex) {
                callback.setException(ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointI[] getServerEndpoints() {
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (this._serverEndpoints != null) {
                return this._serverEndpoints;
            }
        }
        return this.setServerEndpoints(this._router.getServerProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addProxy(final ObjectPrx proxy, final AddProxyCallback callback) {
        assert (proxy != null);
        RouterInfo routerInfo = this;
        synchronized (routerInfo) {
            if (!this._hasRoutingTable) {
                return true;
            }
            if (this._identities.contains(proxy.ice_getIdentity())) {
                return true;
            }
        }
        this._router.begin_addProxies(new ObjectPrx[]{proxy}, new Callback_Router_addProxies(){

            @Override
            public void response(ObjectPrx[] evictedProxies) {
                RouterInfo.this.addAndEvictProxies(proxy, evictedProxies);
                callback.addedProxy();
            }

            @Override
            public void exception(LocalException ex) {
                callback.setException(ex);
            }
        });
        return false;
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        this._adapter = adapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    public synchronized void clearCache(Reference ref) {
        this._identities.remove(ref.getIdentity());
    }

    private synchronized EndpointI[] setClientEndpoints(ObjectPrx clientProxy, boolean hasRoutingTable) {
        if (this._clientEndpoints == null) {
            this._hasRoutingTable = hasRoutingTable;
            if (clientProxy == null) {
                this._clientEndpoints = ((ObjectPrxHelperBase)((Object)this._router))._getReference().getEndpoints();
            } else {
                clientProxy = clientProxy.ice_router(null);
                if (this._router.ice_getConnection() != null) {
                    clientProxy = clientProxy.ice_timeout(this._router.ice_getConnection().timeout());
                }
                this._clientEndpoints = ((ObjectPrxHelperBase)clientProxy)._getReference().getEndpoints();
            }
        }
        return this._clientEndpoints;
    }

    private synchronized EndpointI[] setServerEndpoints(ObjectPrx serverProxy) {
        if (serverProxy == null) {
            throw new NoEndpointException();
        }
        serverProxy = serverProxy.ice_router(null);
        this._serverEndpoints = ((ObjectPrxHelperBase)serverProxy)._getReference().getEndpoints();
        return this._serverEndpoints;
    }

    private synchronized void addAndEvictProxies(ObjectPrx proxy, ObjectPrx[] evictedProxies) {
        int index = this._evictedIdentities.indexOf(proxy.ice_getIdentity());
        if (index >= 0) {
            this._evictedIdentities.remove(index);
        } else {
            this._identities.add(proxy.ice_getIdentity());
        }
        for (ObjectPrx p : evictedProxies) {
            if (this._identities.remove(p.ice_getIdentity())) continue;
            this._evictedIdentities.add(p.ice_getIdentity());
        }
    }

    static interface AddProxyCallback {
        public void addedProxy();

        public void setException(LocalException var1);
    }

    static interface GetClientEndpointsCallback {
        public void setEndpoints(EndpointI[] var1);

        public void setException(LocalException var1);
    }
}

