/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.AppContext;

public class WindowsButtonUI
extends BasicButtonUI {
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean defaults_initialized = false;
    private static final Object WINDOWS_BUTTON_UI_KEY = new Object();
    private Rectangle viewRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        AppContext appContext = AppContext.getAppContext();
        WindowsButtonUI windowsButtonUI = (WindowsButtonUI)appContext.get(WINDOWS_BUTTON_UI_KEY);
        if (windowsButtonUI == null) {
            windowsButtonUI = new WindowsButtonUI();
            appContext.put(WINDOWS_BUTTON_UI_KEY, windowsButtonUI);
        }
        return windowsButtonUI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        XPStyle xp;
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            String pp = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt(pp + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt(pp + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt(pp + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt(pp + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor(pp + "focus");
            this.defaults_initialized = true;
        }
        if ((xp = XPStyle.getXP()) != null) {
            b.setBorder(xp.getBorder(b, WindowsButtonUI.getXPButtonType(b)));
            LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        WindowsGraphicsUtils.paintText(g, b, textRect, text, this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        int width = b.getWidth();
        int height = b.getHeight();
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGapX, this.dashedRectGapY, width - this.dashedRectGapWidth, height - this.dashedRectGapHeight);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        AbstractButton b = (AbstractButton)c;
        if (d != null && b.isFocusPainted()) {
            if (d.width % 2 == 0) {
                ++d.width;
            }
            if (d.height % 2 == 0) {
                ++d.height;
            }
        }
        return d;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(g, c);
        }
        super.paint(g, c);
    }

    static TMSchema.Part getXPButtonType(AbstractButton b) {
        if (b instanceof JCheckBox) {
            return TMSchema.Part.BP_CHECKBOX;
        }
        if (b instanceof JRadioButton) {
            return TMSchema.Part.BP_RADIOBUTTON;
        }
        boolean toolbar = b.getParent() instanceof JToolBar;
        return toolbar ? TMSchema.Part.TP_BUTTON : TMSchema.Part.BP_PUSHBUTTON;
    }

    static TMSchema.State getXPButtonState(AbstractButton b) {
        TMSchema.Part part = WindowsButtonUI.getXPButtonType(b);
        ButtonModel model = b.getModel();
        TMSchema.State state = TMSchema.State.NORMAL;
        switch (part) {
            case BP_RADIOBUTTON: 
            case BP_CHECKBOX: {
                if (!model.isEnabled()) {
                    state = model.isSelected() ? TMSchema.State.CHECKEDDISABLED : TMSchema.State.UNCHECKEDDISABLED;
                    break;
                }
                if (model.isPressed() && model.isArmed()) {
                    state = model.isSelected() ? TMSchema.State.CHECKEDPRESSED : TMSchema.State.UNCHECKEDPRESSED;
                    break;
                }
                if (model.isRollover()) {
                    state = model.isSelected() ? TMSchema.State.CHECKEDHOT : TMSchema.State.UNCHECKEDHOT;
                    break;
                }
                state = model.isSelected() ? TMSchema.State.CHECKEDNORMAL : TMSchema.State.UNCHECKEDNORMAL;
                break;
            }
            case BP_PUSHBUTTON: 
            case TP_BUTTON: {
                boolean toolbar = b.getParent() instanceof JToolBar;
                if (toolbar) {
                    if (model.isArmed() && model.isPressed()) {
                        state = TMSchema.State.PRESSED;
                        break;
                    }
                    if (!model.isEnabled()) {
                        state = TMSchema.State.DISABLED;
                        break;
                    }
                    if (model.isSelected() && model.isRollover()) {
                        state = TMSchema.State.HOTCHECKED;
                        break;
                    }
                    if (model.isSelected()) {
                        state = TMSchema.State.CHECKED;
                        break;
                    }
                    if (model.isRollover()) {
                        state = TMSchema.State.HOT;
                        break;
                    }
                    if (!b.hasFocus()) break;
                    state = TMSchema.State.HOT;
                    break;
                }
                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    state = TMSchema.State.PRESSED;
                    break;
                }
                if (!model.isEnabled()) {
                    state = TMSchema.State.DISABLED;
                    break;
                }
                if (model.isRollover() || model.isPressed()) {
                    state = TMSchema.State.HOT;
                    break;
                }
                if (b instanceof JButton && ((JButton)b).isDefaultButton()) {
                    state = TMSchema.State.DEFAULTED;
                    break;
                }
                if (!b.hasFocus()) break;
                state = TMSchema.State.HOT;
                break;
            }
            default: {
                state = TMSchema.State.NORMAL;
            }
        }
        return state;
    }

    static void paintXPButtonBackground(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        XPStyle xp = XPStyle.getXP();
        TMSchema.Part part = WindowsButtonUI.getXPButtonType(b);
        if (b.isContentAreaFilled() && xp != null) {
            XPStyle.Skin skin = xp.getSkin(b, part);
            TMSchema.State state = WindowsButtonUI.getXPButtonState(b);
            Dimension d = c.getSize();
            int dx = 0;
            int dy = 0;
            int dw = d.width;
            int dh = d.height;
            Border border = c.getBorder();
            Insets insets = border != null ? WindowsButtonUI.getOpaqueInsets(border, c) : c.getInsets();
            if (insets != null) {
                dx += insets.left;
                dy += insets.top;
                dw -= insets.left + insets.right;
                dh -= insets.top + insets.bottom;
            }
            skin.paintSkin(g, dx, dy, dw, dh, state);
        }
    }

    private static Insets getOpaqueInsets(Border b, Component c) {
        if (b == null) {
            return null;
        }
        if (b.isBorderOpaque()) {
            return b.getBorderInsets(c);
        }
        if (b instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)b;
            Insets iOut = WindowsButtonUI.getOpaqueInsets(cb.getOutsideBorder(), c);
            if (iOut != null && iOut.equals(cb.getOutsideBorder().getBorderInsets(c))) {
                Insets iIn = WindowsButtonUI.getOpaqueInsets(cb.getInsideBorder(), c);
                if (iIn == null) {
                    return iOut;
                }
                return new Insets(iOut.top + iIn.top, iOut.left + iIn.left, iOut.bottom + iIn.bottom, iOut.right + iIn.right);
            }
            return iOut;
        }
        return null;
    }
}

