/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.SyncFailedException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

public final class FileDescriptor {
    private int fd;
    private AtomicInteger useCount;
    public static final FileDescriptor in = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);

    public FileDescriptor() {
        this.fd = -1;
        this.useCount = new AtomicInteger();
    }

    private FileDescriptor(int fd) {
        this.fd = fd;
        this.useCount = new AtomicInteger();
    }

    public boolean valid() {
        return this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    int incrementAndGetUseCount() {
        return this.useCount.incrementAndGet();
    }

    int decrementAndGetUseCount() {
        return this.useCount.decrementAndGet();
    }

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess(new JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor obj, int fd) {
                obj.fd = fd;
            }

            @Override
            public int get(FileDescriptor obj) {
                return obj.fd;
            }

            @Override
            public void setHandle(FileDescriptor obj, long handle) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getHandle(FileDescriptor obj) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

