/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.ParseException;
import java.text.RBTableBuilder;
import java.util.Vector;
import sun.text.IntHashtable;
import sun.text.UCompactIntArray;

final class RBCollationTables {
    static final int EXPANDCHARINDEX = 0x7E000000;
    static final int CONTRACTCHARINDEX = 0x7F000000;
    static final int UNMAPPED = -1;
    static final int PRIMARYORDERMASK = -65536;
    static final int SECONDARYORDERMASK = 65280;
    static final int TERTIARYORDERMASK = 255;
    static final int PRIMARYDIFFERENCEONLY = -65536;
    static final int SECONDARYDIFFERENCEONLY = -256;
    static final int PRIMARYORDERSHIFT = 16;
    static final int SECONDARYORDERSHIFT = 8;
    private String rules = null;
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private UCompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private IntHashtable contractFlags = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBCollationTables(String rules, int decmp) throws ParseException {
        this.rules = rules;
        RBTableBuilder builder = new RBTableBuilder(new BuildAPI());
        builder.build(rules, decmp);
    }

    public String getRules() {
        return this.rules;
    }

    public boolean isFrenchSec() {
        return this.frenchSec;
    }

    public boolean isSEAsianSwapping() {
        return this.seAsianSwapping;
    }

    Vector getContractValues(int ch) {
        int index = this.mapping.elementAt(ch);
        return this.getContractValuesImpl(index - 0x7F000000);
    }

    private Vector getContractValuesImpl(int index) {
        if (index >= 0) {
            return (Vector)this.contractTable.elementAt(index);
        }
        return null;
    }

    boolean usedInContractSeq(int c) {
        return this.contractFlags.get(c) == 1;
    }

    int getMaxExpansion(int order) {
        int result = 1;
        if (this.expandTable != null) {
            for (int i = 0; i < this.expandTable.size(); ++i) {
                int[] valueList = (int[])this.expandTable.elementAt(i);
                int length = valueList.length;
                if (length <= result || valueList[length - 1] != order) continue;
                result = length;
            }
        }
        return result;
    }

    final int[] getExpandValueList(int order) {
        return (int[])this.expandTable.elementAt(order - 0x7E000000);
    }

    int getUnicodeOrder(int ch) {
        return this.mapping.elementAt(ch);
    }

    short getMaxSecOrder() {
        return this.maxSecOrder;
    }

    short getMaxTerOrder() {
        return this.maxTerOrder;
    }

    static void reverse(StringBuffer result, int from, int to) {
        int i = from;
        for (int j = to - 1; i < j; ++i, --j) {
            char swap = result.charAt(i);
            result.setCharAt(i, result.charAt(j));
            result.setCharAt(j, swap);
        }
    }

    static final int getEntry(Vector list, String name, boolean fwd) {
        for (int i = 0; i < list.size(); ++i) {
            EntryPair pair = (EntryPair)list.elementAt(i);
            if (pair.fwd != fwd || !pair.entryName.equals(name)) continue;
            return i;
        }
        return -1;
    }

    final class BuildAPI {
        private BuildAPI() {
        }

        void fillInTables(boolean f2ary, boolean swap, UCompactIntArray map, Vector cTbl, Vector eTbl, IntHashtable cFlgs, short mso, short mto) {
            RBCollationTables.this.frenchSec = f2ary;
            RBCollationTables.this.seAsianSwapping = swap;
            RBCollationTables.this.mapping = map;
            RBCollationTables.this.contractTable = cTbl;
            RBCollationTables.this.expandTable = eTbl;
            RBCollationTables.this.contractFlags = cFlgs;
            RBCollationTables.this.maxSecOrder = mso;
            RBCollationTables.this.maxTerOrder = mto;
        }
    }
}

