/*
 * Decompiled with CFR 0.152.
 */
package sun.invoke.util;

public class BytecodeName {
    static char ESCAPE_C = (char)92;
    static char NULL_ESCAPE_C = (char)61;
    static String NULL_ESCAPE = ESCAPE_C + "" + NULL_ESCAPE_C;
    static final String DANGEROUS_CHARS = "\\/.;:$[]<>";
    static final String REPLACEMENT_CHARS = "-|,?!%{}^_";
    static final int DANGEROUS_CHAR_FIRST_INDEX = 1;
    static char[] DANGEROUS_CHARS_A = "\\/.;:$[]<>".toCharArray();
    static char[] REPLACEMENT_CHARS_A = "-|,?!%{}^_".toCharArray();
    static final Character[] DANGEROUS_CHARS_CA;
    static final long[] SPECIAL_BITMAP;

    private BytecodeName() {
    }

    public static String toBytecodeName(String s) {
        String bn = BytecodeName.mangle(s);
        assert (bn == s || BytecodeName.looksMangled(bn)) : bn;
        assert (s.equals(BytecodeName.toSourceName(bn))) : s;
        return bn;
    }

    public static String toSourceName(String s) {
        BytecodeName.checkSafeBytecodeName(s);
        String sn = s;
        if (BytecodeName.looksMangled(s)) {
            sn = BytecodeName.demangle(s);
            assert (s.equals(BytecodeName.mangle(sn))) : s + " => " + sn + " => " + BytecodeName.mangle(sn);
        }
        return sn;
    }

    public static Object[] parseBytecodeName(String s) {
        int slen = s.length();
        Object[] res = null;
        for (int pass = 0; pass <= 1; ++pass) {
            int fillp = 0;
            int lasti = 0;
            for (int i = 0; i <= slen; ++i) {
                int whichDC = -1;
                if (i < slen && (whichDC = DANGEROUS_CHARS.indexOf(s.charAt(i))) < 1) continue;
                if (lasti < i) {
                    if (pass != 0) {
                        res[fillp] = BytecodeName.toSourceName(s.substring(lasti, i));
                    }
                    ++fillp;
                    lasti = i + 1;
                }
                if (whichDC < 1) continue;
                if (pass != 0) {
                    res[fillp] = DANGEROUS_CHARS_CA[whichDC];
                }
                ++fillp;
                lasti = i + 1;
            }
            if (pass != 0) break;
            res = new Object[fillp];
            if (fillp > 1 || lasti != 0) continue;
            if (fillp == 0) break;
            res[0] = BytecodeName.toSourceName(s);
            break;
        }
        return res;
    }

    public static String unparseBytecodeName(Object[] components) {
        Object[] components0 = components;
        for (int i = 0; i < components.length; ++i) {
            Object c = components[i];
            if (!(c instanceof String)) continue;
            String mc = BytecodeName.toBytecodeName((String)c);
            if (i == 0 && components.length == 1) {
                return mc;
            }
            if (mc == c) continue;
            if (components == components0) {
                components = (Object[])components.clone();
            }
            components[i] = c = mc;
        }
        return BytecodeName.appendAll(components);
    }

    private static String appendAll(Object[] components) {
        if (components.length <= 1) {
            if (components.length == 1) {
                return String.valueOf(components[0]);
            }
            return "";
        }
        int slen = 0;
        for (Object c : components) {
            if (c instanceof String) {
                slen += String.valueOf(c).length();
                continue;
            }
            ++slen;
        }
        StringBuilder sb = new StringBuilder(slen);
        for (Object c : components) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toDisplayName(String s) {
        Object[] components = BytecodeName.parseBytecodeName(s);
        for (int i = 0; i < components.length; ++i) {
            String sn;
            if (!(components[i] instanceof String) || BytecodeName.isJavaIdent(sn = (String)components[i]) && sn.indexOf(36) < 0) continue;
            components[i] = BytecodeName.quoteDisplay(sn);
        }
        return BytecodeName.appendAll(components);
    }

    private static boolean isJavaIdent(String s) {
        int slen = s.length();
        if (slen == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < slen; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String quoteDisplay(String s) {
        return "'" + s.replaceAll("['\\\\]", "\\\\$0") + "'";
    }

    private static void checkSafeBytecodeName(String s) throws IllegalArgumentException {
        if (!BytecodeName.isSafeBytecodeName(s)) {
            throw new IllegalArgumentException(s);
        }
    }

    public static boolean isSafeBytecodeName(String s) {
        if (s.length() == 0) {
            return false;
        }
        for (char xc : DANGEROUS_CHARS_A) {
            if (xc == ESCAPE_C || s.indexOf(xc) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSafeBytecodeChar(char c) {
        return DANGEROUS_CHARS.indexOf(c) < 1;
    }

    private static boolean looksMangled(String s) {
        return s.charAt(0) == ESCAPE_C;
    }

    private static String mangle(String s) {
        if (s.length() == 0) {
            return NULL_ESCAPE;
        }
        StringBuilder sb = null;
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            boolean needEscape = false;
            if (c == ESCAPE_C) {
                if (i + 1 < slen) {
                    char c1 = s.charAt(i + 1);
                    if (i == 0 && c1 == NULL_ESCAPE_C || c1 != BytecodeName.originalOfReplacement(c1)) {
                        needEscape = true;
                    }
                }
            } else {
                needEscape = BytecodeName.isDangerous(c);
            }
            if (!needEscape) {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(s.length() + 10);
                if (s.charAt(0) != ESCAPE_C && i > 0) {
                    sb.append(NULL_ESCAPE);
                }
                sb.append(s.substring(0, i));
            }
            sb.append(ESCAPE_C);
            sb.append(BytecodeName.replacementOf(c));
        }
        if (sb != null) {
            return sb.toString();
        }
        return s;
    }

    private static String demangle(String s) {
        StringBuilder sb = null;
        int stringStart = 0;
        if (s.startsWith(NULL_ESCAPE)) {
            stringStart = 2;
        }
        int slen = s.length();
        for (int i = stringStart; i < slen; ++i) {
            char rc;
            char oc;
            char c = s.charAt(i);
            if (c == ESCAPE_C && i + 1 < slen && (oc = BytecodeName.originalOfReplacement(rc = s.charAt(i + 1))) != rc) {
                if (sb == null) {
                    sb = new StringBuilder(s.length());
                    sb.append(s.substring(stringStart, i));
                }
                ++i;
                c = oc;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb != null) {
            return sb.toString();
        }
        return s.substring(stringStart);
    }

    static boolean isSpecial(char c) {
        if (c >>> 6 < SPECIAL_BITMAP.length) {
            return (SPECIAL_BITMAP[c >>> 6] >> c & 1L) != 0L;
        }
        return false;
    }

    static char replacementOf(char c) {
        if (!BytecodeName.isSpecial(c)) {
            return c;
        }
        int i = DANGEROUS_CHARS.indexOf(c);
        if (i < 0) {
            return c;
        }
        return REPLACEMENT_CHARS.charAt(i);
    }

    static char originalOfReplacement(char c) {
        if (!BytecodeName.isSpecial(c)) {
            return c;
        }
        int i = REPLACEMENT_CHARS.indexOf(c);
        if (i < 0) {
            return c;
        }
        return DANGEROUS_CHARS.charAt(i);
    }

    static boolean isDangerous(char c) {
        if (!BytecodeName.isSpecial(c)) {
            return false;
        }
        return DANGEROUS_CHARS.indexOf(c) >= 1;
    }

    static int indexOfDangerousChar(String s, int from) {
        int slen = s.length();
        for (int i = from; i < slen; ++i) {
            if (!BytecodeName.isDangerous(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static int lastIndexOfDangerousChar(String s, int from) {
        for (int i = Math.min(from, s.length() - 1); i >= 0; --i) {
            if (!BytecodeName.isDangerous(s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    static {
        Character[] dcca = new Character[DANGEROUS_CHARS.length()];
        for (int i = 0; i < dcca.length; ++i) {
            dcca[i] = Character.valueOf(DANGEROUS_CHARS.charAt(i));
        }
        DANGEROUS_CHARS_CA = dcca;
        SPECIAL_BITMAP = new long[2];
        String SPECIAL = "\\/.;:$[]<>-|,?!%{}^_";
        for (char c : SPECIAL.toCharArray()) {
            int n = c >>> 6;
            SPECIAL_BITMAP[n] = SPECIAL_BITMAP[n] | 1L << c;
        }
    }
}

