/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

abstract class NotificationEmitterSupport
implements NotificationEmitter {
    private Object listenerLock = new Object();
    private List<ListenerInfo> listenerList = Collections.emptyList();

    protected NotificationEmitterSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ListenerInfo> newList = new ArrayList<ListenerInfo>(this.listenerList.size() + 1);
            newList.addAll(this.listenerList);
            newList.add(new ListenerInfo(listener, filter, handback));
            this.listenerList = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ListenerInfo> newList = new ArrayList<ListenerInfo>(this.listenerList);
            for (int i = newList.size() - 1; i >= 0; --i) {
                ListenerInfo li = (ListenerInfo)newList.get(i);
                if (li.listener != listener) continue;
                newList.remove(i);
            }
            if (newList.size() == this.listenerList.size()) {
                throw new ListenerNotFoundException("Listener not registered");
            }
            this.listenerList = newList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        boolean found = false;
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<ListenerInfo> newList = new ArrayList<ListenerInfo>(this.listenerList);
            int size = newList.size();
            for (int i = 0; i < size; ++i) {
                ListenerInfo li = (ListenerInfo)newList.get(i);
                if (li.listener != listener) continue;
                found = true;
                if (li.filter != filter || li.handback != handback) continue;
                newList.remove(i);
                this.listenerList = newList;
                return;
            }
        }
        if (found) {
            throw new ListenerNotFoundException("Listener not registered with this filter and handback");
        }
        throw new ListenerNotFoundException("Listener not registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Notification notification) {
        List<ListenerInfo> currentList;
        if (notification == null) {
            return;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            currentList = this.listenerList;
        }
        int size = currentList.size();
        for (int i = 0; i < size; ++i) {
            ListenerInfo li = currentList.get(i);
            if (li.filter != null && !li.filter.isNotificationEnabled(notification)) continue;
            try {
                li.listener.handleNotification(notification, li.handback);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AssertionError((Object)"Error in invoking listener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            return !this.listenerList.isEmpty();
        }
    }

    @Override
    public abstract MBeanNotificationInfo[] getNotificationInfo();

    private class ListenerInfo {
        public NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        public ListenerInfo(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }
    }
}

