/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class GSSHeader {
    private ObjectIdentifier mechOid = null;
    private byte[] mechOidBytes = null;
    private int mechTokenLength = 0;
    public static final int TOKEN_ID = 96;

    public GSSHeader(ObjectIdentifier mechOid, int mechTokenLength) throws IOException {
        this.mechOid = mechOid;
        DerOutputStream temp = new DerOutputStream();
        temp.putOID(mechOid);
        this.mechOidBytes = temp.toByteArray();
        this.mechTokenLength = mechTokenLength;
    }

    public GSSHeader(InputStream is) throws IOException, GSSException {
        int tag = is.read();
        if (tag != 96) {
            throw new GSSException(10, -1, "GSSHeader did not find the right tag");
        }
        int length = this.getLength(is);
        DerValue temp = new DerValue(is);
        this.mechOidBytes = temp.toByteArray();
        this.mechOid = temp.getOID();
        this.mechTokenLength = length - this.mechOidBytes.length;
    }

    public ObjectIdentifier getOid() {
        return this.mechOid;
    }

    public int getMechTokenLength() {
        return this.mechTokenLength;
    }

    public int getLength() {
        int lenField = this.mechOidBytes.length + this.mechTokenLength;
        return 1 + this.getLenFieldSize(lenField) + this.mechOidBytes.length;
    }

    public static int getMaxMechTokenSize(ObjectIdentifier mechOid, int maxTotalSize) {
        int mechOidBytesSize = 0;
        try {
            DerOutputStream temp = new DerOutputStream();
            temp.putOID(mechOid);
            mechOidBytesSize = temp.toByteArray().length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        maxTotalSize -= 1 + mechOidBytesSize;
        return maxTotalSize -= 5;
    }

    private int getLenFieldSize(int len) {
        int retVal = 1;
        retVal = len < 128 ? 1 : (len < 256 ? 2 : (len < 65536 ? 3 : (len < 0x1000000 ? 4 : 5)));
        return retVal;
    }

    public int encode(OutputStream os) throws IOException {
        int retVal = 1 + this.mechOidBytes.length;
        os.write(96);
        int length = this.mechOidBytes.length + this.mechTokenLength;
        os.write(this.mechOidBytes);
        return retVal += this.putLength(length, os);
    }

    private int getLength(InputStream in) throws IOException {
        return this.getLength(in.read(), in);
    }

    private int getLength(int lenByte, InputStream in) throws IOException {
        int value;
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + tmp + ", " + (tmp < 0 ? "incorrect DER encoding." : "too big."));
            }
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
            if (value < 0) {
                throw new IOException("Invalid length bytes");
            }
        }
        return value;
    }

    private int putLength(int len, OutputStream out) throws IOException {
        int retVal = 0;
        if (len < 128) {
            out.write((byte)len);
            retVal = 1;
        } else if (len < 256) {
            out.write(-127);
            out.write((byte)len);
            retVal = 2;
        } else if (len < 65536) {
            out.write(-126);
            out.write((byte)(len >> 8));
            out.write((byte)len);
            retVal = 3;
        } else if (len < 0x1000000) {
            out.write(-125);
            out.write((byte)(len >> 16));
            out.write((byte)(len >> 8));
            out.write((byte)len);
            retVal = 4;
        } else {
            out.write(-124);
            out.write((byte)(len >> 24));
            out.write((byte)(len >> 16));
            out.write((byte)(len >> 8));
            out.write((byte)len);
            retVal = 5;
        }
        return retVal;
    }

    private void debug(String str) {
        System.err.print(str);
    }

    private String getHexBytes(byte[] bytes, int len) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int b1 = bytes[i] >> 4 & 0xF;
            int b2 = bytes[i] & 0xF;
            sb.append(Integer.toHexString(b1));
            sb.append(Integer.toHexString(b2));
            sb.append(' ');
        }
        return sb.toString();
    }
}

