/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.TicketFlags;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KrbCredInfo {
    public EncryptionKey key;
    public PrincipalName pname;
    public TicketFlags flags;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public PrincipalName sname;
    public HostAddresses caddr;

    private KrbCredInfo() {
    }

    public KrbCredInfo(EncryptionKey new_key, PrincipalName new_pname, TicketFlags new_flags, KerberosTime new_authtime, KerberosTime new_starttime, KerberosTime new_endtime, KerberosTime new_renewTill, PrincipalName new_sname, HostAddresses new_caddr) {
        this.key = new_key;
        this.pname = new_pname;
        this.flags = new_flags;
        this.authtime = new_authtime;
        this.starttime = new_starttime;
        this.endtime = new_endtime;
        this.renewTill = new_renewTill;
        this.sname = new_sname;
        this.caddr = new_caddr;
    }

    public KrbCredInfo(DerValue encoding) throws Asn1Exception, IOException, RealmException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.pname = null;
        this.flags = null;
        this.authtime = null;
        this.starttime = null;
        this.endtime = null;
        this.renewTill = null;
        this.sname = null;
        this.caddr = null;
        this.key = EncryptionKey.parse(encoding.getData(), (byte)0, false);
        Realm prealm = null;
        Realm srealm = null;
        if (encoding.getData().available() > 0) {
            prealm = Realm.parse(encoding.getData(), (byte)1, true);
        }
        if (encoding.getData().available() > 0) {
            this.pname = PrincipalName.parse(encoding.getData(), (byte)2, true, prealm);
        }
        if (encoding.getData().available() > 0) {
            this.flags = TicketFlags.parse(encoding.getData(), (byte)3, true);
        }
        if (encoding.getData().available() > 0) {
            this.authtime = KerberosTime.parse(encoding.getData(), (byte)4, true);
        }
        if (encoding.getData().available() > 0) {
            this.starttime = KerberosTime.parse(encoding.getData(), (byte)5, true);
        }
        if (encoding.getData().available() > 0) {
            this.endtime = KerberosTime.parse(encoding.getData(), (byte)6, true);
        }
        if (encoding.getData().available() > 0) {
            this.renewTill = KerberosTime.parse(encoding.getData(), (byte)7, true);
        }
        if (encoding.getData().available() > 0) {
            srealm = Realm.parse(encoding.getData(), (byte)8, true);
        }
        if (encoding.getData().available() > 0) {
            this.sname = PrincipalName.parse(encoding.getData(), (byte)9, true, srealm);
        }
        if (encoding.getData().available() > 0) {
            this.caddr = HostAddresses.parse(encoding.getData(), (byte)10, true);
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> v = new Vector<DerValue>();
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), this.key.asn1Encode()));
        if (this.pname != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), this.pname.getRealm().asn1Encode()));
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.pname.asn1Encode()));
        }
        if (this.flags != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), this.flags.asn1Encode()));
        }
        if (this.authtime != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)4), this.authtime.asn1Encode()));
        }
        if (this.starttime != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)5), this.starttime.asn1Encode()));
        }
        if (this.endtime != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)6), this.endtime.asn1Encode()));
        }
        if (this.renewTill != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)7), this.renewTill.asn1Encode()));
        }
        if (this.sname != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)8), this.sname.getRealm().asn1Encode()));
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)9), this.sname.asn1Encode()));
        }
        if (this.caddr != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)10), this.caddr.asn1Encode()));
        }
        Object[] der = new DerValue[v.size()];
        v.copyInto(der);
        DerOutputStream out = new DerOutputStream();
        out.putSequence((DerValue[])der);
        return out.toByteArray();
    }

    public Object clone() {
        KrbCredInfo kcred = new KrbCredInfo();
        kcred.key = (EncryptionKey)this.key.clone();
        if (this.pname != null) {
            kcred.pname = (PrincipalName)this.pname.clone();
        }
        if (this.flags != null) {
            kcred.flags = (TicketFlags)this.flags.clone();
        }
        if (this.authtime != null) {
            kcred.authtime = (KerberosTime)this.authtime.clone();
        }
        if (this.starttime != null) {
            kcred.starttime = (KerberosTime)this.starttime.clone();
        }
        if (this.endtime != null) {
            kcred.endtime = (KerberosTime)this.endtime.clone();
        }
        if (this.renewTill != null) {
            kcred.renewTill = (KerberosTime)this.renewTill.clone();
        }
        if (this.sname != null) {
            kcred.sname = (PrincipalName)this.sname.clone();
        }
        if (this.caddr != null) {
            kcred.caddr = (HostAddresses)this.caddr.clone();
        }
        return kcred;
    }
}

