/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.X509Factory;
import sun.security.util.Cache;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X509CertImpl;

public class X509CertificatePair {
    private static final byte TAG_FORWARD = 0;
    private static final byte TAG_REVERSE = 1;
    private X509Certificate forward;
    private X509Certificate reverse;
    private byte[] encoded;
    private static final Cache cache = Cache.newSoftMemoryCache(750);

    public X509CertificatePair() {
    }

    public X509CertificatePair(X509Certificate forward, X509Certificate reverse) throws CertificateException {
        if (forward == null && reverse == null) {
            throw new CertificateException("at least one of certificate pair must be non-null");
        }
        this.forward = forward;
        this.reverse = reverse;
        this.checkPair();
    }

    private X509CertificatePair(byte[] encoded) throws CertificateException {
        try {
            this.parse(new DerValue(encoded));
            this.encoded = encoded;
        }
        catch (IOException ex) {
            throw new CertificateException(ex.toString());
        }
        this.checkPair();
    }

    public static synchronized void clearCache() {
        cache.clear();
    }

    public static synchronized X509CertificatePair generateCertificatePair(byte[] encoded) throws CertificateException {
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoded);
        X509CertificatePair pair = (X509CertificatePair)cache.get(key);
        if (pair != null) {
            return pair;
        }
        pair = new X509CertificatePair(encoded);
        key = new Cache.EqualByteArray(pair.encoded);
        cache.put(key, pair);
        return pair;
    }

    public void setForward(X509Certificate cert) throws CertificateException {
        this.checkPair();
        this.forward = cert;
    }

    public void setReverse(X509Certificate cert) throws CertificateException {
        this.checkPair();
        this.reverse = cert;
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            if (this.encoded == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.emit(tmp);
                this.encoded = tmp.toByteArray();
            }
        }
        catch (IOException ex) {
            throw new CertificateEncodingException(ex.toString());
        }
        return this.encoded;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X.509 Certificate Pair: [\n");
        if (this.forward != null) {
            sb.append("  Forward: " + this.forward + "\n");
        }
        if (this.reverse != null) {
            sb.append("  Reverse: " + this.reverse + "\n");
        }
        sb.append("]");
        return sb.toString();
    }

    private void parse(DerValue val) throws IOException, CertificateException {
        if (val.tag != 48) {
            throw new IOException("Sequence tag missing for X509CertificatePair");
        }
        block4: while (val.data != null && val.data.available() != 0) {
            DerValue opt = val.data.getDerValue();
            short tag = (byte)(opt.tag & 0x1F);
            switch (tag) {
                case 0: {
                    if (!opt.isContextSpecific() || !opt.isConstructed()) continue block4;
                    if (this.forward != null) {
                        throw new IOException("Duplicate forward certificate in X509CertificatePair");
                    }
                    opt = opt.data.getDerValue();
                    this.forward = X509Factory.intern(new X509CertImpl(opt.toByteArray()));
                    continue block4;
                }
                case 1: {
                    if (!opt.isContextSpecific() || !opt.isConstructed()) continue block4;
                    if (this.reverse != null) {
                        throw new IOException("Duplicate reverse certificate in X509CertificatePair");
                    }
                    opt = opt.data.getDerValue();
                    this.reverse = X509Factory.intern(new X509CertImpl(opt.toByteArray()));
                    continue block4;
                }
            }
            throw new IOException("Invalid encoding of X509CertificatePair");
        }
        if (this.forward == null && this.reverse == null) {
            throw new CertificateException("at least one of certificate pair must be non-null");
        }
    }

    private void emit(DerOutputStream out) throws IOException, CertificateEncodingException {
        DerOutputStream tmp;
        DerOutputStream tagged = new DerOutputStream();
        if (this.forward != null) {
            tmp = new DerOutputStream();
            tmp.putDerValue(new DerValue(this.forward.getEncoded()));
            tagged.write(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        }
        if (this.reverse != null) {
            tmp = new DerOutputStream();
            tmp.putDerValue(new DerValue(this.reverse.getEncoded()));
            tagged.write(DerValue.createTag((byte)-128, true, (byte)1), tmp);
        }
        out.write((byte)48, tagged);
    }

    private void checkPair() throws CertificateException {
        if (this.forward == null || this.reverse == null) {
            return;
        }
        X500Principal fwSubject = this.forward.getSubjectX500Principal();
        X500Principal fwIssuer = this.forward.getIssuerX500Principal();
        X500Principal rvSubject = this.reverse.getSubjectX500Principal();
        X500Principal rvIssuer = this.reverse.getIssuerX500Principal();
        if (!fwIssuer.equals(rvSubject) || !rvIssuer.equals(fwSubject)) {
            throw new CertificateException("subject and issuer names in forward and reverse certificates do not match");
        }
        try {
            PublicKey pk = this.reverse.getPublicKey();
            if (!(pk instanceof DSAPublicKey) || ((DSAPublicKey)pk).getParams() != null) {
                this.forward.verify(pk);
            }
            if (!((pk = this.forward.getPublicKey()) instanceof DSAPublicKey) || ((DSAPublicKey)pk).getParams() != null) {
                this.reverse.verify(pk);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("invalid signature: " + e.getMessage());
        }
    }
}

