/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.MathBg;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class MathEg
extends EgChar
implements Expandable {
    private boolean isinline = true;

    public MathEg(boolean bl) {
        this('$', bl);
    }

    public MathEg(char c, boolean bl) {
        this((int)c, bl);
    }

    public MathEg(int n, boolean bl) {
        super(n);
        this.isinline = bl;
    }

    @Override
    public Object clone() {
        return new MathEg(this.getCharCode(), this.isInLine());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList(1);
        teXObjectList.add(this);
        teXParser.getSettings().setMode(-1);
        teXParser.endGroup();
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public String format() {
        return this.isInLine() ? String.format("%c", Character.valueOf((char)this.getCharCode())) : String.format("%c%c", Character.valueOf((char)this.getCharCode()), Character.valueOf((char)this.getCharCode()));
    }

    @Override
    public String toString() {
        return String.format("%s[delim=%s]", this.getClass().getName(), this.format());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return teXParser.getMathDelim(this.isInLine());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.getCharCode()));
        if (!this.isinline) {
            teXObjectList.add(teXParser.getListener().getOther(this.getCharCode()));
        }
        return teXObjectList;
    }

    @Override
    public String show(TeXParser teXParser) throws IOException {
        return String.format("math character %c", Character.valueOf((char)this.getCharCode()));
    }

    public boolean isInLine() {
        return this.isinline;
    }

    @Override
    public boolean matches(BgChar bgChar) {
        return bgChar instanceof MathBg && this.isInLine() == ((MathBg)bgChar).isInLine();
    }
}

