/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CatCodeList;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.CountRegister;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Vector;

public class TeXParser
extends TeXObjectList {
    private TeXSettings settings;
    private Hashtable<Integer, CountRegister> countAlloc = new Hashtable();
    private Hashtable<Integer, DimenRegister> dimenAlloc = new Hashtable();
    public static final Integer ALLOC_COUNT = new Integer(10);
    public static final Integer ALLOC_DIMEN = new Integer(11);
    public static final Integer ALLOC_SKIP = new Integer(12);
    public static final Integer ALLOC_MUSKIP = new Integer(13);
    public static final Integer ALLOC_BOX = new Integer(14);
    public static final Integer ALLOC_TOKS = new Integer(15);
    public static final Integer ALLOC_INPUT = new Integer(16);
    public static final Integer ALLOC_OUTPUT = new Integer(17);
    public static final Integer ALLOC_MATHFAM = new Integer(18);
    public static final Integer ALLOC_LANGUAGE = new Integer(19);
    public static final Integer INS_COUNT = new Integer(20);
    public static final Integer ALLOC_NUMBER = new Integer(21);
    public static final Integer MINUS_ONE = new Integer(22);
    protected Hashtable<String, ControlSequence> csTable;
    protected Hashtable<Integer, ActiveChar> activeTable;
    private Writer writer;
    private TeXReader reader;
    private TeXParserListener listener;
    public static final int TYPE_ESC = 0;
    public static final int TYPE_BG = 1;
    public static final int TYPE_EG = 2;
    public static final int TYPE_MATH = 3;
    public static final int TYPE_TAB = 4;
    public static final int TYPE_EOL = 5;
    public static final int TYPE_PARAM = 6;
    public static final int TYPE_SP = 7;
    public static final int TYPE_SB = 8;
    public static final int TYPE_IGNORE = 9;
    public static final int TYPE_SPACE = 10;
    public static final int TYPE_LETTER = 11;
    public static final int TYPE_OTHER = 12;
    public static final int TYPE_ACTIVE = 13;
    public static final int TYPE_COMMENT = 14;
    public static final int TYPE_INVALID = 15;
    private CatCodeList[] catcodes;
    private Vector<String> verbatim;
    private String jobname = null;

    public TeXParser(TeXParserListener teXParserListener) {
        this.listener = teXParserListener;
        this.reader = null;
        this.activeTable = new Hashtable();
        this.csTable = new Hashtable();
        this.settings = new TeXSettings(this);
        this.verbatim = new Vector();
        this.verbatim.add("verb");
        this.initDefCatCodes();
        this.initRegisters();
        teXParserListener.setParser(this);
    }

    private TeXParser() {
    }

    @Override
    public TeXObjectList createList() {
        return new TeXParser(this.listener);
    }

    private void initRegisters() {
        CountRegister countRegister = new CountRegister("count@");
        this.allocCount(255, countRegister);
        DimenRegister dimenRegister = new DimenRegister("dimen@");
        this.allocDimen(0, dimenRegister);
        dimenRegister = new DimenRegister("dimen@i");
        this.allocDimen(1, dimenRegister);
        dimenRegister = new DimenRegister("dimen@ii");
        this.allocDimen(2, dimenRegister);
        for (int i = 0; i < 10; ++i) {
            countRegister = new CountRegister("count" + i);
            this.settings.putRegister(countRegister);
            this.allocCount(ALLOC_COUNT, countRegister);
        }
        countRegister = new CountRegister("count" + ALLOC_COUNT, 22);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_COUNT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_DIMEN, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_DIMEN, countRegister);
        countRegister = new CountRegister("count" + ALLOC_SKIP, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_SKIP, countRegister);
        countRegister = new CountRegister("count" + ALLOC_MUSKIP, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_MUSKIP, countRegister);
        countRegister = new CountRegister("count" + ALLOC_BOX, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_BOX, countRegister);
        countRegister = new CountRegister("count" + ALLOC_TOKS, 9);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_TOKS, countRegister);
        countRegister = new CountRegister("count" + ALLOC_INPUT, -1);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_INPUT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_OUTPUT, -1);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_OUTPUT, countRegister);
        countRegister = new CountRegister("count" + ALLOC_MATHFAM, 3);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_MATHFAM, countRegister);
        countRegister = new CountRegister("count" + ALLOC_LANGUAGE, 0);
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_LANGUAGE, countRegister);
        countRegister = new CountRegister("insc@unt", 255);
        this.settings.putRegister(countRegister);
        this.allocCount(INS_COUNT, countRegister);
        countRegister = new CountRegister("allocationnumber");
        this.settings.putRegister(countRegister);
        this.allocCount(ALLOC_NUMBER, countRegister);
        countRegister = new CountRegister("m@ne", -1);
        this.settings.putRegister(countRegister);
        this.allocCount(MINUS_ONE, countRegister);
    }

    private void initDefCatCodes() {
        int n;
        this.catcodes = new CatCodeList[16];
        for (n = 0; n < this.catcodes.length; ++n) {
            this.catcodes[n] = n == 12 ? null : new CatCodeList();
        }
        this.catcodes[0].add(new Character('\\'));
        this.catcodes[1].add(Character.valueOf('{'));
        this.catcodes[2].add(Character.valueOf('}'));
        this.catcodes[3].add(Character.valueOf('$'));
        this.catcodes[4].add(Character.valueOf('&'));
        this.catcodes[5].add(Character.valueOf('\n'));
        this.catcodes[5].add(Character.valueOf('\r'));
        this.catcodes[6].add(Character.valueOf('#'));
        this.catcodes[7].add(Character.valueOf('^'));
        this.catcodes[8].add(Character.valueOf('_'));
        this.catcodes[10].add(Character.valueOf(' '));
        this.catcodes[10].add(Character.valueOf('\t'));
        for (n = 65; n <= 90; ++n) {
            this.catcodes[11].add(new Character((char)n));
        }
        for (n = 97; n <= 122; ++n) {
            this.catcodes[11].add(new Character((char)n));
        }
        this.catcodes[13].add(Character.valueOf('~'));
        this.catcodes[14].add(Character.valueOf('%'));
    }

    public boolean isActive(int n) {
        ActiveChar activeChar = this.getActiveChar(new Integer(n));
        return activeChar != null;
    }

    public boolean isCatCode(int n, char c) {
        if (n == 13 && this.isActive(c)) {
            return true;
        }
        Character c2 = new Character(c);
        if (this.catcodes[n] != null) {
            return this.catcodes[n].contains(c2);
        }
        for (int i = 0; i < this.catcodes.length; ++i) {
            if (this.catcodes[i] == null || !this.catcodes[i].contains(c2)) continue;
            return false;
        }
        return true;
    }

    public void setCatCode(char c, int n) {
        Character c2 = new Character(c);
        for (int i = 0; !(i >= this.catcodes.length || this.catcodes[i] != null && this.catcodes[i].remove(c2)); ++i) {
        }
        if (this.catcodes[n] != null) {
            this.catcodes[n].add(c2);
        }
    }

    public int getCatCode(char c) {
        Character c2 = new Character(c);
        for (int i = 0; i < this.catcodes.length; ++i) {
            if (this.catcodes[i] == null || !this.catcodes[i].contains(c2)) continue;
            return i;
        }
        return 12;
    }

    public int getLineNumber() {
        return this.reader == null ? -1 : this.reader.getLineNumber() + 1;
    }

    public boolean isLetter(char c) {
        return this.isCatCode(11, c);
    }

    private int read() throws IOException {
        int n = this.reader.read();
        if (n == -1) {
            TeXReader teXReader = this.reader.getParent();
            if (teXReader == null) {
                return -1;
            }
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                this.listener.getTeXApp().error(iOException);
            }
            this.reader = teXReader;
            TeXObjectList teXObjectList = this.reader.getPending();
            if (teXObjectList != null) {
                while (teXObjectList.size() > 0) {
                    this.add((TeXObject)teXObjectList.remove(0));
                }
                this.reader.setPending(null);
            }
            return this.read();
        }
        return n;
    }

    private void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    private void reset() throws IOException {
        this.reader.reset();
    }

    public void scan(String string, TeXObjectList teXObjectList) throws IOException {
        TeXReader teXReader;
        this.reader = teXReader = new TeXReader(this.reader, string);
        while (this.reader == teXReader && this.fetchNext(teXObjectList)) {
        }
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.string();
    }

    public TeXObjectList string() throws IOException {
        String string;
        if (this.size() == 0) {
            int n = this.read();
            while (this.isCatCode(10, (char)n)) {
                n = this.read();
            }
            if (this.isCatCode(5, (char)n)) {
                this.parseEOL(n, this);
                string = this.pop().toString(this);
            } else if (this.isCatCode(0, (char)n)) {
                this.readControlSequence(this, true);
                string = this.pop().toString(this);
            } else {
                string = "" + n;
            }
        } else {
            return this.pop().string(this);
        }
        return this.string(string);
    }

    public TeXObjectList string(String string) {
        TeXObjectList teXObjectList = new TeXObjectList();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            teXObjectList.add(this.isLetter(c) ? this.listener.getLetter(c) : this.listener.getOther(c));
            c = stringCharacterIterator.next();
        }
        return teXObjectList;
    }

    public void addVerbCommand(String string) {
        this.verbatim.add(string);
    }

    public boolean isVerbCommand(String string) {
        return this.verbatim.contains(string);
    }

    private boolean parseEOL(int n, TeXObjectList teXObjectList) throws IOException {
        boolean bl = true;
        if (n == 10) {
            this.mark(1);
            n = this.read();
            if (n == 10) {
                bl = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else if (n == 13) {
                this.mark(1);
                n = this.read();
                if (this.isCatCode(5, (char)n)) {
                    bl = this.skipNextEols(teXObjectList);
                    this.parFound(teXObjectList);
                } else {
                    this.reset();
                    this.eolFound(teXObjectList);
                }
            } else if (this.isCatCode(5, (char)n)) {
                bl = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                try {
                    this.reset();
                }
                catch (IOException iOException) {
                    throw new EOFException();
                }
                this.eolFound(teXObjectList);
            }
        } else if (n == 13) {
            this.mark(1);
            n = this.read();
            if (n == 13) {
                bl = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else if (n == 10) {
                this.mark(1);
                n = this.read();
                if (this.isCatCode(5, (char)n)) {
                    bl = this.skipNextEols(teXObjectList);
                    this.parFound(teXObjectList);
                } else {
                    this.reset();
                    this.eolFound(teXObjectList);
                }
            } else if (this.isCatCode(5, (char)n)) {
                bl = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                this.reset();
                this.eolFound(teXObjectList);
            }
        } else {
            this.mark(1);
            n = this.read();
            if (this.isCatCode(5, (char)n)) {
                bl = this.skipNextEols(teXObjectList);
                this.parFound(teXObjectList);
            } else {
                this.reset();
                this.eolFound(teXObjectList);
            }
        }
        if (!bl) {
            return bl;
        }
        return this.skipNextSpaces(teXObjectList);
    }

    private boolean skipNextEols(TeXObjectList teXObjectList) throws IOException {
        int n = -1;
        this.mark(1);
        SkippedEols skippedEols = null;
        while ((n = this.read()) != -1) {
            if (!this.isCatCode(5, (char)n)) {
                this.reset();
                break;
            }
            if (skippedEols == null) {
                skippedEols = this.listener.createSkippedEols();
            }
            Eol eol = this.listener.getEol();
            eol.setEol("" + (char)n);
            skippedEols.add(eol);
            this.mark(1);
        }
        if (skippedEols != null) {
            teXObjectList.add(skippedEols);
        }
        return n != -1;
    }

    private boolean skipNextSpaces(TeXObjectList teXObjectList) throws IOException {
        int n = -1;
        this.mark(1);
        SkippedSpaces skippedSpaces = null;
        while ((n = this.read()) != -1) {
            if (!this.isCatCode(10, (char)n)) {
                this.reset();
                break;
            }
            if (skippedSpaces == null) {
                skippedSpaces = this.listener.createSkippedSpaces();
            }
            Space space = this.listener.getSpace();
            space.setSpace(n);
            skippedSpaces.add(space);
            this.mark(1);
        }
        if (n == -1) {
            this.reset();
        }
        if (skippedSpaces != null) {
            teXObjectList.add(skippedSpaces);
        }
        return n != -1;
    }

    private void eolFound(TeXObjectList teXObjectList) throws IOException {
        teXObjectList.add(this.listener.getEol());
    }

    private void parFound(TeXObjectList teXObjectList) throws IOException {
        teXObjectList.add(this.listener.getPar());
    }

    public static boolean isPar(TeXObject teXObject) {
        return teXObject != null && teXObject.isPar();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readComment(TeXObjectList teXObjectList) throws IOException {
        Comment comment = this.listener.createComment();
        int n = -1;
        while ((n = this.read()) != -1) {
            if (this.isCatCode(5, (char)n)) {
                if (n == 10) {
                    this.mark(1);
                    n = this.read();
                    if (n == 13) {
                        this.mark(1);
                        n = this.read();
                        if (this.isCatCode(5, (char)n)) {
                            teXObjectList.add(comment);
                            teXObjectList.add(this.listener.getPar());
                            return this.skipNextEols(teXObjectList);
                        }
                        teXObjectList.add(comment);
                        return true;
                    }
                    if (n == 10) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (this.isCatCode(5, (char)n)) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (n == -1) {
                        teXObjectList.add(comment);
                        return false;
                    }
                    teXObjectList.add(comment);
                    this.reset();
                    return this.skipNextSpaces(teXObjectList);
                }
                if (n == 13) {
                    this.mark(1);
                    n = this.read();
                    if (n == 10) {
                        this.mark(1);
                        n = this.read();
                        if (this.isCatCode(5, (char)n)) {
                            teXObjectList.add(comment);
                            teXObjectList.add(this.listener.getPar());
                            return this.skipNextEols(teXObjectList);
                        }
                        teXObjectList.add(comment);
                        return true;
                    }
                    if (n == 13) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (this.isCatCode(5, (char)n)) {
                        teXObjectList.add(comment);
                        teXObjectList.add(this.listener.getPar());
                        return this.skipNextEols(teXObjectList);
                    }
                    if (n == -1) {
                        teXObjectList.add(comment);
                        return false;
                    }
                    teXObjectList.add(comment);
                    this.reset();
                    return this.skipNextSpaces(teXObjectList);
                }
                this.mark(1);
                n = this.read();
                if (this.isCatCode(5, (char)n)) {
                    teXObjectList.add(comment);
                    teXObjectList.add(this.listener.getPar());
                    return this.skipNextEols(teXObjectList);
                }
                if (n == -1) {
                    teXObjectList.add(comment);
                    return false;
                }
                teXObjectList.add(comment);
                this.reset();
                return this.skipNextSpaces(teXObjectList);
            }
            comment.appendCodePoint(n);
        }
        teXObjectList.add(comment);
        if (n == -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readParam(TeXObjectList teXObjectList) throws IOException {
        this.mark(1);
        int n = this.read();
        if (n == -1) {
            throw new TeXSyntaxException(this.getCurrentFile(), this.getLineNumber(), "tex.error.bad_param", "EOF");
        }
        if (this.isCatCode(6, (char)n)) {
            this.mark(1);
            n = this.read();
            if (n > 48 && n <= 57) {
                teXObjectList.add(this.listener.getDoubleParam(this.listener.getParam(n - 48)));
                return true;
            } else {
                if (!this.isCatCode(1, (char)n)) throw new TeXSyntaxException(this.getCurrentFile(), this.getLineNumber(), "tex.error.bad_param", "" + n);
                teXObjectList.add(this.listener.getDoubleParam(this.listener.getParam(-1)));
                this.reset();
            }
            return true;
        } else if (n >= 48 && n <= 57) {
            teXObjectList.add(this.listener.getParam(n - 48));
            return true;
        } else {
            if (!this.isCatCode(1, (char)n)) throw new TeXSyntaxException(this, "tex.error.bad_param", "" + n);
            teXObjectList.add(this.listener.getParam(-1));
            this.reset();
        }
        return true;
    }

    @Override
    public boolean popRemainingGroup(TeXParser teXParser, Group group, boolean bl, BgChar bgChar) throws IOException {
        return this.popRemainingGroup(group, bl, bgChar);
    }

    public boolean popRemainingGroup(Group group, boolean bl, BgChar bgChar) throws IOException {
        while (!this.isEmpty() || this.fetchNext(bl)) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof EgChar) {
                if (!((EgChar)teXObject).matches(bgChar)) {
                    throw new TeXSyntaxException(this, "tex.error.extra_or_forgotten", new String[]{teXObject.toString(this), bgChar.toString(this)});
                }
                return true;
            }
            if (bl && teXObject.isPar()) {
                throw new TeXSyntaxException(this, "tex.error.par_before_eg");
            }
            if (teXObject instanceof BgChar) {
                Group group2 = ((BgChar)teXObject).createGroup(this);
                if (!this.popRemainingGroup(group2, bl, (BgChar)teXObject)) {
                    group.add(group2);
                    return false;
                }
                group.add(group2);
                continue;
            }
            group.add(teXObject);
        }
        return false;
    }

    private boolean readGroup(Group group, boolean bl) throws IOException {
        int n;
        this.mark(1);
        while ((n = this.read()) != -1) {
            TeXObject teXObject;
            if (this.isCatCode(2, (char)n)) {
                return true;
            }
            if (this.isCatCode(1, (char)n)) {
                teXObject = this.listener.createGroup();
                boolean bl2 = this.readGroup((Group)teXObject, bl);
                group.add(teXObject);
                if (bl2) continue;
                return false;
            }
            this.reset();
            this.fetchNext(group, bl);
            teXObject = (TeXObject)group.lastElement();
            if (teXObject instanceof EgChar) {
                group.remove(group.size() - 1);
            }
            if (bl && TeXParser.isPar(teXObject)) {
                throw new TeXSyntaxException(this, "tex.error.par_before_eg");
            }
            this.mark(1);
        }
        if (n == -1) {
            throw new TeXSyntaxException(this, "tex.error.no_eg");
        }
        return n != -1;
    }

    private void readMath(MathGroup mathGroup) throws IOException {
        this.mark(1);
        int n = this.read();
        if (n == -1) {
            throw new TeXSyntaxException(this.getCurrentFile(), this.getLineNumber(), "tex.error.missing_endmath");
        }
        if (this.isCatCode(3, (char)n)) {
            mathGroup.setInLine(false);
            this.readDisplayMath(mathGroup);
        } else {
            this.reset();
            mathGroup.setInLine(true);
            this.readInLineMath(mathGroup);
        }
    }

    private void readInLineMath(MathGroup mathGroup) throws IOException {
        int n;
        this.mark(1);
        while ((n = this.read()) != -1) {
            if (this.isCatCode(3, (char)n)) {
                return;
            }
            this.reset();
            this.fetchNext(mathGroup, true);
            this.mark(1);
        }
        throw new EOFException();
    }

    private void readDisplayMath(MathGroup mathGroup) throws IOException {
        int n;
        this.mark(1);
        while ((n = this.read()) != -1) {
            if (this.isCatCode(3, (char)n)) {
                this.mark(1);
                n = this.read();
                if (n == -1) {
                    throw new TeXSyntaxException(this.getCurrentFile(), this.getLineNumber(), "tex.error.missing_endmath");
                }
                if (!this.isCatCode(3, (char)n)) {
                    this.reset();
                    throw new TeXSyntaxException(this.getCurrentFile(), this.getLineNumber(), "tex.error.dollar2_ended_with_dollar");
                }
                return;
            }
            this.reset();
            this.fetchNext(mathGroup, true);
            this.mark(1);
        }
        throw new EOFException();
    }

    public void readTo(String string, TeXObjectList teXObjectList) throws IOException {
        int n = string.length();
        this.mark(n);
        this.readTo(string, teXObjectList, n, 0);
    }

    private void readTo(String string, TeXObjectList teXObjectList, int n, int n2) throws IOException {
        int n3 = this.read();
        if (n3 == -1) {
            throw new TeXSyntaxException(this.getCurrentFile(), this.getLineNumber(), "tex.error.not_found", string);
        }
        if (n3 == string.charAt(n2)) {
            if (++n2 == n) {
                return;
            }
            this.readTo(string, teXObjectList, n, n2);
        } else {
            this.reset();
            if (!this.fetchNext(teXObjectList)) {
                throw new TeXSyntaxException(this, "tex.error.not_found", string);
            }
            this.mark(n);
            this.readTo(string, teXObjectList, n, 0);
        }
    }

    public TeXObjectList popRemainingVerb(int n) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            String string = teXObject.toString(this);
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c == n) {
                    this.addAll(0, this.listener.createString(string.substring(i)));
                    return teXObjectList;
                }
                teXObjectList.add(this.listener.getOther(c));
            }
        }
        if (this.readVerb(n, teXObjectList) == -1) {
            throw new EOFException();
        }
        return teXObjectList;
    }

    private int readVerb(int n, TeXObjectList teXObjectList) throws IOException {
        int n2;
        while ((n2 = this.read()) != -1) {
            if (n2 == n) {
                return n2;
            }
            teXObjectList.add(this.listener.getOther(n2));
        }
        return -1;
    }

    private boolean readControlSequence(TeXObjectList teXObjectList) throws IOException {
        return this.readControlSequence(teXObjectList, false);
    }

    private boolean readControlSequence(TeXObjectList teXObjectList, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        this.mark(1);
        while ((n = this.read()) != -1) {
            if (!this.isLetter((char)n)) {
                TeXCsRef teXCsRef;
                if (this.isCatCode(5, (char)n)) {
                    teXCsRef = stringBuilder.length() == 0 ? new TeXCsRef(" ") : new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                    this.parseEOL(n, teXObjectList);
                } else if (stringBuilder.length() == 0) {
                    teXCsRef = new TeXCsRef("" + (char)n);
                    teXObjectList.add(teXCsRef);
                } else if (this.isCatCode(10, (char)n)) {
                    teXCsRef = new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                    this.reset();
                    if (!this.skipNextSpaces(teXObjectList)) {
                        return false;
                    }
                } else {
                    this.reset();
                    teXCsRef = new TeXCsRef(stringBuilder.toString());
                    teXObjectList.add(teXCsRef);
                }
                if (bl) {
                    return true;
                }
                if (this.isVerbCommand(teXCsRef.getName())) {
                    n = this.read();
                    if (n == 42) {
                        teXObjectList.add(this.listener.getOther(n));
                        n = this.read();
                    }
                    int n2 = n;
                    TeXObjectList teXObjectList2 = new TeXObjectList();
                    teXObjectList.add(teXObjectList2);
                    teXObjectList2.add(this.listener.getOther(n));
                    n = this.readVerb(n2, teXObjectList2);
                    teXObjectList2.add(this.listener.getOther(n));
                } else if (teXCsRef.getName().equals("string")) {
                    this.mark(1);
                    n = this.read();
                    while (this.isCatCode(10, (char)n)) {
                        this.mark(1);
                        n = this.read();
                    }
                    if (this.isCatCode(0, (char)n)) {
                        this.reset();
                    } else if (this.isCatCode(11, (char)n)) {
                        teXObjectList.add(this.listener.getLetter(n));
                    } else {
                        teXObjectList.add(this.listener.getOther(n));
                    }
                }
                return true;
            }
            this.mark(1);
            stringBuilder.appendCodePoint(n);
        }
        if (n == -1) {
            teXObjectList.add(new TeXCsRef(" "));
            return false;
        }
        return true;
    }

    public boolean fetchNext() throws IOException {
        return this.fetchNext(this, false);
    }

    public boolean fetchNext(boolean bl) throws IOException {
        return this.fetchNext(this, bl);
    }

    public boolean fetchNext(TeXObjectList teXObjectList) throws IOException {
        return this.fetchNext(teXObjectList, false);
    }

    public boolean fetchNext(TeXObjectList teXObjectList, boolean bl) throws IOException {
        if (this.reader == null) {
            return false;
        }
        int n = this.read();
        if (n == -1) {
            return false;
        }
        if (this.isCatCode(5, (char)n)) {
            this.parseEOL(n, teXObjectList);
        } else {
            if (this.isCatCode(0, (char)n)) {
                return this.readControlSequence(teXObjectList);
            }
            if (this.isCatCode(14, (char)n)) {
                return this.readComment(teXObjectList);
            }
            if (this.isCatCode(6, (char)n)) {
                return this.readParam(teXObjectList);
            }
            if (this.isCatCode(13, (char)n)) {
                ActiveChar activeChar = this.listener.getActiveChar(n);
                if (activeChar == null) {
                    throw new TeXSyntaxException(this, "tex.error.undefined_char", String.format("%c", Character.valueOf((char)n)));
                }
                teXObjectList.add(activeChar);
            } else if (this.isCatCode(7, (char)n)) {
                teXObjectList.add(this.listener.createSpChar());
            } else if (this.isCatCode(8, (char)n)) {
                teXObjectList.add(this.listener.createSbChar());
            } else if (this.isCatCode(4, (char)n)) {
                teXObjectList.add(this.listener.getTab());
            } else if (this.isCatCode(3, (char)n)) {
                MathGroup mathGroup = this.listener.createMathGroup();
                teXObjectList.add(mathGroup);
                this.readMath(mathGroup);
            } else if (this.isCatCode(1, (char)n)) {
                teXObjectList.add(this.listener.getBgChar(n));
            } else if (this.isCatCode(2, (char)n)) {
                teXObjectList.add(this.listener.getEgChar(n));
            } else {
                if (this.isCatCode(10, (char)n)) {
                    Space space = this.listener.getSpace();
                    space.setSpace(n);
                    teXObjectList.add(space);
                    return this.skipNextSpaces(teXObjectList);
                }
                if (this.isLetter((char)n)) {
                    teXObjectList.add(this.listener.getLetter(n));
                } else {
                    teXObjectList.add(this.listener.getOther(n));
                }
            }
        }
        try {
            this.mark(1);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void parse(TeXReader teXReader) throws IOException {
        this.parse(teXReader, -1);
    }

    public void parse(TeXReader teXReader, int n) throws IOException {
        block10: {
            TeXObject teXObject;
            if (teXReader != this.reader) {
                teXObject = null;
                if (this.size() > 0) {
                    teXObject = new TeXObjectList(this.size());
                    while (this.size() > 0) {
                        ((TeXObjectList)teXObject).add((TeXObject)this.remove(0));
                    }
                    this.reader.setPending((TeXObjectList)teXObject);
                    teXObject = null;
                }
                teXReader.setParent(this.reader);
                this.reader = teXReader;
            }
            this.settings.setMode(n);
            try {
                while (this.fetchNext() && this.size() != 0) {
                    while (this.size() > 0) {
                        teXObject = this.pop();
                        try {
                            teXObject.process(this);
                        }
                        catch (EOFException eOFException) {
                            return;
                        }
                        catch (TeXSyntaxException teXSyntaxException) {
                            this.listener.getTeXApp().error(teXSyntaxException);
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                if (this.reader != teXReader) break block10;
                this.reader = teXReader.getParent();
            }
        }
    }

    public void parse(File file) throws IOException {
        this.parse(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file, Charset charset) throws IOException {
        if (!this.getListener().getTeXApp().isReadAccessAllowed(file)) {
            this.getListener().getTeXApp().warning(this, this.getListener().getTeXApp().getMessage("message.no.read", file));
            return;
        }
        if (this.jobname == null) {
            this.jobname = file.getName();
            int n = this.jobname.lastIndexOf(".");
            if (n > 0) {
                this.jobname = this.jobname.substring(0, n);
            }
        }
        try {
            this.listener.beginParse(file);
            this.parse(new TeXReader(this.reader, file, charset));
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.listener.endParse(file);
            if (this.reader != null) {
                this.reader.close();
                this.reader = this.reader.getParent();
            }
        }
    }

    public void parse(TeXPath teXPath) throws IOException {
        this.parse(teXPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(TeXPath teXPath, Charset charset) throws IOException {
        if (!this.getListener().getTeXApp().isReadAccessAllowed(teXPath)) {
            this.getListener().getTeXApp().warning(this, this.getListener().getTeXApp().getMessage("message.no.read", teXPath));
            return;
        }
        File file = teXPath.getFile();
        if (this.jobname == null) {
            this.jobname = file.getName();
            int n = this.jobname.lastIndexOf(".");
            if (n > 0) {
                this.jobname = this.jobname.substring(0, n);
            }
        }
        try {
            this.listener.beginParse(file);
            this.parse(new TeXReader(this.reader, file, charset));
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.listener.endParse(file);
            if (this.reader != null) {
                this.reader.close();
                this.reader = this.reader.getParent();
            }
        }
    }

    @Override
    public TeXObject pop() throws IOException {
        if (this.size() == 0) {
            this.fetchNext();
            if (this.size() == 0) {
                throw new EOFException();
            }
        }
        return (TeXObject)this.remove(0);
    }

    public TeXObject popNextArg() throws IOException {
        return this.popNextArg(false);
    }

    public TeXObject popNextArg(boolean bl) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(bl);
        }
        return this.popArg(bl);
    }

    public TeXObject popNextArg(char c, char c2) throws IOException {
        return this.popNextArg(false, c, c2);
    }

    public TeXObject popNextArg(boolean bl, char c, char c2) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(bl);
        }
        return this.popArg(bl, c, c2);
    }

    public Numerical popNumericalArg(char c, char c2) throws IOException {
        return this.popNumericalArg(this, c, c2);
    }

    public TeXObject popArg(boolean bl) throws IOException {
        return super.popArg(this, bl);
    }

    public TeXObject popArg(boolean bl, char c, char c2) throws IOException {
        return super.popArg(this, bl, c, c2);
    }

    @Override
    public TeXObject expandedPopStack(TeXParser teXParser) throws IOException {
        return teXParser.expandedPopStack();
    }

    @Override
    public TeXObject expandedPopStack(TeXParser teXParser, boolean bl) throws IOException {
        return teXParser.expandedPopStack(bl);
    }

    public TeXObject expandedPopStack() throws IOException {
        return this.expandedPopStack(false);
    }

    public TeXObject expandedPopStack(boolean bl) throws IOException {
        TeXObject teXObject = this.popStack(bl);
        if (teXObject instanceof TeXCsRef) {
            teXObject = this.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject instanceof BgChar) {
            Group group = ((BgChar)teXObject).createGroup(this);
            this.popRemainingGroup(group, bl, (BgChar)teXObject);
            return group;
        }
        if (!(teXObject instanceof Expandable)) {
            return teXObject;
        }
        TeXObjectList teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this);
        if (teXObjectList != null) {
            if (teXObjectList.size() == 0) {
                return teXObjectList;
            }
            teXObject = (TeXObject)teXObjectList.remove(0);
            if (teXObject instanceof BgChar) {
                Group group = ((BgChar)teXObject).createGroup(this);
                teXObjectList.popRemainingGroup(this, group, bl, (BgChar)teXObject);
                this.addAll(0, teXObjectList);
                return group;
            }
            this.addAll(0, teXObjectList);
            return teXObject;
        }
        return teXObject;
    }

    @Override
    public TeXObject popStack(TeXParser teXParser) throws IOException {
        return this.popStack();
    }

    @Override
    public TeXObject popStack(TeXParser teXParser, boolean bl) throws IOException {
        return this.popStack(bl);
    }

    public TeXObject popStack() throws IOException {
        return this.popStack(false);
    }

    public TeXObject popStack(boolean bl) throws IOException {
        if (this.size() == 0) {
            this.fetchNext(bl);
        }
        if (this.size() == 0) {
            throw new EOFException();
        }
        TeXObject teXObject = (TeXObject)this.remove(0);
        if (teXObject instanceof Ignoreable) {
            this.listener.skipping((Ignoreable)teXObject);
            return this.popStack(bl);
        }
        if (teXObject instanceof BgChar) {
            Group group = ((BgChar)teXObject).createGroup(this);
            this.popRemainingGroup(group, bl, (BgChar)teXObject);
            return group;
        }
        return teXObject;
    }

    @Override
    public TeXObject popToken() throws IOException {
        if (this.size() == 0) {
            this.fetchNext(false);
        }
        if (this.size() == 0) {
            throw new EOFException();
        }
        TeXObject teXObject = (TeXObject)this.remove(0);
        if (teXObject instanceof Ignoreable) {
            this.listener.skipping((Ignoreable)teXObject);
            return this.popToken();
        }
        return teXObject;
    }

    public TeXObjectList popToGroup(boolean bl) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (true) {
            if (this.size() == 0) {
                this.fetchNext(bl);
            }
            if (this.size() == 0) {
                throw new EOFException();
            }
            TeXObject teXObject = (TeXObject)this.firstElement();
            if (teXObject instanceof Group || teXObject instanceof BgChar) break;
            teXObject = (TeXObject)this.remove(0);
            if (teXObject instanceof Ignoreable) {
                this.listener.skipping((Ignoreable)teXObject);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXNumber popNumber() throws IOException {
        return this.popNumber(this);
    }

    public TeXDimension popDimension() throws IOException {
        return this.popDimension(this);
    }

    public Numerical popNumerical() throws IOException {
        return this.popNumerical(this);
    }

    @Override
    public TeXObject peekStack() throws IOException {
        int n = 0;
        if (this.size() == 0) {
            this.fetchNext();
        }
        TeXObject teXObject = (TeXObject)this.firstElement();
        while (teXObject instanceof Ignoreable) {
            if (this.size() == ++n) {
                this.fetchNext();
            }
            teXObject = (TeXObject)this.get(n);
        }
        return teXObject;
    }

    public TeXObject peekStack(int n) {
        return this.size() <= n ? null : (TeXObject)this.get(n);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public TeXReader getReader() {
        return this.reader;
    }

    public File getCurrentParentFile() {
        if (this.reader == null) {
            return null;
        }
        Object object = this.reader.getSource();
        if (object != null && object instanceof File) {
            return ((File)object).getParentFile();
        }
        return null;
    }

    public void setReader(TeXReader teXReader) {
        this.reader = teXReader;
    }

    public TeXParserListener getListener() {
        return this.listener;
    }

    public File getCurrentFile() {
        if (this.reader == null) {
            return null;
        }
        Object object = this.reader.getSource();
        return object instanceof File ? (File)object : null;
    }

    public boolean isMathMode() {
        return this.settings.getMode() != 0;
    }

    public void putControlSequence(ControlSequence controlSequence) {
        this.csTable.put(controlSequence.getName(), controlSequence);
        if (controlSequence instanceof Declaration && this.isLetter(controlSequence.getName().charAt(0))) {
            EndDeclaration endDeclaration = new EndDeclaration(controlSequence.getName());
            this.csTable.put(endDeclaration.getName(), endDeclaration);
        }
    }

    public void putControlSequence(boolean bl, ControlSequence controlSequence) {
        if (bl) {
            this.settings.putControlSequence(controlSequence);
            if (controlSequence instanceof Declaration) {
                EndDeclaration endDeclaration = new EndDeclaration(controlSequence.getName());
                this.settings.putControlSequence(endDeclaration);
            }
        } else {
            this.putControlSequence(controlSequence);
        }
    }

    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.settings.getControlSequence(string);
        if (controlSequence != null) {
            return controlSequence;
        }
        controlSequence = this.csTable.get(string);
        return controlSequence;
    }

    public ActiveChar removeActiveChar(int n) {
        return this.activeTable.remove(new Integer(n));
    }

    public ActiveChar removeActiveChar(boolean bl, int n) {
        if (bl) {
            return this.settings.removeActiveChar(n);
        }
        return this.removeActiveChar(n);
    }

    public void putActiveChar(ActiveChar activeChar) {
        this.activeTable.put(new Integer(activeChar.getCharCode()), activeChar);
    }

    public void putActiveChar(boolean bl, ActiveChar activeChar) {
        if (bl) {
            this.settings.putActiveChar(activeChar);
        } else {
            this.putActiveChar(activeChar);
        }
    }

    public ActiveChar getActiveChar(int n) {
        Integer n2 = new Integer(n);
        ActiveChar activeChar = this.settings.getActiveChar(n2);
        if (activeChar != null) {
            return activeChar;
        }
        return this.activeTable.get(n2);
    }

    public void startGroup() {
        this.settings = new TeXSettings(this.settings, this);
    }

    public void endGroup() {
        this.settings = this.settings.getParent();
    }

    public TeXSettings getSettings() {
        return this.settings;
    }

    public char getSpecialChar(int n, char c) {
        if (this.catcodes[n].size() == 0) {
            return c;
        }
        return ((Character)this.catcodes[n].firstElement()).charValue();
    }

    public char getEscChar() {
        return this.getSpecialChar(0, '\\');
    }

    public char getMathChar() {
        return this.getSpecialChar(3, '$');
    }

    public String getMathDelim(boolean bl) {
        char c = this.getSpecialChar(3, '$');
        return bl ? "" + c : "" + c + c;
    }

    public char getCommentChar() {
        return this.getSpecialChar(14, '%');
    }

    public char getBgChar() {
        return this.getSpecialChar(1, '{');
    }

    public char getEgChar() {
        return this.getSpecialChar(2, '}');
    }

    public char getParamChar() {
        return this.getSpecialChar(6, '#');
    }

    public char getSpChar() {
        return this.getSpecialChar(7, '^');
    }

    public char getSbChar() {
        return this.getSpecialChar(8, '_');
    }

    public char getTabChar() {
        return this.getSpecialChar(4, '\t');
    }

    public String getJobname() {
        return this.jobname;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString(teXParser));
        }
        return stringBuilder.toString();
    }

    public void allocCount(int n, CountRegister countRegister) {
        this.allocCount(new Integer(n), countRegister);
    }

    public void allocCount(Integer n, CountRegister countRegister) {
        this.countAlloc.put(n, countRegister);
        countRegister.setAllocation(n);
    }

    public void allocCount(CountRegister countRegister) {
        CountRegister countRegister2 = this.countAlloc.get(ALLOC_COUNT);
        int n = countRegister2.getValue() + 1;
        while (this.countAlloc.containsKey(new Integer(n))) {
            ++n;
        }
        this.allocCount(n, countRegister);
        countRegister2.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }

    public void allocDimen(int n, DimenRegister dimenRegister) {
        this.allocDimen(new Integer(n), dimenRegister);
    }

    public void allocDimen(Integer n, DimenRegister dimenRegister) {
        this.dimenAlloc.put(n, dimenRegister);
        dimenRegister.setAllocation(n);
    }

    public void allocDimen(DimenRegister dimenRegister) {
        CountRegister countRegister = this.countAlloc.get(ALLOC_DIMEN);
        int n = countRegister.getValue() + 1;
        while (this.countAlloc.containsKey(new Integer(n))) {
            ++n;
        }
        this.allocDimen(n, dimenRegister);
        countRegister.setValue(n);
        this.countAlloc.get(ALLOC_NUMBER).setValue(n);
    }
}

