/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class HtmlTag
implements TeXObject {
    private String tag;

    public HtmlTag(String string) {
        this.tag = string;
    }

    @Override
    public Object clone() {
        return new HtmlTag(this.getTag());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) {
        return teXParser.getListener().createString(this.getTag());
    }

    public String toString() {
        return String.format("%s[tag=%s]", this.getClass().getName(), this.getTag());
    }

    @Override
    public String format() {
        return this.getTag();
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.getTag();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write(this.tag);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public boolean isPar() {
        return false;
    }

    public static String getUriFragment(String string) {
        try {
            URI uRI = new URI(null, null, string);
            return uRI.getRawFragment();
        }
        catch (URISyntaxException uRISyntaxException) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == ':' || c == '-' || c == '_') && c != '+') continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }
    }
}

