/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class ExportSnapshotAction
extends AbstractAction {
    private static final String NPSS_EXT = ".npss";
    private static String LAST_DIRECTORY;
    private final FileObject snapshotFileObject;

    ExportSnapshotAction(FileObject fileObject) {
        this.snapshotFileObject = fileObject;
        this.putValue("Name", Bundle.ExportSnapshotAction_ActionName());
        this.putValue("ShortDescription", Bundle.ExportSnapshotAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"GeneralIcons.Export"));
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
    }

    @Override
    public void actionPerformed(final ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser = ExportSnapshotAction.createFileChooser();
                String string = ExportSnapshotAction.this.snapshotFileObject.getName();
                File file = LAST_DIRECTORY != null ? new File(LAST_DIRECTORY) : jFileChooser.getCurrentDirectory();
                jFileChooser.setSelectedFile(new File(file, string));
                Object object = WindowManager.getDefault().getRegistry().getActivated();
                if (object == null) {
                    object = WindowManager.getDefault().getMainWindow();
                }
                if (jFileChooser.showDialog((Component)object, null) != 0) {
                    return;
                }
                File file2 = jFileChooser.getSelectedFile();
                if (file2.isDirectory()) {
                    LAST_DIRECTORY = file2.getAbsolutePath();
                    file2 = new File(file2, string);
                } else {
                    LAST_DIRECTORY = file2.getParent();
                }
                if (!ExportSnapshotAction.checkItselfOrOverwrite(ExportSnapshotAction.this.snapshotFileObject, file2)) {
                    ExportSnapshotAction.this.actionPerformed(actionEvent);
                } else {
                    ExportSnapshotAction.export(ExportSnapshotAction.this.snapshotFileObject, file2);
                }
            }
        });
    }

    private static void export(final FileObject fileObject, final File file) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Bundle.ExportSnapshotAction_ProgressMsg());
        progressHandle.setInitialDelay(500);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                progressHandle.start();
                try {
                    if (file.exists() && !file.delete()) {
                        ProfilerDialogs.displayError((String)Bundle.ExportSnapshotAction_CannotReplaceMsg(file.getName()));
                    } else {
                        FileObject fileObject2 = FileUtil.toFileObject((File)file.getParentFile());
                        String string = file.getName();
                        int n = string.indexOf(46);
                        if (n > -1) {
                            string = string.substring(0, n);
                        }
                        FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string);
                    }
                }
                catch (IOException iOException) {
                    ProfilerDialogs.displayError((String)Bundle.ExportSnapshotAction_ExportFailedMsg());
                    ProfilerLogger.log((String)("Failed to export NPSS snapshot: " + iOException.getMessage()));
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    private static JFileChooser createFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(Bundle.ExportSnapshotAction_FileChooserCaption());
        jFileChooser.setDialogType(1);
        jFileChooser.setApproveButtonText(Bundle.ExportSnapshotAction_ExportButtonText());
        jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(ExportSnapshotAction.NPSS_EXT);
            }

            @Override
            public String getDescription() {
                return Bundle.ExportSnapshotAction_NpssFileFilter(ExportSnapshotAction.NPSS_EXT);
            }
        });
        return jFileChooser;
    }

    private static boolean checkItselfOrOverwrite(FileObject fileObject, File file) {
        if (!file.exists()) {
            return true;
        }
        File file2 = FileUtil.toFile((FileObject)fileObject);
        if (file2 == null) {
            return true;
        }
        if (file2.equals(file)) {
            ProfilerDialogs.displayError((String)Bundle.ExportSnapshotAction_ExportToItselfMsg());
            return false;
        }
        return ProfilerDialogs.displayConfirmation((String)Bundle.ExportSnapshotAction_OverwriteFileMsg(file.getName()), (String)Bundle.ExportSnapshotAction_OverwriteFileCaption());
    }
}

