/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api.java;

import java.util.Set;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.profiler.api.ProfilerSource;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.spi.java.AbstractJavaProfilerSource;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class JavaProfilerSource
extends ProfilerSource {
    private final AbstractJavaProfilerSource impl;

    public static JavaProfilerSource createFrom(FileObject fileObject) {
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        Lookup lookup = MimeLookup.getLookup((String)fileObject.getMIMEType());
        AbstractJavaProfilerSource abstractJavaProfilerSource = (AbstractJavaProfilerSource)lookup.lookup(AbstractJavaProfilerSource.class);
        if (abstractJavaProfilerSource == null && fileObject.isData() && fileObject.hasExt("java")) {
            abstractJavaProfilerSource = (AbstractJavaProfilerSource)Lookup.getDefault().lookup(AbstractJavaProfilerSource.class);
        }
        if (abstractJavaProfilerSource == null) {
            return null;
        }
        return new JavaProfilerSource(fileObject, abstractJavaProfilerSource);
    }

    private JavaProfilerSource(FileObject fileObject, AbstractJavaProfilerSource abstractJavaProfilerSource) {
        super(fileObject);
        this.impl = abstractJavaProfilerSource;
    }

    public boolean isTest() {
        return this.impl.isTest(this.getFile());
    }

    public boolean isApplet() {
        return this.impl.isApplet(this.getFile());
    }

    public SourceClassInfo getTopLevelClass() {
        return this.impl.getTopLevelClass(this.getFile());
    }

    public Set<SourceClassInfo> getClasses() {
        return this.impl.getClasses(this.getFile());
    }

    public Set<SourceClassInfo> getMainClasses() {
        return this.impl.getMainClasses(this.getFile());
    }

    public Set<SourceMethodInfo> getConstructors() {
        return this.impl.getConstructors(this.getFile());
    }

    public SourceClassInfo getEnclosingClass(int n) {
        return this.impl.getEnclosingClass(this.getFile(), n);
    }

    public SourceMethodInfo getEnclosingMethod(int n) {
        return this.impl.getEnclosingMethod(this.getFile(), n);
    }

    public boolean isInstanceOf(String[] stringArray, boolean bl) {
        return this.impl.isInstanceOf(this.getFile(), stringArray, bl);
    }

    public boolean isInstanceOf(String string) {
        return this.impl.isInstanceOf(this.getFile(), string);
    }

    public boolean hasAnnotation(String[] stringArray, boolean bl) {
        return this.impl.hasAnnotation(this.getFile(), stringArray, bl);
    }

    public boolean hasAnnotation(String string) {
        return this.impl.hasAnnotation(this.getFile(), string);
    }

    public boolean isOffsetValid(int n) {
        return this.impl.isOffsetValid(this.getFile(), n);
    }

    public SourceMethodInfo resolveMethodAtPosition(int n) {
        return this.impl.resolveMethodAtPosition(this.getFile(), n);
    }

    public SourceClassInfo resolveClassAtPosition(int n, boolean bl) {
        return this.impl.resolveClassAtPosition(this.getFile(), n, bl);
    }

    @Override
    public boolean isRunnable() {
        return this.isApplet() || this.isTest() || !this.getMainClasses().isEmpty();
    }
}

