/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.common.filters.FilterSet;

public final class DefinedFilterSets {
    private final List definedFilterSets = new ArrayList();

    public DefinedFilterSets() {
    }

    public DefinedFilterSets(DefinedFilterSets definedFilterSets) {
        this();
        this.setValuesFrom(definedFilterSets);
    }

    public FilterSet getFilterSet(String string) {
        int n = this.getFilterSetIndex(string);
        if (n == -1) {
            return null;
        }
        return this.getFilterSetAt(n);
    }

    public FilterSet getFilterSetAt(int n) {
        return (FilterSet)this.definedFilterSets.get(n);
    }

    public int getFilterSetIndex(String string) {
        for (int i = 0; i < this.definedFilterSets.size(); ++i) {
            if (!this.getFilterSetAt(i).getFilterSetName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getFilterSetsCount() {
        return this.definedFilterSets.size();
    }

    public void setValuesFrom(DefinedFilterSets definedFilterSets) {
        this.definedFilterSets.clear();
        for (int i = 0; i < definedFilterSets.getFilterSetsCount(); ++i) {
            this.definedFilterSets.add(new FilterSet(definedFilterSets.getFilterSetAt(i)));
        }
    }

    public void addFilterSet(FilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        this.definedFilterSets.add(filterSet);
    }

    public void clear() {
        this.definedFilterSets.clear();
    }

    public String debug() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DefinedFilterSets:");
        stringBuffer.append("\n");
        for (int i = 0; i < this.definedFilterSets.size(); ++i) {
            stringBuffer.append(((FilterSet)this.definedFilterSets.get(i)).debug());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public DefinedFilterSets load(Map map) {
        this.clear();
        int n = 0;
        while (map.get("FilterSet-" + n + "-name") != null) {
            this.addFilterSet(new FilterSet().load(map, n));
            ++n;
        }
        return this;
    }

    public void moveFilterSetDown(int n) {
        if (n > this.definedFilterSets.size() - 2) {
            return;
        }
        FilterSet filterSet = (FilterSet)this.definedFilterSets.remove(n);
        this.definedFilterSets.add(n + 1, filterSet);
    }

    public void moveFilterSetUp(int n) {
        if (n < 1) {
            return;
        }
        FilterSet filterSet = (FilterSet)this.definedFilterSets.remove(n);
        this.definedFilterSets.add(n - 1, filterSet);
    }

    public void removeFilterSet(FilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        this.definedFilterSets.remove(filterSet);
    }

    public void removeFilterSet(int n) {
        this.definedFilterSets.remove(n);
    }

    public void store(Map map) {
        for (int i = 0; i < this.definedFilterSets.size(); ++i) {
            ((FilterSet)this.definedFilterSets.get(i)).store(map, i);
        }
    }
}

