/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.type;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.application.type.ApplicationType;
import com.sun.tools.visualvm.application.type.JavaPluginApplicationType;
import com.sun.tools.visualvm.core.model.AbstractModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPluginApplicationTypeFactory
extends AbstractModelProvider<ApplicationType, Application> {
    private static final String JAVA_PLUGIN = "-Djavaplugin.version=";
    private static final String JAVA_PLUGIN2_MAIN = "sun.plugin2.main.client.PluginMain";

    public ApplicationType createModelFor(Application application) {
        Jvm jvm = JvmFactory.getJVMFor(application);
        if (jvm.isBasicInfoSupported()) {
            String args = jvm.getJvmArgs();
            int plugin_index = args.indexOf(JAVA_PLUGIN);
            if (plugin_index != -1) {
                int version_index = plugin_index + JAVA_PLUGIN.length();
                int space_index = args.indexOf(32, version_index);
                String version = space_index != -1 ? args.substring(version_index, space_index) : args.substring(version_index);
                return new JavaPluginApplicationType(version);
            }
            if (JAVA_PLUGIN2_MAIN.equals(jvm.getMainClass())) {
                return new JavaPluginApplicationType("2");
            }
        }
        return null;
    }
}

