/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.core.startup.logging.NbLogging;
import org.openide.util.NbBundle;
import org.xml.sax.SAXParseException;

public final class NbFormatter
extends Formatter {
    private static String lineSeparator = System.getProperty("line.separator");
    public static final Formatter FORMATTER = new NbFormatter();
    private static final Map<Throwable, Integer> catchIndex = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        this.print(stringBuilder, logRecord, new HashSet<Throwable>());
        String string = stringBuilder.toString();
        if (NbLogging.DEBUG != null) {
            NbLogging.DEBUG.print("received: " + string);
        }
        if (NbLogging.unwantedMessages != null && NbLogging.unwantedMessages.matcher(string).find()) {
            new Exception().printStackTrace(NbLogging.DEBUG);
        }
        return string;
    }

    private void print(StringBuilder stringBuilder, LogRecord logRecord, Set<Throwable> set) {
        String string = this.formatMessage(logRecord);
        if (string != null && string.indexOf(10) != -1 && logRecord.getThrown() == null) {
            stringBuilder.append(string);
            if (string.charAt(string.length() - 1) != '\n') {
                stringBuilder.append(lineSeparator);
            }
            return;
        }
        if ("stderr".equals(logRecord.getLoggerName()) && logRecord.getLevel() == Level.INFO) {
            stringBuilder.append(string);
            return;
        }
        stringBuilder.append(logRecord.getLevel().getName());
        NbFormatter.addLoggerName(stringBuilder, logRecord);
        if (string != null) {
            stringBuilder.append(": ");
            stringBuilder.append(string);
        }
        stringBuilder.append(lineSeparator);
        if (logRecord.getThrown() != null && logRecord.getLevel().intValue() != 1973) {
            LogRecord[] logRecordArray;
            try {
                logRecordArray = new StringWriter();
                LogRecord[] logRecordArray2 = new PrintWriter((Writer)logRecordArray);
                NbFormatter.printStackTrace(logRecord.getThrown(), (PrintWriter)logRecordArray2);
                logRecordArray2.close();
                stringBuilder.append(logRecordArray.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logRecordArray = NbFormatter.extractDelegates(stringBuilder, logRecord.getThrown(), set);
            if (logRecordArray != null) {
                for (LogRecord logRecord2 : logRecordArray) {
                    this.print(stringBuilder, logRecord2, set);
                }
            }
            this.specialProcessing(stringBuilder, logRecord.getThrown(), set);
        }
    }

    private static void addLoggerName(StringBuilder stringBuilder, LogRecord logRecord) {
        String string = logRecord.getLoggerName();
        if (!"".equals(string)) {
            stringBuilder.append(" [");
            stringBuilder.append(string);
            stringBuilder.append(']');
        }
    }

    private static LogRecord[] extractDelegates(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
        if (!set.add(throwable)) {
            stringBuilder.append("warning: cyclic dependency between annotated throwables");
            return null;
        }
        if (throwable instanceof Callable) {
            Object var3_3 = null;
            try {
                var3_3 = ((Callable)((Object)throwable)).call();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (var3_3 instanceof LogRecord[]) {
                return var3_3;
            }
        }
        if (throwable == null) {
            return null;
        }
        return NbFormatter.extractDelegates(stringBuilder, throwable.getCause(), set);
    }

    private void specialProcessing(StringBuilder stringBuilder, Throwable throwable, Set<Throwable> set) {
        Object object;
        String string;
        Exception exception;
        if (throwable instanceof MissingResourceException) {
            exception = (MissingResourceException)throwable;
            string = ((MissingResourceException)exception).getClassName();
            if (string != null) {
                object = new LogRecord(Level.CONFIG, null);
                ((LogRecord)object).setResourceBundle(NbBundle.getBundle(TopLogging.class));
                ((LogRecord)object).setMessage("EXC_MissingResourceException_class_name");
                ((LogRecord)object).setParameters(new Object[]{string});
                this.print(stringBuilder, (LogRecord)object, set);
            }
            if ((object = ((MissingResourceException)exception).getKey()) != null) {
                LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                logRecord.setMessage("EXC_MissingResourceException_key");
                logRecord.setParameters(new Object[]{object});
                this.print(stringBuilder, logRecord, set);
            }
        }
        if (throwable instanceof SAXParseException) {
            exception = (SAXParseException)throwable;
            string = ((SAXParseException)exception).getPublicId();
            object = ((SAXParseException)exception).getSystemId();
            if (string != null || object != null) {
                Object[] objectArray;
                String string2;
                int n = ((SAXParseException)exception).getColumnNumber();
                int n2 = ((SAXParseException)exception).getLineNumber();
                if (n != -1 || n2 != -1) {
                    string2 = "EXC_sax_parse_col_line";
                    objectArray = new Object[]{String.valueOf(string), String.valueOf(object), n, n2};
                } else {
                    string2 = "EXC_sax_parse";
                    objectArray = new Object[]{String.valueOf(string), String.valueOf(object)};
                }
                LogRecord logRecord = new LogRecord(Level.CONFIG, null);
                logRecord.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                logRecord.setMessage(string2);
                logRecord.setParameters(objectArray);
                this.print(stringBuilder, logRecord, set);
            }
        }
    }

    public static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        NbFormatter.doPrintStackTrace(printWriter, throwable, null);
    }

    private static void doPrintStackTrace(PrintWriter printWriter, Throwable throwable, Throwable throwable2) {
        int n;
        int n2;
        Object object;
        Object object2;
        Throwable throwable3;
        block10: {
            try {
                if (throwable.getClass().getMethod("printStackTrace", PrintWriter.class).getDeclaringClass() != Throwable.class) {
                    throwable.printStackTrace(printWriter);
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)noSuchMethodException);
            }
        }
        if ((throwable3 = throwable.getCause()) != null) {
            NbFormatter.doPrintStackTrace(printWriter, throwable3, throwable);
            printWriter.print("Caused: ");
        }
        String string = throwable.toString();
        if (throwable3 != null && string.endsWith((String)(object2 = ": " + throwable3))) {
            string = string.substring(0, string.length() - ((String)object2).length());
        }
        printWriter.println(string);
        object2 = throwable.getStackTrace();
        if (throwable2 != null) {
            object = throwable2.getStackTrace();
            for (n2 = ((StackTraceElement[])object2).length; n2 > 0 && (n = n2 + ((StackTraceElement[])object).length - ((Object)object2).length) > 0 && ((StackTraceElement)object[n - 1]).equals(object2[n2 - 1]); --n2) {
            }
        }
        object = catchIndex.get(throwable);
        for (n = 0; n < n2; ++n) {
            if (object != null && n == (Integer)object) {
                printWriter.print("[catch] at ");
            } else {
                printWriter.print("\tat ");
            }
            printWriter.println(object2[n]);
        }
    }

    static void registerCatchIndex(Throwable throwable, int n) {
        catchIndex.put(throwable, n);
    }
}

