/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.Lookup;
import org.openide.util.UserCancelException;

public abstract class NodeOperation {
    protected NodeOperation() {
    }

    public static NodeOperation getDefault() {
        NodeOperation nodeOperation = (NodeOperation)Lookup.getDefault().lookup(NodeOperation.class);
        if (nodeOperation == null) {
            throw new IllegalStateException("To use NodeOperation you should have its implementation around. For example one from openide-explorer.jar");
        }
        return nodeOperation;
    }

    public abstract boolean customize(Node var1);

    public abstract void explore(Node var1);

    public abstract void showProperties(Node var1);

    public abstract void showProperties(Node[] var1);

    public void showCustomEditorDialog(Node.Property<?> property, Object ... objectArray) {
        throw new UnsupportedOperationException();
    }

    public abstract Node[] select(String var1, String var2, Node var3, NodeAcceptor var4, Component var5) throws UserCancelException;

    public Node[] select(String string, String string2, Node node, NodeAcceptor nodeAcceptor) throws UserCancelException {
        return this.select(string, string2, node, nodeAcceptor, null);
    }

    public final Node select(String string, String string2, Node node) throws UserCancelException {
        return this.select(string, string2, node, new NodeAcceptor(){

            @Override
            public boolean acceptNodes(Node[] nodeArray) {
                return nodeArray.length == 1;
            }
        })[0];
    }
}

