/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.presets;

import com.sun.tools.visualvm.profiling.presets.ProfilerPreset;
import com.sun.tools.visualvm.profiling.presets.ProfilerPresets;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;

public final class PresetSelector
extends JPanel {
    private final Runnable presetSynchronizer;
    private JLabel presetsLabel;
    private JComboBox presetsCombo;
    private JButton presetsButton;
    private PresetSelector refSelector;
    private final ProfilerPreset defaultPreset;
    private ProfilerPreset customPreset;
    private final String selector;
    private boolean savingCustom;
    private boolean customSelected;
    private boolean internalChange = false;

    PresetSelector(final PresetSelector refSelector, ProfilerPreset defaultPreset, ProfilerPreset customPreset, final ProfilerPreset toSelect, Runnable presetSynchronizer, String selector) {
        this.refSelector = refSelector;
        if (refSelector != null) {
            this.customPreset = refSelector.customPreset;
        }
        this.selector = selector;
        this.presetSynchronizer = presetSynchronizer;
        this.defaultPreset = defaultPreset;
        this.customPreset = customPreset;
        this.initComponents(refSelector);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (refSelector != null) {
                    refSelector.refSelector = PresetSelector.this;
                }
                PresetSelector.this.updatePresets(toSelect);
            }
        });
    }

    public ProfilerPreset getSelectedPreset() {
        return (ProfilerPreset)this.presetsCombo.getSelectedItem();
    }

    public void synchronizeWith(final PresetSelector selector) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (selector.customPreset != null) {
                    PresetSelector.this.customPreset = new ProfilerPreset(selector.customPreset);
                    if (PresetSelector.this.refSelector != null) {
                        PresetSelector.this.refSelector.customPreset = PresetSelector.this.customPreset;
                    }
                }
                PresetSelector.this.updatePresets(selector.getSelectedPreset());
            }
        });
    }

    public ProfilerPreset customize(boolean presetValid) {
        if (this.customPreset == null) {
            this.customPreset = new ProfilerPreset(NbBundle.getMessage(PresetSelector.class, (String)"LBL_Custom"), null);
            if (this.refSelector != null) {
                this.refSelector.customPreset = this.customPreset;
            }
        }
        this.customPreset.setValid(presetValid);
        this.internalChange = true;
        if (this.presetsCombo.getItemCount() < 2 || this.presetsCombo.getItemAt(1) != this.customPreset) {
            this.presetsCombo.insertItemAt(this.customPreset, 1);
        }
        this.presetsCombo.setSelectedIndex(1);
        this.internalChange = false;
        return this.customPreset;
    }

    void presetsChanged(ProfilerPreset selectedPreset) {
        this.updatePresets(this.savingCustom ? selectedPreset : null);
        this.savingCustom = false;
    }

    private void selectedPresetChanged() {
        boolean custom;
        Object selected = this.presetsCombo.getSelectedItem();
        if (selected == null) {
            return;
        }
        boolean bl = custom = selected == this.customPreset;
        if (this.customSelected != custom) {
            this.customSelected = custom;
            this.presetsButton.setText(custom ? NbBundle.getMessage(PresetSelector.class, (String)"BTN_Save") : NbBundle.getMessage(PresetSelector.class, (String)"BTN_Edit"));
        }
        this.updatePresetsButton(true);
        if (this.internalChange) {
            return;
        }
        this.notifySynchronizer();
    }

    private void actionRequested() {
        if (this.customSelected) {
            ProfilerPreset preset = new ProfilerPreset(this.customPreset);
            preset.setSelector(this.selector);
            this.savingCustom = true;
            ProfilerPresets.getInstance().savePreset(preset);
        } else {
            ProfilerPresets.getInstance().editPresets(this.getSelectedPreset());
        }
    }

    private void notifySynchronizer() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PresetSelector.this.presetSynchronizer.run();
            }
        });
    }

    private void updatePresets(ProfilerPreset toSelect) {
        if (toSelect == null) {
            toSelect = (ProfilerPreset)this.presetsCombo.getSelectedItem();
        }
        this.internalChange = true;
        this.presetsCombo.removeAllItems();
        this.presetsCombo.addItem(this.defaultPreset);
        if (this.savingCustom) {
            this.customPreset = null;
        }
        if (this.customPreset != null) {
            this.presetsCombo.addItem(this.customPreset);
        }
        ProfilerPresets.PresetsModel presets = ProfilerPresets.getInstance().getPresets();
        for (int i = 0; i < presets.size(); ++i) {
            this.presetsCombo.addItem(presets.get(i));
        }
        if (toSelect != null) {
            this.presetsCombo.setSelectedItem(toSelect);
        } else {
            this.presetsCombo.setSelectedIndex(0);
        }
        this.internalChange = false;
        this.notifySynchronizer();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.presetsLabel.setEnabled(enabled);
        this.presetsCombo.setEnabled(enabled);
        this.updatePresetsButton(enabled);
    }

    private void updatePresetsButton(boolean enabled) {
        ProfilerPreset preset = this.getSelectedPreset();
        this.presetsButton.setEnabled(enabled && preset != null && preset.isValid());
        if (this.refSelector != null) {
            this.refSelector.presetsButton.setEnabled(this.presetsButton.isEnabled());
        }
    }

    private void initComponents(PresetSelector refSelector) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(5, 0));
        this.presetsLabel = new JLabel(NbBundle.getMessage(PresetSelector.class, (String)"LBL_Preset"));
        this.presetsLabel.setToolTipText(NbBundle.getMessage(PresetSelector.class, (String)"TOOLTIP_Defined_presets"));
        this.add((Component)this.presetsLabel, "West");
        this.presetsCombo = refSelector == null ? new JComboBox() : new JComboBox(refSelector.presetsCombo.getModel());
        this.presetsCombo.setToolTipText(NbBundle.getMessage(PresetSelector.class, (String)"TOOLTIP_Defined_presets"));
        this.presetsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetSelector.this.selectedPresetChanged();
            }
        });
        this.add((Component)this.presetsCombo, "Center");
        this.presetsButton = new JButton(NbBundle.getMessage(PresetSelector.class, (String)"BTN_Save")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                PresetSelector.this.actionRequested();
            }
        };
        this.presetsButton.setToolTipText(NbBundle.getMessage(PresetSelector.class, (String)"TOOLTIP_Manage_presets"));
        this.add((Component)this.presetsButton, "East");
        Dimension dim1 = this.presetsButton.getPreferredSize();
        this.presetsButton.setText(NbBundle.getMessage(PresetSelector.class, (String)"BTN_Edit"));
        Dimension dim2 = this.presetsButton.getPreferredSize();
        dim1.width = Math.max(dim1.width, dim2.width);
        dim1.height = Math.max(dim1.height, dim2.height);
        this.presetsButton.setPreferredSize(dim1);
    }
}

