/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ChangeSupport;

public interface UndoRedo {
    public static final UndoRedo NONE = new Empty();

    public boolean canUndo();

    public boolean canRedo();

    public void undo() throws CannotUndoException;

    public void redo() throws CannotRedoException;

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public String getUndoPresentationName();

    public String getRedoPresentationName();

    @Deprecated
    public static final class Empty
    implements UndoRedo {
        @Override
        public boolean canUndo() {
            return false;
        }

        @Override
        public boolean canRedo() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            throw new CannotUndoException();
        }

        @Override
        public void redo() throws CannotRedoException {
            throw new CannotRedoException();
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public String getUndoPresentationName() {
            return "";
        }

        @Override
        public String getRedoPresentationName() {
            return "";
        }
    }

    public static class Manager
    extends UndoManager
    implements UndoRedo {
        static final long serialVersionUID = 6721367974521509720L;
        private int indexOfNextAdd = 0;
        private int limit = 100;
        private boolean inProgress = true;
        private boolean hasBeenDone = true;
        private boolean alive = true;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public Manager() {
            this.edits.ensureCapacity(this.limit);
        }

        @Override
        public void die() {
            int n = this.edits.size();
            for (int i = n - 1; i >= 0; --i) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
                undoableEdit.die();
            }
            this.alive = false;
        }

        @Override
        public boolean isInProgress() {
            return this.inProgress;
        }

        @Override
        public void end() {
            this.inProgress = false;
            this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            if (this.inProgress) {
                UndoableEdit undoableEdit = this.editToBeUndone();
                if (undoableEdit == null) {
                    throw new CannotUndoException();
                }
                this.undoTo(undoableEdit);
            } else {
                int n;
                if (!this.canUndo()) {
                    throw new CannotUndoException();
                }
                try {
                    for (n = this.edits.size() - 1; n >= 0; --n) {
                        ((UndoableEdit)this.edits.get(n)).undo();
                    }
                    this.hasBeenDone = false;
                }
                finally {
                    if (n != -1) {
                        int n2 = this.edits.size();
                        while (++n < n2) {
                            ((UndoableEdit)this.edits.get(n)).redo();
                        }
                    }
                }
            }
            this.cs.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
            int n = this.indexOfNextAdd;
            boolean bl = false;
            try {
                while (!bl) {
                    UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.get(--n);
                    undoableEdit2.undo();
                    bl = undoableEdit2 == undoableEdit;
                }
                this.indexOfNextAdd = n;
            }
            finally {
                if (!bl) {
                    ++n;
                    while (n < this.indexOfNextAdd) {
                        ((UndoableEdit)this.edits.get(n)).redo();
                        ++n;
                    }
                }
            }
        }

        @Override
        public boolean canUndo() {
            if (this.inProgress) {
                UndoableEdit undoableEdit = this.editToBeUndone();
                return undoableEdit != null && undoableEdit.canUndo();
            }
            return !this.isInProgress() && this.alive && this.hasBeenDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            if (this.inProgress) {
                UndoableEdit undoableEdit = this.editToBeRedone();
                if (undoableEdit == null) {
                    throw new CannotRedoException();
                }
                this.redoTo(undoableEdit);
            } else {
                int n;
                if (!this.canRedo()) {
                    throw new CannotRedoException();
                }
                int n2 = this.edits.size();
                try {
                    for (n = 0; n < n2; ++n) {
                        ((UndoableEdit)this.edits.get(n)).redo();
                    }
                    this.hasBeenDone = true;
                }
                finally {
                    if (n != n2) {
                        while (--n >= 0) {
                            ((UndoableEdit)this.edits.get(n)).undo();
                        }
                    }
                }
            }
            this.cs.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
            int n = this.indexOfNextAdd;
            boolean bl = false;
            try {
                while (!bl) {
                    UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(n++);
                    undoableEdit2.redo();
                    bl = undoableEdit2 == undoableEdit;
                }
                this.indexOfNextAdd = n;
            }
            finally {
                if (!bl) {
                    n -= 2;
                    while (n >= this.indexOfNextAdd) {
                        ((UndoableEdit)this.edits.get(n)).undo();
                        --n;
                    }
                }
            }
        }

        @Override
        public boolean canRedo() {
            if (this.inProgress) {
                UndoableEdit undoableEdit = this.editToBeRedone();
                return undoableEdit != null && undoableEdit.canRedo();
            }
            return !this.isInProgress() && this.alive && !this.hasBeenDone;
        }

        @Override
        public void undoOrRedo() throws CannotRedoException, CannotUndoException {
            if (this.indexOfNextAdd == this.edits.size()) {
                this.undo();
            } else {
                this.redo();
            }
        }

        @Override
        public boolean canUndoOrRedo() {
            if (this.indexOfNextAdd == this.edits.size()) {
                return this.canUndo();
            }
            return this.canRedo();
        }

        @Override
        public int getLimit() {
            return this.limit;
        }

        @Override
        public void setLimit(int n) {
            if (!this.inProgress) {
                throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
            }
            this.limit = n;
            this.trimForLimit();
        }

        @Override
        protected void trimForLimit() {
            int n;
            if (this.limit >= 0 && (n = this.edits.size()) > this.limit) {
                int n2 = this.limit / 2;
                int n3 = this.indexOfNextAdd - 1 + n2;
                int n4 = this.indexOfNextAdd - 1 - n2;
                if (n3 - n4 + 1 > this.limit) {
                    ++n4;
                }
                if (n4 < 0) {
                    n3 -= n4;
                    n4 = 0;
                }
                if (n3 >= n) {
                    int n5 = n - n3 - 1;
                    n3 += n5;
                    n4 += n5;
                }
                this.trimEdits(n3 + 1, n - 1);
                this.trimEdits(0, n4 - 1);
            }
        }

        @Override
        protected void trimEdits(int n, int n2) {
            if (n <= n2) {
                for (int i = n2; n <= i; --i) {
                    UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
                    undoableEdit.die();
                    this.edits.removeElementAt(i);
                }
                if (this.indexOfNextAdd > n2) {
                    this.indexOfNextAdd -= n2 - n + 1;
                } else if (this.indexOfNextAdd >= n) {
                    this.indexOfNextAdd = n;
                }
            }
        }

        @Override
        public void discardAllEdits() {
            Enumeration enumeration = this.edits.elements();
            while (enumeration.hasMoreElements()) {
                UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
                undoableEdit.die();
            }
            this.edits = new Vector();
            this.indexOfNextAdd = 0;
            this.cs.fireChange();
        }

        @Override
        protected UndoableEdit lastEdit() {
            int n = this.edits.size();
            if (n > 0) {
                return (UndoableEdit)this.edits.elementAt(n - 1);
            }
            return null;
        }

        @Override
        protected UndoableEdit editToBeUndone() {
            int n = this.indexOfNextAdd;
            while (n > 0) {
                UndoableEdit undoableEdit;
                if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(--n)).isSignificant()) continue;
                return undoableEdit;
            }
            return null;
        }

        @Override
        protected UndoableEdit editToBeRedone() {
            int n = this.edits.size();
            int n2 = this.indexOfNextAdd;
            while (n2 < n) {
                UndoableEdit undoableEdit;
                if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(n2++)).isSignificant()) continue;
                return undoableEdit;
            }
            return null;
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            this.addEdit(undoableEditEvent.getEdit());
            this.cs.fireChange();
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            boolean bl;
            this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
            if (!this.inProgress) {
                bl = false;
            } else {
                UndoableEdit undoableEdit2 = this.lastEdit();
                if (undoableEdit2 == null) {
                    this.edits.addElement(undoableEdit);
                } else if (!undoableEdit2.addEdit(undoableEdit)) {
                    if (undoableEdit.replaceEdit(undoableEdit2)) {
                        this.edits.removeElementAt(this.edits.size() - 1);
                    }
                    this.edits.addElement(undoableEdit);
                }
                bl = true;
            }
            this.indexOfNextAdd = this.edits.size();
            this.trimForLimit();
            return bl;
        }

        @Override
        public boolean replaceEdit(UndoableEdit undoableEdit) {
            return false;
        }

        @Override
        public boolean isSignificant() {
            Enumeration enumeration = this.edits.elements();
            while (enumeration.hasMoreElements()) {
                if (!((UndoableEdit)enumeration.nextElement()).isSignificant()) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getPresentationName() {
            UndoableEdit undoableEdit = this.lastEdit();
            if (undoableEdit != null) {
                return undoableEdit.getPresentationName();
            }
            return "";
        }

        @Override
        public String getUndoPresentationName() {
            if (this.canUndo()) {
                if (this.inProgress) {
                    if (this.canUndo()) {
                        return this.editToBeUndone().getUndoPresentationName();
                    }
                    return UIManager.getString("AbstractUndoableEdit.undoText");
                }
                UndoableEdit undoableEdit = this.lastEdit();
                if (undoableEdit != null) {
                    return undoableEdit.getUndoPresentationName();
                }
                String string = this.getPresentationName();
                string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + string : UIManager.getString("AbstractUndoableEdit.undoText");
                return string;
            }
            return "";
        }

        @Override
        public String getRedoPresentationName() {
            if (this.canRedo()) {
                UndoableEdit undoableEdit = this.lastEdit();
                if (undoableEdit != null) {
                    if (this.inProgress) {
                        if (this.canRedo()) {
                            return this.editToBeRedone().getRedoPresentationName();
                        }
                        return UIManager.getString("AbstractUndoableEdit.redoText");
                    }
                    return super.getRedoPresentationName();
                }
                String string = this.getPresentationName();
                string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + string : UIManager.getString("AbstractUndoableEdit.redoText");
                return string;
            }
            return "";
        }

        @Override
        public String getUndoOrRedoPresentationName() {
            if (this.indexOfNextAdd == this.edits.size()) {
                return this.getUndoPresentationName();
            }
            return this.getRedoPresentationName();
        }

        @Override
        public String toString() {
            return super.toString() + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive + " inProgress: " + this.inProgress + " edits: " + this.edits + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }
    }

    public static interface Provider {
        public UndoRedo getUndoRedo();
    }
}

