/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.lib.profiler.results.CCTNode;

public abstract class LockCCTNode
implements CCTNode {
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME = 2;
    public static final int SORT_BY_WAITS = 3;
    public static final LockCCTNode EMPTY = new LockCCTNode(null){

        @Override
        public LockCCTNode getChild(int n) {
            return null;
        }

        @Override
        public LockCCTNode[] getChildren() {
            return new LockCCTNode[0];
        }

        @Override
        public int getIndexOfChild(Object object) {
            return -1;
        }

        @Override
        public int getNChildren() {
            return 0;
        }

        @Override
        public String getNodeName() {
            return "";
        }

        @Override
        public long getTime() {
            return 0L;
        }

        @Override
        public double getTimeInPerCent() {
            return 0.0;
        }

        @Override
        public long getWaits() {
            return 0L;
        }
    };
    private List<LockCCTNode> children;
    private final LockCCTNode parent;
    private int sortBy;
    private boolean sortOrder;

    LockCCTNode(LockCCTNode lockCCTNode) {
        this.parent = lockCCTNode;
    }

    @Override
    public LockCCTNode getChild(int n) {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.get(n);
    }

    public LockCCTNode[] getChildren() {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.toArray(new LockCCTNode[this.children.size()]);
    }

    @Override
    public int getIndexOfChild(Object object) {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.indexOf(object);
    }

    @Override
    public int getNChildren() {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.size();
    }

    @Override
    public LockCCTNode getParent() {
        return this.parent;
    }

    void addChild(LockCCTNode lockCCTNode) {
        if (this.children == null) {
            this.children = new ArrayList<LockCCTNode>();
        }
        this.children.add(lockCCTNode);
    }

    void computeChildren() {
        this.children = new ArrayList<LockCCTNode>();
    }

    private void computeChildrenImpl() {
        this.computeChildren();
        this.sortChildren(this.sortBy, this.sortOrder);
    }

    public double getTimeInPerCent() {
        LockCCTNode lockCCTNode = this.getParent();
        long l = lockCCTNode.getTime();
        double d = lockCCTNode.getTimeInPerCent();
        long l2 = this.getTime();
        return d * (double)l2 / (double)l;
    }

    public abstract String getNodeName();

    public abstract long getTime();

    public abstract long getWaits();

    public boolean isThreadLockNode() {
        return false;
    }

    public boolean isMonitorNode() {
        return false;
    }

    public void sortChildren(int n, boolean bl) {
        this.sortBy = n;
        this.sortOrder = bl;
        if (this.children == null || this.getNChildren() < 2) {
            return;
        }
        this.doSortChildren(n, bl);
    }

    protected void doSortChildren(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.sortChildrenByName(bl);
                break;
            }
            case 2: {
                this.sortChildrenByTime(bl);
                break;
            }
            case 3: {
                this.sortChildrenByWaits(bl);
            }
        }
        for (LockCCTNode lockCCTNode : this.children) {
            lockCCTNode.sortChildren(n, bl);
        }
    }

    protected void sortChildrenByName(final boolean bl) {
        Collections.sort(this.children, new Comparator<LockCCTNode>(){

            @Override
            public int compare(LockCCTNode lockCCTNode, LockCCTNode lockCCTNode2) {
                return bl ? lockCCTNode.getNodeName().toLowerCase().compareTo(lockCCTNode2.getNodeName().toLowerCase()) : lockCCTNode2.getNodeName().toLowerCase().compareTo(lockCCTNode.getNodeName().toLowerCase());
            }
        });
    }

    protected void sortChildrenByTime(final boolean bl) {
        Collections.sort(this.children, new Comparator<LockCCTNode>(){

            @Override
            public int compare(LockCCTNode lockCCTNode, LockCCTNode lockCCTNode2) {
                long l;
                long l2 = l = bl ? lockCCTNode.getTime() - lockCCTNode2.getTime() : lockCCTNode2.getTime() - lockCCTNode.getTime();
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
        });
    }

    protected void sortChildrenByWaits(final boolean bl) {
        Collections.sort(this.children, new Comparator<LockCCTNode>(){

            @Override
            public int compare(LockCCTNode lockCCTNode, LockCCTNode lockCCTNode2) {
                long l;
                long l2 = l = bl ? lockCCTNode.getWaits() - lockCCTNode2.getWaits() : lockCCTNode2.getWaits() - lockCCTNode.getWaits();
                return l == 0L ? 0 : (l > 0L ? 1 : -1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void debug() {
        if (this.parent != null) {
            void var1_2;
            String object = "";
            for (CCTNode cCTNode = this.parent; cCTNode != null; cCTNode = cCTNode.getParent()) {
                String string = (String)var1_2 + "  ";
            }
            System.out.println((String)var1_2 + this.getNodeName() + " Waits: " + this.getWaits() + " Time: " + this.getTime() + " " + NumberFormat.getPercentInstance().format(this.getTimeInPerCent() / 100.0));
        }
        for (LockCCTNode lockCCTNode : this.getChildren()) {
            if (!(lockCCTNode instanceof LockCCTNode)) continue;
            lockCCTNode.debug();
        }
    }
}

