/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.persistence.GroupConfig;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.netbeans.core.windows.persistence.TCRefConfig;
import org.netbeans.core.windows.persistence.WindowManagerParser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

class ModuleChangeHandler
implements FileChangeListener {
    private static final boolean DEBUG = Debug.isLoggable(ModuleChangeHandler.class);
    private boolean started = false;
    private FileSystem fs = null;
    private FileObject modesModuleFolder;
    private FileObject groupsModuleFolder;
    private Set<FileObject> modesModuleChildren = new HashSet<FileObject>();
    private Set<FileObject> groupsModuleChildren = new HashSet<FileObject>();
    private FileObject componentsModuleFolder;
    private List<FileObject> tcRefsWaitingOnSettings;
    private static final RequestProcessor RP = new RequestProcessor("WinSysModuleChangeHandler", 1);

    private void refreshModesFolder() {
        FileObject[] fileObjectArray = this.modesModuleFolder.getChildren();
        this.modesModuleChildren.clear();
        for (FileObject fileObject : fileObjectArray) {
            if (!fileObject.isFolder()) continue;
            this.modesModuleChildren.add(fileObject);
            fileObject.getChildren();
        }
    }

    private void refreshGroupsFolder() {
        FileObject[] fileObjectArray = this.groupsModuleFolder.getChildren();
        this.groupsModuleChildren.clear();
        for (FileObject fileObject : fileObjectArray) {
            if (!fileObject.isFolder()) continue;
            this.groupsModuleChildren.add(fileObject);
            fileObject.getChildren();
        }
    }

    void startHandling() {
        if (this.started) {
            return;
        }
        PersistenceManager persistenceManager = PersistenceManager.getDefault();
        try {
            this.modesModuleFolder = persistenceManager.getModesModuleFolder();
            this.refreshModesFolder();
            this.groupsModuleFolder = persistenceManager.getGroupsModuleFolder();
            this.refreshGroupsFolder();
            this.componentsModuleFolder = persistenceManager.getComponentsModuleFolder();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.WARNING, "[WinSys.ModuleChangeHandler.startHandling] Cannot get data folders.", iOException);
            return;
        }
        try {
            this.fs = this.modesModuleFolder.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            PersistenceManager.LOG.log(Level.WARNING, "[WinSys.ModuleChangeHandler.startHandling] Cannot get filesystem.", fileStateInvalidException);
            return;
        }
        this.fs.addFileChangeListener((FileChangeListener)this);
        this.started = true;
    }

    void stopHandling() {
        if (!this.started) {
            return;
        }
        this.fs.removeFileChangeListener((FileChangeListener)this);
        this.fs = null;
        this.started = false;
    }

    private boolean acceptEvent(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return false;
        }
        if (fileObject2.getPath().equals(this.modesModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ MODE ++");
            }
            return true;
        }
        if (fileObject2.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ GROUP ++");
            }
            return true;
        }
        if (fileObject2.getPath().equals(this.componentsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ COMPONENT ++");
            }
            return true;
        }
        if ((fileObject2 = fileObject2.getParent()) == null) {
            return false;
        }
        if (fileObject2.getPath().equals(this.modesModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ tcRef ++");
            }
            return true;
        }
        if (fileObject2.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ tcGroup ++");
            }
            return true;
        }
        return false;
    }

    private boolean isInModesFolder(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return false;
        }
        if (fileObject2.getPath().equals(this.modesModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ MODE ++");
            }
            return true;
        }
        return false;
    }

    private boolean isInGroupsFolder(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return false;
        }
        if (fileObject2.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ GROUP ++");
            }
            return true;
        }
        return false;
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileDataCreated(final FileEvent fileEvent) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject = fileEvent.getFile();
                boolean bl = ModuleChangeHandler.this.acceptEvent(fileObject);
                if (!bl) {
                    return;
                }
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "-- fileDataCreated fo: " + fileObject + " isFolder:" + fileObject.isFolder() + " ACCEPTED" + " th:" + Thread.currentThread().getName());
                    if (bl && fileObject.isFolder()) {
                        FileObject[] fileObjectArray = fileObject.getChildren();
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            Debug.log(ModuleChangeHandler.class, "fo[" + i + "]: " + fileObjectArray[i]);
                        }
                    }
                }
                ModuleChangeHandler.this.processDataOrFolderCreated(fileObject);
            }
        });
    }

    public void fileFolderCreated(final FileEvent fileEvent) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject = fileEvent.getFile();
                boolean bl = ModuleChangeHandler.this.acceptEvent(fileObject);
                if (!bl) {
                    return;
                }
                if (ModuleChangeHandler.this.isInModesFolder(fileObject)) {
                    ModuleChangeHandler.this.refreshModesFolder();
                }
                if (ModuleChangeHandler.this.isInGroupsFolder(fileObject)) {
                    ModuleChangeHandler.this.refreshGroupsFolder();
                }
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "-- fileFolderCreated fo: " + fileObject + " isFolder:" + fileObject.isFolder() + " ACCEPTED" + " th:" + Thread.currentThread().getName());
                    if (bl && fileObject.isFolder()) {
                        FileObject[] fileObjectArray = fileObject.getChildren();
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            Debug.log(ModuleChangeHandler.class, "fo[" + i + "]: " + fileObjectArray[i]);
                        }
                    }
                }
                ModuleChangeHandler.this.processDataOrFolderCreated(fileObject);
            }
        });
    }

    private void processDataOrFolderCreated(FileObject fileObject) {
        FileObject fileObject2;
        FileObject fileObject3 = fileObject.getParent();
        if (fileObject3.getPath().equals(this.modesModuleFolder.getPath())) {
            if (!fileObject.isFolder() && "wsmode".equals(fileObject.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process MODE ADD ++");
                }
                this.addMode(fileObject.getName());
            }
        } else if (fileObject3.getPath().equals(this.groupsModuleFolder.getPath())) {
            if (!fileObject.isFolder() && "wsgrp".equals(fileObject.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process GROUP ADD ++");
                }
                this.addGroup(fileObject.getName());
            }
        } else if (fileObject3.getPath().equals(this.componentsModuleFolder.getPath()) && !fileObject.isFolder() && "settings".equals(fileObject.getExt())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ process COMPONENT ADD ++");
            }
            this.addComponent(fileObject);
        }
        if ((fileObject2 = fileObject3.getParent()).getPath().equals(this.modesModuleFolder.getPath())) {
            if (!fileObject.isFolder() && "wstcref".equals(fileObject.getExt())) {
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "++ process tcRef ADD ++");
                }
                this.processTCRef(fileObject3.getName(), fileObject);
            }
        } else if (fileObject2.getPath().equals(this.groupsModuleFolder.getPath()) && !fileObject.isFolder() && "wstcgrp".equals(fileObject.getExt())) {
            if (DEBUG) {
                Debug.log(ModuleChangeHandler.class, "++ process tcGroup ADD ++");
            }
            this.addTCGroup(fileObject3.getName(), fileObject.getName());
        }
    }

    public void fileDeleted(final FileEvent fileEvent) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject;
                FileObject fileObject2;
                FileObject fileObject3 = fileEvent.getFile();
                boolean bl = ModuleChangeHandler.this.acceptEvent(fileObject3);
                if (!bl) {
                    return;
                }
                if (ModuleChangeHandler.this.isInModesFolder(fileObject3)) {
                    ModuleChangeHandler.this.refreshModesFolder();
                }
                if (ModuleChangeHandler.this.isInGroupsFolder(fileObject3)) {
                    ModuleChangeHandler.this.refreshGroupsFolder();
                }
                if (DEBUG) {
                    Debug.log(ModuleChangeHandler.class, "-- fileDeleted fo: " + fileObject3 + " isFolder:" + fileObject3.isFolder() + " isValid:" + fileObject3.isValid() + " ACCEPTED" + " th:" + Thread.currentThread().getName());
                }
                if ((fileObject2 = fileObject3.getParent()).getPath().equals(ModuleChangeHandler.this.modesModuleFolder.getPath())) {
                    if (!fileObject3.isFolder() && "wsmode".equals(fileObject3.getExt())) {
                        if (DEBUG) {
                            Debug.log(ModuleChangeHandler.class, "++ process MODE REMOVE ++");
                        }
                        ModuleChangeHandler.this.removeMode(fileObject3.getName());
                    }
                } else if (fileObject2.getPath().equals(ModuleChangeHandler.this.groupsModuleFolder.getPath()) && !fileObject3.isFolder() && "wsgrp".equals(fileObject3.getExt())) {
                    if (DEBUG) {
                        Debug.log(ModuleChangeHandler.class, "++ process GROUP REMOVE ++");
                    }
                    ModuleChangeHandler.this.removeGroup(fileObject3.getName());
                }
                if ((fileObject = fileObject2.getParent()).getPath().equals(ModuleChangeHandler.this.modesModuleFolder.getPath())) {
                    if (!fileObject3.isFolder() && "wstcref".equals(fileObject3.getExt())) {
                        if (DEBUG) {
                            Debug.log(ModuleChangeHandler.class, "++ process tcRef REMOVE ++");
                        }
                        ModuleChangeHandler.this.removeTCRef(fileObject3.getName());
                    }
                } else if (fileObject.getPath().equals(ModuleChangeHandler.this.groupsModuleFolder.getPath()) && !fileObject3.isFolder() && "wstcgrp".equals(fileObject3.getExt())) {
                    if (DEBUG) {
                        Debug.log(ModuleChangeHandler.class, "++ process tcGroup REMOVE ++");
                    }
                    ModuleChangeHandler.this.removeTCGroup(fileObject2.getName(), fileObject3.getName());
                }
            }
        });
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    private void addMode(String string) {
        WindowManagerParser windowManagerParser;
        ModeConfig modeConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addMode mo:" + string);
        }
        if ((modeConfig = (windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser()).addMode(string)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().modeConfigAdded(modeConfig);
                }
            });
        }
    }

    private void addGroup(String string) {
        WindowManagerParser windowManagerParser;
        GroupConfig groupConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addGroup group:" + string);
        }
        if ((groupConfig = (windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser()).addGroup(string)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().groupConfigAdded(groupConfig);
                }
            });
        }
    }

    private void processTCRef(String string, FileObject fileObject) {
        FileObject fileObject2 = null;
        try {
            fileObject2 = PersistenceManager.getDefault().getComponentsLocalFolder();
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.WARNING, "[WinSys.ModuleChangeHandler.processTCRef] Cannot get components folder.", iOException);
            return;
        }
        FileObject fileObject3 = fileObject2.getFileObject(fileObject.getName(), "settings");
        if (fileObject3 != null) {
            this.addTCRef(string, fileObject.getName());
        } else {
            if (this.tcRefsWaitingOnSettings == null) {
                this.tcRefsWaitingOnSettings = new ArrayList<FileObject>(5);
            }
            this.tcRefsWaitingOnSettings.add(fileObject);
        }
    }

    private void addTCRef(final String string, String string2) {
        String[] stringArray;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addTCRef modeName:" + string + " tcRefName:" + string2);
        }
        WindowManagerParser windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        final TCRefConfig tCRefConfig = windowManagerParser.addTCRef(string, string2, arrayList);
        try {
            if (null != tCRefConfig && null != (stringArray = PersistenceManager.getDefault().findTopComponentDataObject(tCRefConfig.tc_id))) {
                stringArray.getCookie(InstanceCookie.class);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(ModuleChangeHandler.class.getName()).log(Level.FINER, null, iOException);
        }
        if (tCRefConfig != null) {
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentRefConfigAdded(string, tCRefConfig, stringArray);
                }
            });
        }
    }

    private void addTCGroup(final String string, String string2) {
        WindowManagerParser windowManagerParser;
        TCGroupConfig tCGroupConfig;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addTCGroup groupName:" + string + " tcGroupName:" + string2);
        }
        if ((tCGroupConfig = (windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser()).addTCGroup(string, string2)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentGroupConfigAdded(string, tCGroupConfig);
                }
            });
        }
    }

    private void addComponent(FileObject fileObject) {
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "addComponent settingsName:" + fileObject.getNameExt());
        }
        try {
            PersistenceManager.getDefault().copySettingsFileIfNeeded(fileObject);
        }
        catch (IOException iOException) {
            PersistenceManager.LOG.log(Level.WARNING, "[WinSys.ModuleChangeHandler.addComponent] Cannot copy settings files.", iOException);
            return;
        }
        FileObject fileObject2 = this.findWaitingTcRef(fileObject);
        if (fileObject2 != null) {
            this.tcRefsWaitingOnSettings.remove(fileObject2);
            this.addTCRef(fileObject2.getParent().getName(), fileObject2.getName());
        }
    }

    private FileObject findWaitingTcRef(FileObject fileObject) {
        if (this.tcRefsWaitingOnSettings == null) {
            return null;
        }
        String string = fileObject.getName();
        for (FileObject fileObject2 : this.tcRefsWaitingOnSettings) {
            if (!string.equals(fileObject2.getName())) continue;
            return fileObject2;
        }
        return null;
    }

    private void removeMode(String string) {
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeMode mo:" + string);
        }
        WindowManagerParser windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser();
        windowManagerParser.removeMode(string);
    }

    private void removeGroup(final String string) {
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeGroup group:" + string);
        }
        WindowManagerParser windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser();
        windowManagerParser.removeGroup(string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManagerImpl.getInstance().getPersistenceObserver().groupConfigRemoved(string);
            }
        });
    }

    private void removeTCRef(final String string) {
        WindowManagerParser windowManagerParser;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeTCRef tcRefName:" + string);
        }
        if ((windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser()).removeTCRef(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentRefConfigRemoved(string);
                }
            });
        }
    }

    private void removeTCGroup(final String string, final String string2) {
        WindowManagerParser windowManagerParser;
        if (DEBUG) {
            Debug.log(ModuleChangeHandler.class, "removeTCGroup groupName:" + string + " tcGroupName:" + string2);
        }
        if ((windowManagerParser = PersistenceManager.getDefault().getWindowManagerParser()).removeTCGroup(string, string2)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().getPersistenceObserver().topComponentGroupConfigRemoved(string, string2);
                }
            });
        }
    }

    private void log(String string) {
        Debug.log(ModuleChangeHandler.class, string);
    }
}

