/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class CompareSnapshotsAction
extends AbstractAction {
    private static final HelpCtx EXTERNAL_SNAPSHOT_HELP_CTX = new HelpCtx("SelectExternalSnapshotsPanel.HelpCtx");
    private static final HelpCtx SECOND_SNAPSHOT_HELP_CTX = new HelpCtx("SelectSecondSnapshotPanel.HelpCtx");
    private static final Icon cpuIcon = Icons.getIcon((String)"ProfilerIcons.Cpu");
    private static final Icon fragmentIcon = Icons.getIcon((String)"ProfilerIcons.Fragment");
    private static final Icon memoryIcon = Icons.getIcon((String)"ProfilerIcons.Memory");
    private static JFileChooser snapshotFileChooser;
    private LoadedSnapshot snapshot = null;
    private SelectExternalSnapshotsPanel externalSnapshotsSelector;
    private SelectSecondSnapshotPanel secondSnapshotSelector;

    public CompareSnapshotsAction() {
        this.putValue("Name", Bundle.CompareSnapshotsAction_ActionName());
        this.putValue("ShortDescription", Bundle.CompareSnapshotsAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare"));
    }

    public CompareSnapshotsAction(LoadedSnapshot loadedSnapshot) {
        this();
        this.snapshot = loadedSnapshot;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.snapshot != null) {
            this.compareDefinedSnapshot();
        } else {
            this.compareExternalSnapshots();
        }
    }

    public static boolean areComparableSnapshots(LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        if (loadedSnapshot.getType() != loadedSnapshot2.getType()) {
            return false;
        }
        return loadedSnapshot.getType() != 4 && loadedSnapshot.getType() != 8 || loadedSnapshot.getSettings().getAllocTrackEvery() == loadedSnapshot2.getSettings().getAllocTrackEvery();
    }

    public static boolean areComparableSnapshots(LoadedSnapshot loadedSnapshot, FileObject fileObject) {
        LoadedSnapshot loadedSnapshot2 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        if (loadedSnapshot2 != null) {
            return CompareSnapshotsAction.areComparableSnapshots(loadedSnapshot, loadedSnapshot2);
        }
        if (loadedSnapshot.getType() != ResultsManager.getDefault().getSnapshotType(fileObject)) {
            return false;
        }
        if (loadedSnapshot.getType() == 4 || loadedSnapshot.getType() == 8) {
            ProfilingSettings profilingSettings = ResultsManager.getDefault().getSnapshotSettings(fileObject);
            if (profilingSettings == null) {
                return false;
            }
            if (loadedSnapshot.getSettings().getAllocTrackEvery() != profilingSettings.getAllocTrackEvery()) {
                return false;
            }
        }
        return true;
    }

    public static boolean areComparableSnapshots(FileObject fileObject, FileObject fileObject2) {
        LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        LoadedSnapshot loadedSnapshot2 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject2));
        if (loadedSnapshot != null) {
            if (loadedSnapshot2 != null) {
                return CompareSnapshotsAction.areComparableSnapshots(loadedSnapshot, loadedSnapshot2);
            }
            return CompareSnapshotsAction.areComparableSnapshots(loadedSnapshot, fileObject2);
        }
        int n = ResultsManager.getDefault().getSnapshotType(fileObject);
        if (n != ResultsManager.getDefault().getSnapshotType(fileObject2)) {
            return false;
        }
        if (n == 4 || n == 8) {
            ProfilingSettings profilingSettings = ResultsManager.getDefault().getSnapshotSettings(fileObject);
            ProfilingSettings profilingSettings2 = ResultsManager.getDefault().getSnapshotSettings(fileObject2);
            if (profilingSettings == null || profilingSettings2 == null) {
                return false;
            }
            if (profilingSettings.getAllocTrackEvery() != profilingSettings2.getAllocTrackEvery()) {
                return false;
            }
        }
        return true;
    }

    private static JFileChooser getSnapshotFileChooser() {
        if (snapshotFileChooser == null) {
            snapshotFileChooser = new JFileChooser();
            snapshotFileChooser.setFileSelectionMode(0);
            snapshotFileChooser.setMultiSelectionEnabled(false);
            snapshotFileChooser.setDialogType(0);
            snapshotFileChooser.setDialogTitle(Bundle.CompareSnapshotsAction_OpenChooserCaption());
            snapshotFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".nps");
                }

                @Override
                public String getDescription() {
                    return Bundle.CompareSnapshotsAction_OpenChooserFilter("nps");
                }
            });
            snapshotFileChooser.setAcceptAllFileFilterUsed(false);
        }
        return snapshotFileChooser;
    }

    private SelectExternalSnapshotsPanel getExternalSnapshotsSelector() {
        if (this.externalSnapshotsSelector == null) {
            this.externalSnapshotsSelector = new SelectExternalSnapshotsPanel();
        }
        return this.externalSnapshotsSelector;
    }

    private SelectSecondSnapshotPanel getSecondSnapshotSelector() {
        if (this.secondSnapshotSelector == null) {
            this.secondSnapshotSelector = new SelectSecondSnapshotPanel();
        }
        return this.secondSnapshotSelector;
    }

    private void compareDefinedSnapshot() {
        this.getSecondSnapshotSelector().populateSnapshotsList();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getSecondSnapshotSelector(), Bundle.CompareSnapshotsAction_SelectSnapshotDialogCaption(), true, new Object[]{this.getSecondSnapshotSelector().getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(this.getSecondSnapshotSelector().getOKButton())) {
            Object object2 = this.getSecondSnapshotSelector().getSnapshot();
            if (object2 instanceof LoadedSnapshot) {
                ResultsManager.getDefault().compareSnapshots(this.snapshot, (LoadedSnapshot)object2);
            } else if (object2 instanceof FileObject) {
                if (this.snapshot.getFile() == null) {
                    LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().getSnapshotFromFileObject((FileObject)object2);
                    if (loadedSnapshot != null) {
                        ResultsManager.getDefault().compareSnapshots(this.snapshot, loadedSnapshot);
                    }
                } else {
                    ResultsManager.getDefault().compareSnapshots(FileUtil.toFileObject((File)this.snapshot.getFile()), (FileObject)object2);
                }
            }
        }
    }

    private void compareExternalSnapshots() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getExternalSnapshotsSelector(), Bundle.CompareSnapshotsAction_SelectSnapshotsDialogCaption(), true, new Object[]{this.getExternalSnapshotsSelector().getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(this.getExternalSnapshotsSelector().getOKButton())) {
            ResultsManager.getDefault().compareSnapshots(FileUtil.toFileObject((File)new File(this.getExternalSnapshotsSelector().getSnapshot1Filename())), FileUtil.toFileObject((File)new File(this.getExternalSnapshotsSelector().getSnapshot2Filename())));
        }
    }

    private class SelectSecondSnapshotPanel
    extends JPanel
    implements HelpCtx.Provider {
        private JButton externalFileButton;
        private JButton okButton;
        private JLabel externalFileHintLabel;
        private JLabel projectSnapshotsHintLabel;
        private JLabel selectSnapshotLabel;
        private JList projectSnapshotsList;
        private JRadioButton fromFileRadio;
        private JRadioButton fromProjectRadio;
        private JTextField externalFileField;

        public SelectSecondSnapshotPanel() {
            this.initComponents();
        }

        public HelpCtx getHelpCtx() {
            return SECOND_SNAPSHOT_HELP_CTX;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public Object getSnapshot() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                if (e == null || e instanceof String) {
                    return null;
                }
                return e;
            }
            if (this.fromFileRadio.isSelected()) {
                File file;
                String string = this.externalFileField.getText();
                if (string.length() > 0 && (file = new File(string)).exists() && file.isFile()) {
                    return FileUtil.toFileObject((File)file);
                }
                return null;
            }
            return null;
        }

        public void populateSnapshotsList() {
            DefaultListModel defaultListModel = (DefaultListModel)this.projectSnapshotsList.getModel();
            defaultListModel.removeAllElements();
            LoadedSnapshot[] loadedSnapshotArray = ResultsManager.getDefault().getLoadedSnapshots();
            for (int i = 0; i < loadedSnapshotArray.length; ++i) {
                if (loadedSnapshotArray[i] == CompareSnapshotsAction.this.snapshot || loadedSnapshotArray[i].getFile() != null || !CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, loadedSnapshotArray[i])) continue;
                defaultListModel.addElement(loadedSnapshotArray[i]);
            }
            final Lookup.Provider provider = CompareSnapshotsAction.this.snapshot.getProject();
            File file = CompareSnapshotsAction.this.snapshot.getFile();
            final File file2 = file != null ? file.getParentFile() : null;
            FileObject[] fileObjectArray = ResultsManager.getDefault().listSavedSnapshots(provider, file2);
            FileObject fileObject = file != null ? FileUtil.toFileObject((File)file) : null;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (fileObject != null && fileObjectArray[i].equals(fileObject) || !CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, fileObjectArray[i])) continue;
                defaultListModel.addElement(fileObjectArray[i]);
            }
            if (defaultListModel.getSize() == 0) {
                defaultListModel.addElement(Bundle.CompareSnapshotsAction_NoComparableSnapshotsFoundMsg());
                this.fromFileRadio.setSelected(true);
                this.externalFileField.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.externalFileField.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.externalFileField.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            } else {
                this.projectSnapshotsList.setSelectedIndex(0);
                this.projectSnapshotsList.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.projectSnapshotsList.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.projectSnapshotsList.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (provider != null) {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsAction_FromProjectRadioText());
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(null);
                    } else {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsAction_FromCurrentLocationRadioText());
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(file2 != null ? file2.getAbsolutePath() : null);
                    }
                }
            });
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.CompareSnapshotsAction_OkButtonText());
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.selectSnapshotLabel = new JLabel(Bundle.CompareSnapshotsAction_SelectSnapshotString());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 8, 10);
            this.add((Component)this.selectSnapshotLabel, gridBagConstraints);
            this.fromProjectRadio = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.fromProjectRadio, (String)Bundle.CompareSnapshotsAction_FromProjectRadioText());
            buttonGroup.add(this.fromProjectRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SelectSnapshotString() + Bundle.CompareSnapshotsAction_FromProjectRadioText());
            this.fromProjectRadio.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 10);
            this.add((Component)this.fromProjectRadio, gridBagConstraints);
            this.projectSnapshotsList = new JList(new DefaultListModel());
            this.projectSnapshotsList.getAccessibleContext().setAccessibleName(Bundle.CompareSnapshotsAction_SnapshotsListAccessDescr());
            this.projectSnapshotsList.setVisibleRowCount(5);
            this.projectSnapshotsList.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.projectSnapshotsList, 20, 31);
            jScrollPane.setPreferredSize(new Dimension(1, jScrollPane.getPreferredSize().height));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)jScrollPane, gridBagConstraints);
            this.projectSnapshotsHintLabel = new JLabel(Bundle.CompareSnapshotsAction_OnlyComparableListedString());
            this.projectSnapshotsHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.projectSnapshotsHintLabel, gridBagConstraints);
            this.fromFileRadio = new JRadioButton(Bundle.CompareSnapshotsAction_FromFileRadioText());
            Mnemonics.setLocalizedText((AbstractButton)this.fromFileRadio, (String)Bundle.CompareSnapshotsAction_FromFileRadioText());
            buttonGroup.add(this.fromFileRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SelectSnapshotString() + Bundle.CompareSnapshotsAction_FromFileRadioText());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.fromFileRadio, gridBagConstraints);
            this.externalFileField = new JTextField();
            this.externalFileField.setPreferredSize(new Dimension(250, this.externalFileField.getPreferredSize().height));
            this.externalFileField.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.externalFileField, gridBagConstraints);
            this.externalFileButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.externalFileButton, (String)Bundle.CompareSnapshotsAction_BrowseButtonText());
            this.externalFileButton.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_BrowseButtonAccessDescr());
            this.externalFileButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.externalFileButton, gridBagConstraints);
            this.externalFileHintLabel = new JLabel(" ");
            this.externalFileHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.externalFileHintLabel, gridBagConstraints);
            this.projectSnapshotsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    ResultsManager resultsManager = ResultsManager.getDefault();
                    if (object instanceof LoadedSnapshot) {
                        LoadedSnapshot loadedSnapshot = (LoadedSnapshot)object;
                        jLabel.setFont(jLabel.getFont().deriveFont(1));
                        jLabel.setText(resultsManager.getSnapshotDisplayName(loadedSnapshot));
                        switch (loadedSnapshot.getType()) {
                            case 1: {
                                jLabel.setIcon(cpuIcon);
                                break;
                            }
                            case 2: {
                                jLabel.setIcon(fragmentIcon);
                                break;
                            }
                            case 4: 
                            case 8: 
                            case 16: {
                                jLabel.setIcon(memoryIcon);
                            }
                        }
                    } else if (object instanceof FileObject) {
                        FileObject fileObject = (FileObject)object;
                        LoadedSnapshot loadedSnapshot = resultsManager.findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
                        if (loadedSnapshot != null) {
                            jLabel.setFont(jLabel.getFont().deriveFont(1));
                            jLabel.setText(resultsManager.getSnapshotDisplayName(loadedSnapshot));
                            switch (loadedSnapshot.getType()) {
                                case 1: {
                                    jLabel.setIcon(cpuIcon);
                                    break;
                                }
                                case 2: {
                                    jLabel.setIcon(fragmentIcon);
                                    break;
                                }
                                case 4: 
                                case 8: 
                                case 16: {
                                    jLabel.setIcon(memoryIcon);
                                }
                            }
                        } else {
                            int n2 = resultsManager.getSnapshotType(fileObject);
                            jLabel.setText(resultsManager.getSnapshotDisplayName(fileObject.getName(), n2));
                            switch (n2) {
                                case 1: {
                                    jLabel.setIcon(cpuIcon);
                                    break;
                                }
                                case 2: {
                                    jLabel.setIcon(fragmentIcon);
                                    break;
                                }
                                case 4: 
                                case 8: 
                                case 16: {
                                    jLabel.setIcon(memoryIcon);
                                }
                            }
                        }
                    }
                    return jLabel;
                }
            });
            this.projectSnapshotsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.projectSnapshotsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && SelectSecondSnapshotPanel.this.projectSnapshotsList.getSelectedValue() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectSecondSnapshotPanel.this.okButton.doClick();
                            }
                        });
                    }
                }
            });
            this.fromProjectRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.projectSnapshotsList.setEnabled(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected());
                    SelectSecondSnapshotPanel.this.projectSnapshotsHintLabel.setText(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected() ? Bundle.CompareSnapshotsAction_OnlyComparableListedString() : " ");
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.fromFileRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.externalFileField.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    SelectSecondSnapshotPanel.this.externalFileButton.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    if (!SelectSecondSnapshotPanel.this.fromFileRadio.isSelected()) {
                        SelectSecondSnapshotPanel.this.externalFileHintLabel.setText(" ");
                    }
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            };
            this.externalFileField.getDocument().addDocumentListener(documentListener);
            this.externalFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectSecondSnapshotPanel.this.externalFileField.getText()));
                    if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectSecondSnapshotPanel.this.externalFileField.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                this.okButton.setEnabled(e != null && !(e instanceof String));
            } else if (this.fromFileRadio.isSelected()) {
                String string = this.externalFileField.getText();
                if (string.length() > 0) {
                    File file = new File(string);
                    if (file.exists() && file.isFile()) {
                        if (file.equals(CompareSnapshotsAction.this.snapshot.getFile())) {
                            this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_ComparingSameSnapshotsMsg());
                            this.okButton.setEnabled(false);
                        } else {
                            FileObject fileObject = FileUtil.toFileObject((File)file);
                            if (CompareSnapshotsAction.this.snapshot.getType() != ResultsManager.getDefault().getSnapshotType(fileObject)) {
                                this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_DifferentSnapshotsTypeMsg());
                            } else if (CompareSnapshotsAction.this.snapshot.getSettings().getAllocTrackEvery() != ResultsManager.getDefault().getSnapshotSettings(fileObject).getAllocTrackEvery()) {
                                this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_DifferentObjectsCountsMsg());
                            } else {
                                this.externalFileHintLabel.setText(" ");
                            }
                            this.okButton.setEnabled(CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, fileObject));
                        }
                    } else {
                        this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_InvalidFileMsg());
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_EnterFileMsg());
                    this.okButton.setEnabled(false);
                }
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    private static class SelectExternalSnapshotsPanel
    extends JPanel
    implements HelpCtx.Provider {
        private JButton okButton;
        private JButton snapshot1Button;
        private JButton snapshot2Button;
        private JLabel hintLabel;
        private JLabel snapshot1Label;
        private JLabel snapshot2Label;
        private JTextField snapshot1Field;
        private JTextField snapshot2Field;

        public SelectExternalSnapshotsPanel() {
            this.initComponents();
        }

        public HelpCtx getHelpCtx() {
            return EXTERNAL_SNAPSHOT_HELP_CTX;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public String getSnapshot1Filename() {
            return this.snapshot1Field.getText();
        }

        public String getSnapshot2Filename() {
            return this.snapshot2Field.getText();
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.CompareSnapshotsAction_OkButtonText());
            this.setLayout(new GridBagLayout());
            this.snapshot1Label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.snapshot1Label, (String)Bundle.CompareSnapshotsAction_Snapshot1String());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 5, 5);
            this.add((Component)this.snapshot1Label, gridBagConstraints);
            this.snapshot1Field = new JTextField();
            this.snapshot1Field.setPreferredSize(new Dimension(250, this.snapshot1Field.getPreferredSize().height));
            this.snapshot1Label.setLabelFor(this.snapshot1Field);
            this.snapshot1Field.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SnapshotAccessDescr());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 5, 5, 5);
            this.add((Component)this.snapshot1Field, gridBagConstraints);
            this.snapshot1Button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.snapshot1Button, (String)Bundle.CompareSnapshotsAction_BrowseButtonText());
            this.snapshot1Button.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_BrowseButtonAccessDescr());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 5, 5, 10);
            this.add((Component)this.snapshot1Button, gridBagConstraints);
            this.snapshot2Label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.snapshot2Label, (String)Bundle.CompareSnapshotsAction_Snapshot2String());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 5);
            this.add((Component)this.snapshot2Label, gridBagConstraints);
            this.snapshot2Field = new JTextField();
            this.snapshot2Field.setPreferredSize(new Dimension(250, this.snapshot2Field.getPreferredSize().height));
            this.snapshot2Label.setLabelFor(this.snapshot2Field);
            this.snapshot2Field.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SnapshotAccessDescr());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.snapshot2Field, gridBagConstraints);
            this.snapshot2Button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.snapshot2Button, (String)Bundle.CompareSnapshotsAction_Browse2ButtonText());
            this.snapshot2Button.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_BrowseButtonAccessDescr());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.snapshot2Button, gridBagConstraints);
            this.hintLabel = new JLabel(" ");
            this.hintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.hintLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), gridBagConstraints);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }
            };
            this.snapshot1Field.getDocument().addDocumentListener(documentListener);
            this.snapshot2Field.getDocument().addDocumentListener(documentListener);
            this.snapshot1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectExternalSnapshotsPanel.this.getSnapshot1Filename()));
                    if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectExternalSnapshotsPanel.this.snapshot1Field.setText(file.getAbsolutePath());
                    }
                }
            });
            this.snapshot2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectExternalSnapshotsPanel.this.getSnapshot2Filename().length() == 0 ? SelectExternalSnapshotsPanel.this.getSnapshot1Filename() : SelectExternalSnapshotsPanel.this.getSnapshot2Filename()));
                    if (jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectExternalSnapshotsPanel.this.snapshot2Field.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            String string = this.getSnapshot1Filename();
            String string2 = this.getSnapshot2Filename();
            if (string.length() > 0 && string2.length() > 0) {
                final File file = new File(string);
                final File file2 = new File(string2);
                if (file.exists() && file.isFile() && file2.exists() && file2.isFile()) {
                    if (file.equals(file2)) {
                        this.hintLabel.setText(Bundle.CompareSnapshotsAction_ComparingSameSnapshotsMsg());
                        this.okButton.setEnabled(false);
                    } else {
                        new NBSwingWorker(true){
                            private String hintStr;
                            private boolean enabledOk;

                            protected void doInBackground() {
                                ResultsManager resultsManager = ResultsManager.getDefault();
                                FileObject fileObject = FileUtil.toFileObject((File)file);
                                FileObject fileObject2 = FileUtil.toFileObject((File)file2);
                                int n = resultsManager.getSnapshotType(fileObject);
                                int n2 = resultsManager.getSnapshotType(fileObject2);
                                if (n == 0 || n2 == 0) {
                                    this.hintStr = Bundle.CompareSnapshotsAction_InvalidFilesMsg();
                                    SelectExternalSnapshotsPanel.this.okButton.setEnabled(false);
                                } else if (n != n2) {
                                    this.hintStr = Bundle.CompareSnapshotsAction_DifferentSnapshotsTypeMsg();
                                    this.enabledOk = false;
                                } else {
                                    ProfilingSettings profilingSettings = resultsManager.getSnapshotSettings(fileObject);
                                    ProfilingSettings profilingSettings2 = resultsManager.getSnapshotSettings(fileObject2);
                                    if (profilingSettings == null || profilingSettings2 == null) {
                                        this.hintStr = Bundle.CompareSnapshotsAction_InvalidFilesMsg();
                                        SelectExternalSnapshotsPanel.this.okButton.setEnabled(false);
                                    } else if (profilingSettings.getAllocTrackEvery() != profilingSettings2.getAllocTrackEvery()) {
                                        this.hintStr = Bundle.CompareSnapshotsAction_DifferentObjectsCountsMsg();
                                        this.enabledOk = false;
                                    } else {
                                        this.hintStr = " ";
                                        this.enabledOk = CompareSnapshotsAction.areComparableSnapshots(fileObject, fileObject2);
                                    }
                                }
                            }

                            protected void done() {
                                SelectExternalSnapshotsPanel.this.hintLabel.setText(this.hintStr);
                                SelectExternalSnapshotsPanel.this.okButton.setEnabled(this.enabledOk);
                            }
                        }.execute();
                    }
                } else {
                    this.hintLabel.setText(Bundle.CompareSnapshotsAction_InvalidFilesMsg());
                    this.okButton.setEnabled(false);
                }
            } else {
                this.hintLabel.setText(Bundle.CompareSnapshotsAction_SelectSnapshotsString());
                this.okButton.setEnabled(false);
            }
        }
    }
}

