/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.base.DOMDocument;
import writer2latex.xhtml.XhtmlConfig;

public class XhtmlDocument
extends DOMDocument {
    public static final int XHTML10 = 0;
    public static final int XHTML11 = 1;
    public static final int XHTML_MATHML = 2;
    public static final int HTML5 = 3;
    private static final String[] sExtension = new String[]{".html", ".xhtml", ".xhtml", ".html"};
    private static Set<String> blockPrettyPrint = new HashSet<String>();
    private static Set<String> conditionalBlockPrettyPrint;
    private static Set<String> emptyElements;
    private static Set<String> emptyHtml5Elements;
    private static String[] entities;
    private int nType;
    private String sEncoding = "UTF-8";
    private boolean bUseNamedEntities = false;
    private boolean bHexadecimalEntities = true;
    private char cLimit = (char)65535;
    private boolean bNoDoctype = false;
    private boolean bAddBOM = false;
    private boolean bPrettyPrint = true;
    private String sContentId = "content";
    private String sHeaderId = "header";
    private String sFooterId = "footer";
    private String sPanelId = "panel";
    private Element headNode = null;
    private Element bodyNode = null;
    private Element titleNode = null;
    private Element contentNode = null;
    private Element panelNode = null;
    private Element headerNode = null;
    private Element footerNode = null;

    public static final String getExtension(int nType) {
        return sExtension[nType];
    }

    public XhtmlDocument(String name, int nType) {
        super(name, sExtension[nType]);
        this.nType = nType;
        Document contentDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            String[] sDocType = this.getDoctypeStrings();
            DocumentType doctype = domImpl.createDocumentType("html", sDocType[0], sDocType[1]);
            contentDOM = domImpl.createDocument("http://www.w3.org/1999/xhtml", "html", doctype);
            contentDOM.getDocumentElement().setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            this.headNode = contentDOM.createElement("head");
            this.titleNode = contentDOM.createElement("title");
            this.bodyNode = contentDOM.createElement("body");
            contentDOM.getDocumentElement().appendChild(this.headNode);
            this.headNode.appendChild(this.titleNode);
            contentDOM.getDocumentElement().appendChild(this.bodyNode);
            this.contentNode = this.bodyNode;
            this.setContentDOM(contentDOM);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMIMEType() {
        switch (this.nType) {
            case 0: {
                return "text/html";
            }
            case 1: {
                return "application/xhtml+xml";
            }
            case 2: {
                return "application/xhtml+xml";
            }
            case 3: {
                return "text/html5";
            }
        }
        return "";
    }

    @Override
    public boolean isMasterDocument() {
        return true;
    }

    public Element getHeadNode() {
        return this.headNode;
    }

    public Element getBodyNode() {
        return this.bodyNode;
    }

    public Element getTitleNode() {
        return this.titleNode;
    }

    public Element getContentNode() {
        return this.contentNode;
    }

    public void setContentNode(Element contentNode) {
        this.contentNode = contentNode;
    }

    public Element getPanelNode() {
        return this.panelNode;
    }

    public Element getHeaderNode() {
        return this.headerNode;
    }

    public Element getFooterNode() {
        return this.footerNode;
    }

    public void createHeaderFooter() {
        if (this.nType == 3) {
            Element header1 = this.getContentDOM().createElement("header");
            this.bodyNode.appendChild(header1);
            this.headerNode = this.getContentDOM().createElement("nav");
            header1.appendChild(this.headerNode);
        } else {
            this.headerNode = this.getContentDOM().createElement("div");
            this.bodyNode.appendChild(this.headerNode);
        }
        this.headerNode.setAttribute("id", this.sHeaderId);
        this.contentNode = this.getContentDOM().createElement("div");
        this.contentNode.setAttribute("id", this.sContentId);
        this.bodyNode.appendChild(this.contentNode);
        if (this.nType == 3) {
            Element footer1 = this.getContentDOM().createElement("footer");
            this.bodyNode.appendChild(footer1);
            this.footerNode = this.getContentDOM().createElement("nav");
            footer1.appendChild(this.footerNode);
        } else {
            this.footerNode = this.getContentDOM().createElement("div");
            this.bodyNode.appendChild(this.footerNode);
        }
        this.footerNode.setAttribute("id", this.sFooterId);
    }

    public void setContentDOM(Document doc) {
        super.setContentDOM(doc);
        this.collectNodes();
    }

    public boolean hasMath() {
        return this.hasMath(this.getContentDOM().getDocumentElement());
    }

    private boolean hasMath(Element node) {
        if (node.getTagName().equals("math")) {
            return true;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !this.hasMath((Element)child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(InputStream is) throws IOException {
        super.read(is);
        this.collectNodes();
    }

    public void readFromTemplate(XhtmlDocument template) {
        Document templateDOM = template.getContentDOM();
        Document newDOM = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            String[] sDocType = this.getDoctypeStrings();
            DocumentType doctype = domImpl.createDocumentType("html", sDocType[0], sDocType[1]);
            newDOM = domImpl.createDocument("http://www.w3.org/1999/xhtml", templateDOM.getDocumentElement().getTagName(), doctype);
            this.setContentDOM(newDOM);
            Element templateRoot = templateDOM.getDocumentElement();
            Element newRoot = newDOM.getDocumentElement();
            NamedNodeMap attributes = templateRoot.getAttributes();
            int nCount = attributes.getLength();
            for (int i = 0; i < nCount; ++i) {
                Node attrNode = attributes.item(i);
                newRoot.setAttribute(attrNode.getNodeName(), attrNode.getNodeValue());
            }
            NodeList children = templateRoot.getChildNodes();
            int nLen = children.getLength();
            for (int i = 0; i < nLen; ++i) {
                newRoot.appendChild(this.getContentDOM().importNode(children.item(i), true));
            }
            this.collectNodes();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String[] getDoctypeStrings() {
        String sPublicId = null;
        String sSystemId = null;
        switch (this.nType) {
            case 0: {
                sPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                sSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
                break;
            }
            case 1: {
                sPublicId = "-//W3C//DTD XHTML 1.1//EN";
                sSystemId = "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd";
                break;
            }
            case 2: {
                sPublicId = "-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN";
                sSystemId = "http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd";
            }
        }
        return new String[]{sPublicId, sSystemId};
    }

    private void collectNodes(Element elm) {
        String sTagName = elm.getTagName();
        if ("head".equals(sTagName)) {
            this.headNode = elm;
        } else if ("body".equals(sTagName)) {
            this.bodyNode = elm;
        } else if ("title".equals(sTagName)) {
            this.titleNode = elm;
        } else {
            String sId = elm.getAttribute("id");
            if (this.sContentId.equals(sId)) {
                this.contentNode = elm;
            } else if (this.sHeaderId.equals(sId)) {
                this.headerNode = elm;
            } else if (this.sFooterId.equals(sId)) {
                this.footerNode = elm;
            } else if (this.sPanelId.equals(sId)) {
                this.panelNode = elm;
            }
        }
        for (Node child = elm.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.collectNodes((Element)child);
        }
    }

    private void collectNodes() {
        this.headNode = null;
        this.bodyNode = null;
        this.titleNode = null;
        this.contentNode = null;
        this.headerNode = null;
        this.footerNode = null;
        this.panelNode = null;
        Element elm = this.getContentDOM().getDocumentElement();
        this.collectNodes(elm);
        if (this.contentNode == null) {
            Element element = this.contentNode = this.bodyNode != null ? this.bodyNode : elm;
        }
        if (this.headNode != null && this.titleNode == null) {
            this.titleNode = this.getContentDOM().createElement("title");
            this.headNode.appendChild(this.titleNode);
        }
    }

    public void setConfig(XhtmlConfig config) {
        this.sEncoding = config.xhtmlEncoding().toUpperCase();
        if ("UTF-16".equals(this.sEncoding)) {
            this.cLimit = (char)65535;
        } else if ("ISO-8859-1".equals(this.sEncoding)) {
            this.cLimit = (char)255;
        } else if ("US-ASCII".equals(this.sEncoding)) {
            this.cLimit = (char)127;
        } else {
            this.sEncoding = "UTF-8";
            this.cLimit = (char)65535;
        }
        this.bAddBOM = config.xhtmlAddBOM() && this.sEncoding.equals("UTF-8");
        this.bNoDoctype = config.xhtmlNoDoctype();
        this.bPrettyPrint = config.prettyPrint();
        this.bUseNamedEntities = config.useNamedEntities();
        this.bHexadecimalEntities = config.hexadecimalEntities();
        String[] sTemplateIds = config.templateIds().split(",");
        int nIdCount = sTemplateIds.length;
        this.sContentId = nIdCount > 0 && sTemplateIds[0].trim().length() > 0 ? sTemplateIds[0].trim() : "content";
        this.sHeaderId = nIdCount > 1 ? sTemplateIds[1].trim() : "header";
        this.sFooterId = nIdCount > 2 ? sTemplateIds[2].trim() : "footer";
        this.sPanelId = nIdCount > 3 ? sTemplateIds[3].trim() : "panel";
    }

    public String getEncoding() {
        return this.sEncoding;
    }

    @Override
    public String getFileExtension() {
        return super.getFileExtension();
    }

    private void optimize(Element node, String sLang, String sDir) {
        if (node.hasAttribute("xml:lang")) {
            if (node.getAttribute("xml:lang").equals(sLang)) {
                node.removeAttribute("xml:lang");
                if (node.hasAttribute("lang")) {
                    node.removeAttribute("lang");
                }
            } else {
                sLang = node.getAttribute("xml:lang");
            }
        }
        if (node.hasAttribute("xml:dir")) {
            if (node.getAttribute("xml:dir").equals(sDir)) {
                node.removeAttribute("xml:dir");
            } else {
                sDir = node.getAttribute("xml:dir");
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.optimize((Element)child, sLang, sDir);
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, this.sEncoding);
        if (this.bAddBOM) {
            osw.write("\ufeff");
        }
        if (this.nType != 0 && this.nType != 3) {
            osw.write("<?xml version=\"1.0\" encoding=\"" + this.sEncoding + "\" ?>\n");
        }
        if (!this.bNoDoctype) {
            if (this.nType == 3) {
                osw.write("<!DOCTYPE html>\n");
            } else {
                DocumentType docType = this.getContentDOM().getDoctype();
                if (docType != null) {
                    osw.write("<!DOCTYPE html PUBLIC \"");
                    osw.write(docType.getPublicId());
                    osw.write("\" \"");
                    osw.write(docType.getSystemId());
                    osw.write("\">\n");
                }
            }
        }
        Element doc = this.getContentDOM().getDocumentElement();
        this.optimize(doc, null, null);
        this.write(doc, this.bPrettyPrint ? 0 : -1, osw);
        osw.flush();
        osw.close();
    }

    private static boolean blockThis(Element node) {
        String sTagName = node.getTagName();
        if (blockPrettyPrint.contains(sTagName)) {
            return true;
        }
        if (conditionalBlockPrettyPrint.contains(sTagName)) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || blockPrettyPrint.contains(child.getNodeName())) continue;
                return true;
            }
            return false;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(String sTagName) {
        return this.nType == 3 ? emptyHtml5Elements.contains(sTagName) : emptyElements.contains(sTagName);
    }

    private void write(Node node, int nLevel, OutputStreamWriter osw) throws IOException {
        short nType = node.getNodeType();
        switch (nType) {
            case 1: {
                if (this.isEmpty(node.getNodeName())) {
                    String sNodeName = node.getNodeName();
                    if (nLevel >= 0) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("<" + sNodeName);
                    this.writeAttributes(node, osw);
                    osw.write(" />");
                    if (nLevel < 0) break;
                    osw.write("\n");
                    break;
                }
                if (node.hasChildNodes()) {
                    boolean bRedundantElement;
                    int nNextLevel = nLevel < 0 || XhtmlDocument.blockThis((Element)node) ? -1 : nLevel + 1;
                    boolean bl = bRedundantElement = !node.hasAttributes() && (node.getNodeName().equals("a") || node.getNodeName().equals("span"));
                    if (!bRedundantElement) {
                        if (nLevel >= 0) {
                            this.writeSpaces(nLevel, osw);
                        }
                        osw.write("<" + node.getNodeName());
                        this.writeAttributes(node, osw);
                        osw.write(">");
                        if (nNextLevel >= 0) {
                            osw.write("\n");
                        }
                    }
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        this.write(child, nNextLevel, osw);
                    }
                    if (bRedundantElement) break;
                    if (nNextLevel >= 0) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("</" + node.getNodeName() + ">");
                    if (nLevel < 0) break;
                    osw.write("\n");
                    break;
                }
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<" + node.getNodeName());
                this.writeAttributes(node, osw);
                if (nType <= 1 || nType == 3) {
                    osw.write("></" + node.getNodeName() + ">");
                } else {
                    osw.write(" />");
                }
                if (nLevel < 0) break;
                osw.write("\n");
                break;
            }
            case 3: {
                this.write(node.getNodeValue(), osw);
                break;
            }
            case 8: {
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<!-- ");
                this.write(node.getNodeValue(), osw);
                osw.write(" -->");
                if (nLevel < 0) break;
                osw.write("\n");
            }
        }
    }

    private void writeAttributes(Node node, OutputStreamWriter osw) throws IOException {
        NamedNodeMap attr = node.getAttributes();
        int nLen = attr.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node item = attr.item(i);
            osw.write(" ");
            this.write(item.getNodeName(), osw);
            osw.write("=\"");
            this.writeAttribute(item.getNodeValue(), osw);
            osw.write("\"");
        }
    }

    private void writeSpaces(int nCount, OutputStreamWriter osw) throws IOException {
        for (int i = 0; i < nCount; ++i) {
            osw.write("  ");
        }
    }

    private void write(String s, OutputStreamWriter osw) throws IOException {
        if (s == null) {
            osw.write("null");
            return;
        }
        int nLen = s.length();
        block5: for (int i = 0; i < nLen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    osw.write("&lt;");
                    continue block5;
                }
                case '>': {
                    osw.write("&gt;");
                    continue block5;
                }
                case '&': {
                    osw.write("&amp;");
                    continue block5;
                }
                default: {
                    this.write(c, osw);
                }
            }
        }
    }

    private void writeAttribute(String s, OutputStreamWriter osw) throws IOException {
        int nLen = s.length();
        block7: for (int i = 0; i < nLen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    osw.write("&lt;");
                    continue block7;
                }
                case '>': {
                    osw.write("&gt;");
                    continue block7;
                }
                case '&': {
                    osw.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    osw.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    osw.write(this.nType == 0 ? "&#39;" : "&apos;");
                    continue block7;
                }
                default: {
                    this.write(c, osw);
                }
            }
        }
    }

    private void write(char c, OutputStreamWriter osw) throws IOException {
        if (this.bUseNamedEntities) {
            if (c < '\u0100' && entities[c] != null) {
                osw.write(entities[c]);
                return;
            }
            String s = this.getMathMLEntity(c);
            if (s != null && this.nType == 2) {
                osw.write(s);
                return;
            }
        }
        if (c > this.cLimit) {
            if (this.bHexadecimalEntities) {
                osw.write("&#x" + Integer.toHexString(c).toUpperCase() + ";");
            } else {
                osw.write("&#" + Integer.toString(c).toUpperCase() + ";");
            }
        } else {
            osw.write(c);
        }
    }

    private String getMathMLEntity(char c) {
        switch (c) {
            case '\u0192': {
                return "&fnof;";
            }
            case '\u0391': {
                return "&Alpha;";
            }
            case '\u0392': {
                return "&Beta;";
            }
            case '\u0393': {
                return "&Gamma;";
            }
            case '\u0394': {
                return "&Delta;";
            }
            case '\u0395': {
                return "&Epsilon;";
            }
            case '\u0396': {
                return "&Zeta;";
            }
            case '\u0397': {
                return "&Eta;";
            }
            case '\u0398': {
                return "&Theta;";
            }
            case '\u0399': {
                return "&Iota;";
            }
            case '\u039a': {
                return "&Kappa;";
            }
            case '\u039b': {
                return "&Lambda;";
            }
            case '\u039c': {
                return "&Mu;";
            }
            case '\u039d': {
                return "&Nu;";
            }
            case '\u039e': {
                return "&Xi;";
            }
            case '\u039f': {
                return "&Omicron;";
            }
            case '\u03a0': {
                return "&Pi;";
            }
            case '\u03a1': {
                return "&Rho;";
            }
            case '\u03a3': {
                return "&Sigma;";
            }
            case '\u03a4': {
                return "&Tau;";
            }
            case '\u03a5': {
                return "&Upsilon;";
            }
            case '\u03a6': {
                return "&Phi;";
            }
            case '\u03a7': {
                return "&Chi;";
            }
            case '\u03a8': {
                return "&Psi;";
            }
            case '\u03a9': {
                return "&Omega;";
            }
            case '\u03b1': {
                return "&alpha;";
            }
            case '\u03b2': {
                return "&beta;";
            }
            case '\u03b3': {
                return "&gamma;";
            }
            case '\u03b4': {
                return "&delta;";
            }
            case '\u03b5': {
                return "&epsilon;";
            }
            case '\u03b6': {
                return "&zeta;";
            }
            case '\u03b7': {
                return "&eta;";
            }
            case '\u03b8': {
                return "&theta;";
            }
            case '\u03b9': {
                return "&iota;";
            }
            case '\u03ba': {
                return "&kappa;";
            }
            case '\u03bb': {
                return "&lambda;";
            }
            case '\u03bc': {
                return "&mu;";
            }
            case '\u03bd': {
                return "&nu;";
            }
            case '\u03be': {
                return "&xi;";
            }
            case '\u03bf': {
                return "&omicron;";
            }
            case '\u03c0': {
                return "&pi;";
            }
            case '\u03c1': {
                return "&rho;";
            }
            case '\u03c2': {
                return "&sigmaf;";
            }
            case '\u03c3': {
                return "&sigma;";
            }
            case '\u03c4': {
                return "&tau;";
            }
            case '\u03c5': {
                return "&upsilon;";
            }
            case '\u03c6': {
                return "&phi;";
            }
            case '\u03c7': {
                return "&chi;";
            }
            case '\u03c8': {
                return "&psi;";
            }
            case '\u03c9': {
                return "&omega;";
            }
            case '\u03d1': {
                return "&thetasym;";
            }
            case '\u03d2': {
                return "&upsih;";
            }
            case '\u03d6': {
                return "&piv;";
            }
            case '\u2022': {
                return "&bull;";
            }
            case '\u2026': {
                return "&hellip;";
            }
            case '\u2032': {
                return "&prime;";
            }
            case '\u2033': {
                return "&Prime;";
            }
            case '\u203e': {
                return "&oline;";
            }
            case '\u2044': {
                return "&frasl;";
            }
            case '\u2118': {
                return "&weierp;";
            }
            case '\u2111': {
                return "&image;";
            }
            case '\u211c': {
                return "&real;";
            }
            case '\u2122': {
                return "&trade;";
            }
            case '\u2135': {
                return "&alefsym;";
            }
            case '\u2190': {
                return "&larr;";
            }
            case '\u2191': {
                return "&uarr;";
            }
            case '\u2192': {
                return "&rarr;";
            }
            case '\u2193': {
                return "&darr;";
            }
            case '\u2194': {
                return "&harr;";
            }
            case '\u21b5': {
                return "&crarr;";
            }
            case '\u21d0': {
                return "&lArr;";
            }
            case '\u21d1': {
                return "&uArr;";
            }
            case '\u21d2': {
                return "&rArr;";
            }
            case '\u21d3': {
                return "&dArr;";
            }
            case '\u21d4': {
                return "&hArr;";
            }
            case '\u2200': {
                return "&forall;";
            }
            case '\u2202': {
                return "&part;";
            }
            case '\u2203': {
                return "&exist;";
            }
            case '\u2205': {
                return "&empty;";
            }
            case '\u2207': {
                return "&nabla;";
            }
            case '\u2208': {
                return "&isin;";
            }
            case '\u2209': {
                return "&notin;";
            }
            case '\u220b': {
                return "&ni;";
            }
            case '\u220f': {
                return "&prod;";
            }
            case '\u2211': {
                return "&sum;";
            }
            case '\u2212': {
                return "&minus;";
            }
            case '\u2217': {
                return "&lowast;";
            }
            case '\u221a': {
                return "&radic;";
            }
            case '\u221d': {
                return "&prop;";
            }
            case '\u221e': {
                return "&infin;";
            }
            case '\u2220': {
                return "&ang;";
            }
            case '\u2227': {
                return "&and;";
            }
            case '\u2228': {
                return "&or;";
            }
            case '\u2229': {
                return "&cap;";
            }
            case '\u222a': {
                return "&cup;";
            }
            case '\u222b': {
                return "&int;";
            }
            case '\u2234': {
                return "&there4;";
            }
            case '\u223c': {
                return "&sim;";
            }
            case '\u2245': {
                return "&cong;";
            }
            case '\u2248': {
                return "&asymp;";
            }
            case '\u2260': {
                return "&ne;";
            }
            case '\u2261': {
                return "&equiv;";
            }
            case '\u2264': {
                return "&le;";
            }
            case '\u2265': {
                return "&ge;";
            }
            case '\u2282': {
                return "&sub;";
            }
            case '\u2283': {
                return "&sup;";
            }
            case '\u2284': {
                return "&nsub;";
            }
            case '\u2286': {
                return "&sube;";
            }
            case '\u2287': {
                return "&supe;";
            }
            case '\u2295': {
                return "&oplus;";
            }
            case '\u2297': {
                return "&otimes;";
            }
            case '\u22a5': {
                return "&perp;";
            }
            case '\u22c5': {
                return "&sdot;";
            }
            case '\u2308': {
                return "&lceil;";
            }
            case '\u2309': {
                return "&rceil;";
            }
            case '\u230a': {
                return "&lfloor;";
            }
            case '\u230b': {
                return "&rfloor;";
            }
            case '\u2329': {
                return "&lang;";
            }
            case '\u232a': {
                return "&rang;";
            }
            case '\u25ca': {
                return "&loz;";
            }
            case '\u2660': {
                return "&spades;";
            }
            case '\u2663': {
                return "&clubs;";
            }
            case '\u2665': {
                return "&hearts;";
            }
            case '\u2666': {
                return "&diams;";
            }
            case '\u2102': {
                return "&Copf;";
            }
            case '\u2115': {
                return "&Nopf;";
            }
            case '\u211a': {
                return "&Qopf;";
            }
            case '\u211d': {
                return "&Ropf;";
            }
            case '\u2124': {
                return "&Zopf;";
            }
            case '\u2223': {
                return "&mid;";
            }
            case '\u2224': {
                return "&nmid;";
            }
            case '\u2243': {
                return "&simeq;";
            }
            case '\u2244': {
                return "&nsimeq;";
            }
            case '\u2225': {
                return "&par;";
            }
            case '\u00b1': {
                return "&PlusMinus;";
            }
            case '\u2213': {
                return "&MinusPlus;";
            }
            case '\u2494': {
                return "&leqslant;";
            }
            case '\u2270': {
                return "&nle;";
            }
            case '\u00ac': {
                return "&not;";
            }
            case '\u00b0': {
                return "&circ;";
            }
            case '\u224a': {
                return "&ape;";
            }
            case '+': {
                return "&plus;";
            }
            case '\u00d7': {
                return "&times;";
            }
            case '=': {
                return "&equals;";
            }
            case '\u226e': {
                return "&nlt;";
            }
            case '\u2a7d': {
                return "&les;";
            }
            case '\u220a': {
                return "&isin;";
            }
            case '\u2216': {
                return "&setminus;";
            }
            case '\u2288': {
                return "&nsube;";
            }
            case '\u2289': {
                return "&nsupe;";
            }
            case '\u2285': {
                return "&nsup;";
            }
            case '\u301a': {
                return "&lobrk;";
            }
            case '\u301b': {
                return "&robrk;";
            }
            case '\u2210': {
                return "&coprod;";
            }
            case '\u222c': {
                return "&Int;";
            }
            case '\u222d': {
                return "&tint;";
            }
            case '\u222e': {
                return "&conint;";
            }
            case '\u222f': {
                return "&Conint;";
            }
            case '\u2230': {
                return "&Cconint;";
            }
            case '\u210f': {
                return "&hbar;";
            }
            case '\u2253': {
                return "&;";
            }
            case '\u22ee': {
                return "&vellip;";
            }
            case '\u22ef': {
                return "&ctdot;";
            }
            case '\u22f0': {
                return "&utdot;";
            }
            case '\u22f1': {
                return "&dtdot;";
            }
            case '\u02da': {
                return "&ring;";
            }
            case '\u00a8': {
                return "&Dot;";
            }
            case '\u02d9': {
                return "&dot;";
            }
            case '\u2015': {
                return "&horbar;";
            }
            case '\u00af': {
                return "&macr;";
            }
            case '\u0332': {
                return "&UnderBar;";
            }
            case '\u2222': {
                return "&angsph;";
            }
            case '\u03f1': {
                return "&rhov;";
            }
            case '\u226b': {
                return "&Gt;";
            }
            case '\u226a': {
                return "&Lt;";
            }
        }
        return null;
    }

    static {
        blockPrettyPrint.add("p");
        blockPrettyPrint.add("h1");
        blockPrettyPrint.add("h2");
        blockPrettyPrint.add("h3");
        blockPrettyPrint.add("h4");
        blockPrettyPrint.add("h5");
        blockPrettyPrint.add("h6");
        conditionalBlockPrettyPrint = new HashSet<String>();
        conditionalBlockPrettyPrint.add("li");
        conditionalBlockPrettyPrint.add("th");
        conditionalBlockPrettyPrint.add("td");
        emptyElements = new HashSet<String>();
        emptyElements.add("base");
        emptyElements.add("meta");
        emptyElements.add("link");
        emptyElements.add("hr");
        emptyElements.add("br");
        emptyElements.add("param");
        emptyElements.add("img");
        emptyElements.add("area");
        emptyElements.add("input");
        emptyElements.add("col");
        emptyHtml5Elements = new HashSet<String>();
        emptyHtml5Elements.add("base");
        emptyHtml5Elements.add("meta");
        emptyHtml5Elements.add("link");
        emptyHtml5Elements.add("hr");
        emptyHtml5Elements.add("br");
        emptyHtml5Elements.add("param");
        emptyHtml5Elements.add("img");
        emptyHtml5Elements.add("area");
        emptyHtml5Elements.add("input");
        emptyHtml5Elements.add("col");
        emptyHtml5Elements.add("command");
        emptyHtml5Elements.add("embed");
        emptyHtml5Elements.add("keygen");
        emptyHtml5Elements.add("source");
        entities = new String[256];
        XhtmlDocument.entities[160] = "&nbsp;";
        XhtmlDocument.entities[161] = "&iexcl;";
        XhtmlDocument.entities[162] = "&cent;";
        XhtmlDocument.entities[163] = "&pound;";
        XhtmlDocument.entities[164] = "&curren;";
        XhtmlDocument.entities[165] = "&yen;";
        XhtmlDocument.entities[166] = "&brvbar;";
        XhtmlDocument.entities[167] = "&sect;";
        XhtmlDocument.entities[168] = "&uml;";
        XhtmlDocument.entities[169] = "&copy;";
        XhtmlDocument.entities[170] = "&ordf;";
        XhtmlDocument.entities[171] = "&laquo;";
        XhtmlDocument.entities[172] = "&not;";
        XhtmlDocument.entities[173] = "&shy;";
        XhtmlDocument.entities[174] = "&reg;";
        XhtmlDocument.entities[175] = "&macr;";
        XhtmlDocument.entities[176] = "&deg;";
        XhtmlDocument.entities[177] = "&plusmn;";
        XhtmlDocument.entities[178] = "&sup2;";
        XhtmlDocument.entities[179] = "&sup3;";
        XhtmlDocument.entities[180] = "&acute;";
        XhtmlDocument.entities[181] = "&micro;";
        XhtmlDocument.entities[182] = "&para;";
        XhtmlDocument.entities[183] = "&middot;";
        XhtmlDocument.entities[184] = "&cedil;";
        XhtmlDocument.entities[185] = "&sup1;";
        XhtmlDocument.entities[186] = "&ordm;";
        XhtmlDocument.entities[187] = "&raquo;";
        XhtmlDocument.entities[188] = "&frac14;";
        XhtmlDocument.entities[189] = "&frac12;";
        XhtmlDocument.entities[190] = "&frac34;";
        XhtmlDocument.entities[191] = "&iquest;";
        XhtmlDocument.entities[215] = "&times;";
        XhtmlDocument.entities[247] = "&divide;";
        XhtmlDocument.entities[192] = "&Agrave;";
        XhtmlDocument.entities[193] = "&Aacute;";
        XhtmlDocument.entities[194] = "&Acirc;";
        XhtmlDocument.entities[195] = "&Atilde;";
        XhtmlDocument.entities[196] = "&Auml;";
        XhtmlDocument.entities[197] = "&Aring;";
        XhtmlDocument.entities[198] = "&AElig;";
        XhtmlDocument.entities[199] = "&Ccedil;";
        XhtmlDocument.entities[200] = "&Egrave;";
        XhtmlDocument.entities[201] = "&Eacute;";
        XhtmlDocument.entities[202] = "&Ecirc;";
        XhtmlDocument.entities[203] = "&Euml;";
        XhtmlDocument.entities[204] = "&Igrave;";
        XhtmlDocument.entities[205] = "&Iacute;";
        XhtmlDocument.entities[206] = "&Icirc;";
        XhtmlDocument.entities[207] = "&Iuml;";
        XhtmlDocument.entities[208] = "&ETH;";
        XhtmlDocument.entities[209] = "&Ntilde;";
        XhtmlDocument.entities[210] = "&Ograve;";
        XhtmlDocument.entities[211] = "&Oacute;";
        XhtmlDocument.entities[212] = "&Ocirc;";
        XhtmlDocument.entities[213] = "&Otilde;";
        XhtmlDocument.entities[214] = "&Ouml;";
        XhtmlDocument.entities[216] = "&Oslash;";
        XhtmlDocument.entities[217] = "&Ugrave;";
        XhtmlDocument.entities[218] = "&Uacute;";
        XhtmlDocument.entities[219] = "&Ucirc;";
        XhtmlDocument.entities[220] = "&Uuml;";
        XhtmlDocument.entities[221] = "&Yacute;";
        XhtmlDocument.entities[222] = "&THORN;";
        XhtmlDocument.entities[223] = "&szlig;";
        XhtmlDocument.entities[224] = "&agrave;";
        XhtmlDocument.entities[225] = "&aacute;";
        XhtmlDocument.entities[226] = "&acirc;";
        XhtmlDocument.entities[227] = "&atilde;";
        XhtmlDocument.entities[228] = "&auml;";
        XhtmlDocument.entities[229] = "&aring;";
        XhtmlDocument.entities[230] = "&aelig;";
        XhtmlDocument.entities[231] = "&ccedil;";
        XhtmlDocument.entities[232] = "&egrave;";
        XhtmlDocument.entities[233] = "&eacute;";
        XhtmlDocument.entities[234] = "&ecirc;";
        XhtmlDocument.entities[235] = "&euml;";
        XhtmlDocument.entities[236] = "&igrave;";
        XhtmlDocument.entities[237] = "&iacute;";
        XhtmlDocument.entities[238] = "&icirc;";
        XhtmlDocument.entities[239] = "&iuml;";
        XhtmlDocument.entities[240] = "&eth;";
        XhtmlDocument.entities[241] = "&ntilde;";
        XhtmlDocument.entities[242] = "&ograve;";
        XhtmlDocument.entities[243] = "&oacute;";
        XhtmlDocument.entities[244] = "&ocirc;";
        XhtmlDocument.entities[245] = "&otilde;";
        XhtmlDocument.entities[246] = "&ouml;";
        XhtmlDocument.entities[248] = "&oslash;";
        XhtmlDocument.entities[249] = "&ugrave;";
        XhtmlDocument.entities[250] = "&uacute;";
        XhtmlDocument.entities[251] = "&ucirc;";
        XhtmlDocument.entities[252] = "&uuml;";
        XhtmlDocument.entities[253] = "&yacute;";
        XhtmlDocument.entities[254] = "&thorn;";
        XhtmlDocument.entities[255] = "&yuml;";
    }
}

